/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.And;
import org.basex.query.expr.Arr;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Logical;
import org.basex.query.expr.Union;
import org.basex.query.func.Function;
import org.basex.query.util.ExprList;
import org.basex.query.util.IndexCosts;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Or
extends Logical {
    public Or(InputInfo ii, Expr ... e) {
        super(ii, e);
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        Expr c = super.compile(ctx, scp);
        return c != this ? c : this.optimize(ctx, scp);
    }

    @Override
    public Expr optimize(QueryContext ctx, VarScope scp) throws QueryException {
        CmpG cmpg = null;
        ExprList el = new ExprList(this.expr.length);
        for (Expr e : this.expr) {
            boolean merged = false;
            if (e instanceof CmpG) {
                CmpG g = (CmpG)e;
                if (cmpg == null) {
                    cmpg = g;
                } else if (cmpg.union(g, ctx, scp)) {
                    merged = true;
                }
            }
            if (merged || e == Bln.FALSE) continue;
            if (e == Bln.TRUE) {
                return this.optPre(Bln.TRUE, ctx);
            }
            el.add(e);
        }
        if (el.isEmpty()) {
            return this.optPre(Bln.FALSE, ctx);
        }
        if (this.expr.length != el.size()) {
            ctx.compInfo("rewriting %", this);
            this.expr = el.finish();
        }
        this.compFlatten(ctx);
        boolean not = true;
        for (Expr e : this.expr) {
            if (e.isFunction(Function.NOT)) continue;
            not = false;
            break;
        }
        if (not) {
            ctx.compInfo("rewriting %", this);
            Expr[] inner = new Expr[this.expr.length];
            for (int i = 0; i < inner.length; ++i) {
                inner[i] = ((Arr)this.expr[i]).expr[0];
            }
            Expr and = new And(this.info, inner).optimize(ctx, scp);
            return Function.NOT.get(null, and).optimize(ctx, scp);
        }
        return this.expr.length == 1 ? Or.compBln(this.expr[0], this.info) : this;
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        for (int i = 0; i < this.expr.length - 1; ++i) {
            if (!this.expr[i].ebv(ctx, this.info).bool(this.info)) continue;
            return Bln.TRUE;
        }
        Expr last = this.expr[this.expr.length - 1];
        return this.tailCall ? last.item(ctx, ii) : (last.ebv(ctx, ii).bool(ii) ? Bln.TRUE : Bln.FALSE);
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new Or(this.info, Or.copyAll((QueryContext)ctx, (VarScope)scp, vs, (Expr[])this.expr));
    }

    @Override
    public boolean indexAccessible(IndexCosts ic) throws QueryException {
        int is = 0;
        Expr[] exprs = new Expr[]{};
        boolean ia = true;
        for (Expr e : this.expr) {
            if (e.indexAccessible(ic) && !ic.seq) {
                if (ic.costs() == 0) continue;
                is += ic.costs();
            } else {
                ia = false;
            }
            exprs = Array.add(exprs, e);
        }
        ic.costs(is);
        this.expr = exprs;
        return ia;
    }

    @Override
    public Expr indexEquivalent(IndexCosts ic) throws QueryException {
        super.indexEquivalent(ic);
        return new Union(this.info, this.expr);
    }

    @Override
    public String toString() {
        return this.toString(" or ");
    }
}

