/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.And;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.Pos;
import org.basex.query.func.Function;
import org.basex.query.util.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.InputInfo;

public abstract class Preds
extends ParseExpr {
    public Expr[] preds;
    public boolean last;
    public Pos pos;

    protected Preds(InputInfo ii, Expr[] p) {
        super(ii);
        this.preds = p;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.preds);
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        for (int p = 0; p < this.preds.length; ++p) {
            this.preds[p] = this.preds[p].compile(ctx, scp).compEbv(ctx);
        }
        return this.optimize(ctx, scp);
    }

    @Override
    public Expr optimize(QueryContext ctx, VarScope scp) throws QueryException {
        for (int p = 0; p < this.preds.length; ++p) {
            Expr pr = Pos.get(CmpV.OpV.EQ, this.preds[p], this.preds[p], this.info);
            if (pr instanceof CmpG || pr instanceof CmpV) {
                Cmp cmp = (Cmp)pr;
                if (cmp.expr[0].isFunction(Function.POSITION) && cmp.expr[1].isFunction(Function.LAST) && (cmp instanceof CmpG && ((CmpG)cmp).op == CmpG.OpG.EQ || cmp instanceof CmpV && ((CmpV)cmp).op == CmpV.OpV.EQ)) {
                    ctx.compInfo("rewriting %", pr);
                    pr = cmp.expr[1];
                }
            }
            if (pr.isValue()) {
                if (!pr.ebv(ctx, this.info).bool(this.info)) {
                    ctx.compInfo("%: removing %", this, pr);
                    return Empty.SEQ;
                }
                ctx.compInfo("%: removing %", this, pr);
                this.preds = Array.delete(this.preds, p--);
                continue;
            }
            if (pr instanceof And && !pr.has(Expr.Flag.FCS)) {
                ctx.compInfo("rewriting % to predicate(s)", pr);
                Expr[] and = ((Arr)pr).expr;
                int m = and.length - 1;
                ExprList tmp = new ExprList(this.preds.length + m);
                for (Expr e : Arrays.asList(this.preds).subList(0, p)) {
                    tmp.add(e);
                }
                for (Expr a : and) {
                    tmp.add(Function.BOOLEAN.get(null, this.info, a).compEbv(ctx));
                }
                for (Expr e : Arrays.asList(this.preds).subList(p + 1, this.preds.length)) {
                    tmp.add(e);
                }
                this.preds = tmp.finish();
                continue;
            }
            this.preds[p] = pr;
        }
        return this;
    }

    protected final boolean posIterator() {
        if (this.preds.length == 1) {
            if (this.preds[0] instanceof Int) {
                long p = ((Int)this.preds[0]).itr();
                this.preds[0] = Pos.get(p, p, this.info);
            }
            this.pos = this.preds[0] instanceof Pos ? (Pos)this.preds[0] : null;
            this.last = this.preds[0].isFunction(Function.LAST);
        }
        return this.pos != null || this.last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean preds(Item it, QueryContext ctx) throws QueryException {
        if (this.preds.length == 0) {
            return true;
        }
        Value cv = ctx.value;
        try {
            for (Expr p : this.preds) {
                ctx.value = it;
                Item i = p.test(ctx, this.info);
                if (i == null) {
                    boolean bl = false;
                    return bl;
                }
                it.score(i.score());
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ctx.value = cv;
        }
    }

    @Override
    public boolean has(Expr.Flag flag) {
        for (Expr p : this.preds) {
            if ((flag != Expr.Flag.FCS || !p.type().mayBeNumber()) && !p.has(flag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean removable(Var v) {
        for (Expr p : this.preds) {
            if (!p.uses(v)) continue;
            return false;
        }
        return true;
    }

    @Override
    public VarUsage count(Var v) {
        return VarUsage.sum(v, this.preds);
    }

    @Override
    public Expr inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        return Preds.inlineAll(ctx, scp, this.preds, v, e) ? this.optimize(ctx, scp) : null;
    }

    @Override
    public void plan(FElem plan) {
        for (Expr p : this.preds) {
            p.plan(plan);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Expr e : this.preds) {
            sb.append('[').append(e).append(']');
        }
        return sb.toString();
    }

    protected final <T extends Preds> T copy(T p) {
        p.last = this.last;
        p.pos = this.pos;
        return this.copyType(p);
    }
}

