/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Range
extends Arr {
    public Range(InputInfo ii, Expr e1, Expr e2) {
        super(ii, e1, e2);
        this.type = SeqType.ITR_ZM;
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        super.compile(ctx, scp);
        return this.optimize(ctx, scp);
    }

    @Override
    public Expr optimize(QueryContext ctx, VarScope scp) throws QueryException {
        Expr e = this;
        if (this.oneIsEmpty()) {
            e = Empty.SEQ;
        } else if (this.allAreValues()) {
            e = this.value(ctx);
        }
        return this.optPre(e, ctx);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        return this.value(ctx).iter();
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        long[] v = this.rng(ctx);
        return v == null ? Empty.SEQ : RangeSeq.get(v[0], v[1] - v[0] + 1L, true);
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new Range(this.info, this.expr[0].copy(ctx, scp, vs), this.expr[1].copy(ctx, scp, vs));
    }

    private long[] rng(QueryContext ctx) throws QueryException {
        Item a = this.expr[0].item(ctx, this.info);
        if (a == null) {
            return null;
        }
        Item b = this.expr[1].item(ctx, this.info);
        if (b == null) {
            return null;
        }
        return new long[]{this.checkItr(a), this.checkItr(b)};
    }

    @Override
    public String toString() {
        return this.toString(" to ");
    }
}

