/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import org.basex.data.FTMatch;
import org.basex.data.FTStringMatch;
import org.basex.query.QueryContext;
import org.basex.query.ft.FTExpr;
import org.basex.query.ft.FTFilter;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.ft.FTContents;
import org.basex.util.ft.FTLexer;
import org.basex.util.hash.IntObjMap;

public final class FTContent
extends FTFilter {
    private final FTContents content;

    public FTContent(InputInfo ii, FTExpr ex, FTContents cont) {
        super(ii, ex);
        this.content = cont;
    }

    @Override
    protected boolean filter(QueryContext ctx, FTMatch mtc, FTLexer lex) {
        if (this.content == FTContents.START) {
            for (FTStringMatch sm : mtc) {
                if (sm.start != 0) continue;
                return true;
            }
        } else if (this.content == FTContents.END) {
            int p = lex.count() - 1;
            for (FTStringMatch sm : mtc) {
                if (sm.end != p) continue;
                return true;
            }
        } else {
            int s = lex.count();
            boolean[] bl = new boolean[s];
            for (FTStringMatch sm : mtc) {
                if (sm.gaps) continue;
                for (int p = sm.start; p <= sm.end; ++p) {
                    bl[p] = true;
                }
            }
            for (boolean b : bl) {
                if (b) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean content() {
        return this.content != FTContents.START;
    }

    @Override
    public FTExpr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new FTContent(this.info, (FTExpr)this.expr[0].copy(ctx, scp, (IntObjMap)vs), this.content);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem("content", this.content.toString()), this.expr);
    }

    @Override
    public String toString() {
        return super.toString() + (this.content == FTContents.START ? "at start" : (this.content == FTContents.END ? "at end" : "entire content"));
    }
}

