/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Simple;
import org.basex.query.ft.FTExpr;
import org.basex.query.ft.FTWords;
import org.basex.query.func.Function;
import org.basex.query.iter.FTIter;
import org.basex.query.iter.NodeIter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.IndexContext;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FTNode;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.ft.FTMode;
import org.basex.util.hash.IntObjMap;

public final class FTIndexAccess
extends Simple {
    private final FTExpr ftexpr;
    private final IndexContext ictx;

    public FTIndexAccess(InputInfo ii, FTExpr ex, IndexContext ic) {
        super(ii);
        this.ftexpr = ex;
        this.ictx = ic;
    }

    @Override
    public NodeIter iter(final QueryContext ctx) throws QueryException {
        final FTIter ir = this.ftexpr.iter(ctx);
        return new NodeIter(){

            @Override
            public ANode next() throws QueryException {
                FTNode it = ir.next();
                if (it != null) {
                    if (ctx.ftPosData != null) {
                        ctx.ftPosData.add(it.data, it.pre, it.all);
                    }
                    it.score();
                    it.all = null;
                }
                return it;
            }
        };
    }

    @Override
    public boolean has(Expr.Flag flag) {
        return this.ftexpr.has(flag);
    }

    @Override
    public boolean removable(Var v) {
        return this.ftexpr.removable(v);
    }

    @Override
    public VarUsage count(Var v) {
        return this.ftexpr.count(v);
    }

    @Override
    public Expr inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        return this.ftexpr.inline(ctx, scp, v, e) == null ? null : this.optimize(ctx, scp);
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new FTIndexAccess(this.info, (FTExpr)this.ftexpr.copy(ctx, scp, (IntObjMap)vs), this.ictx);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.lock(this.ictx.data.meta.name) && this.ftexpr.accept(visitor);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.DATA, this.ictx.data.meta.name), this.ftexpr);
    }

    @Override
    public boolean iterable() {
        return this.ictx.iterable;
    }

    @Override
    public int exprSize() {
        return this.ftexpr.exprSize() + 1;
    }

    @Override
    public String toString() {
        Expr e = this.ftexpr;
        if (this.ftexpr instanceof FTWords) {
            FTWords f = (FTWords)this.ftexpr;
            if (f.mode == FTMode.ANY && f.occ == null) {
                e = f.query;
            }
        }
        return Function._FT_SEARCH.get(null, this.info, Str.get(this.ictx.data.meta.name), e).toString();
    }
}

