/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import org.basex.core.MainOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.ft.FTTokens;
import org.basex.query.ft.FTWildcard;
import org.basex.query.ft.FTWords;
import org.basex.query.util.Err;
import org.basex.util.Levenshtein;
import org.basex.util.Token;
import org.basex.util.ft.FTBitapSearch;
import org.basex.util.ft.FTCase;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTIterator;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;

final class FTTokenizer {
    final FTOpt opt;
    private final TokenObjMap<FTWildcard> wcCache = new TokenObjMap();
    private final TokenObjMap<FTTokens> cache = new TokenObjMap();
    private final FTBitapSearch.TokenComparator cmp;
    private final Levenshtein ls;
    private final FTWords words;

    FTTokenizer(FTWords w, QueryContext ctx) {
        this(w, ctx.ftOpt(), new Levenshtein(ctx.context.options.get(MainOptions.LSERROR)));
    }

    private FTTokenizer(FTWords w, FTOpt o, Levenshtein l) {
        this.words = w;
        this.opt = o;
        this.ls = l;
        this.cmp = new FTBitapSearch.TokenComparator(){

            @Override
            public boolean equal(byte[] in, byte[] qu) throws QueryException {
                FTWildcard ftw = null;
                if (FTTokenizer.this.opt.is(FTFlag.WC) && (ftw = (FTWildcard)FTTokenizer.this.wcCache.get(qu)) == null) {
                    ftw = new FTWildcard(qu);
                    if (!ftw.parse()) {
                        throw Err.FTREG.get(((FTTokenizer)FTTokenizer.this).words.info, new Object[]{qu});
                    }
                    FTTokenizer.this.wcCache.put(qu, ftw);
                }
                return FTTokenizer.this.opt.sw != null && FTTokenizer.this.opt.sw.contains(qu) || (FTTokenizer.this.opt.is(FTFlag.FZ) ? FTTokenizer.this.ls.similar(in, qu) : (ftw != null ? ftw.match(in) : Token.eq(in, qu)));
            }
        };
    }

    FTLexer lexer(FTLexer lex) {
        FTOpt to = lex.ftOpt();
        to.set(FTFlag.ST, this.opt.is(FTFlag.ST));
        to.set(FTFlag.DC, this.opt.is(FTFlag.DC));
        to.ln = this.opt.ln;
        to.th = this.opt.th;
        to.sd = this.opt.sd;
        to.cs = this.opt.cs != null && this.opt.cs != FTCase.INSENSITIVE ? FTCase.SENSITIVE : FTCase.INSENSITIVE;
        return new FTLexer(to).init(lex.text());
    }

    FTTokens cache(byte[] query) throws QueryException {
        FTTokens tokens = this.cache.get(query);
        if (tokens == null) {
            tokens = new FTTokens();
            this.cache.put(query, tokens);
            FTLexer quLex = new FTLexer(this.opt).init(query);
            TokenList quList = new TokenList(1);
            while (quLex.hasNext()) {
                quList.add(((FTIterator)quLex).nextToken());
            }
            tokens.add(quList);
            if (this.opt.th != null) {
                for (byte[] ext : this.opt.th.find(this.words.info, query)) {
                    TokenList tl = new TokenList(1);
                    ((FTIterator)quLex).init(ext);
                    while (quLex.hasNext()) {
                        tl.add(((FTIterator)quLex).nextToken());
                    }
                    tokens.add(tl);
                }
            }
        }
        return tokens;
    }

    int contains(FTTokens query, FTLexer input) throws QueryException {
        input.init();
        FTBitapSearch bs = new FTBitapSearch(input, query, this.cmp);
        int c = 0;
        while (bs.hasNext()) {
            int pos = bs.next();
            this.words.add(pos, pos + query.length() - 1);
            ++c;
        }
        ++this.words.matches.pos;
        this.words.first = false;
        return c;
    }

    FTTokenizer copy(FTWords ftw) {
        return new FTTokenizer(ftw, this.opt, this.ls);
    }
}

