/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.Scope;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.Single;
import org.basex.query.expr.TypeCheck;
import org.basex.query.expr.XQFunctionExpr;
import org.basex.query.func.FNInfo;
import org.basex.query.gflwor.GFLWOR;
import org.basex.query.gflwor.Let;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Ann;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Closure
extends Single
implements Scope,
XQFunctionExpr {
    private final QNm name;
    private final Var[] args;
    private final SeqType ret;
    private final Ann ann;
    private final boolean updating;
    private final EnumMap<Expr.Flag, Boolean> map = new EnumMap(Expr.Flag.class);
    private final StaticContext sc;
    private boolean compiled;
    private final VarScope scope;
    private final HashMap<Var, Expr> nonLocal;

    public Closure(InputInfo ii, SeqType r, Var[] v, Expr e, Ann a, HashMap<Var, Expr> bindings, StaticContext stc, VarScope scp) {
        this(ii, null, r, v, e, a, bindings, stc, scp);
    }

    Closure(InputInfo ii, QNm nm, SeqType r, Var[] v, Expr e, Ann a, HashMap<Var, Expr> bindings, StaticContext stc, VarScope scp) {
        super(ii, e);
        this.name = nm;
        this.args = v;
        this.ret = r;
        this.ann = a == null ? new Ann() : a;
        this.updating = this.ann.contains(Ann.Q_UPDATING);
        this.nonLocal = bindings;
        this.scope = scp;
        this.sc = stc;
    }

    @Override
    public int arity() {
        return this.args.length;
    }

    @Override
    public QNm funcName() {
        return null;
    }

    @Override
    public QNm argName(int pos) {
        return this.args[pos].name;
    }

    @Override
    public FuncType funcType() {
        return FuncType.get(this.ann, this.args, this.ret);
    }

    @Override
    public Ann annotations() {
        return this.ann;
    }

    @Override
    public void compile(QueryContext ctx) throws QueryException {
        this.compile(ctx, null);
    }

    private Collection<Map.Entry<Var, Value>> staticBindings() {
        ArrayList<Map.Entry<Var, Expr>> propagate = null;
        Iterator<Map.Entry<Var, Expr>> cls = this.nonLocal.entrySet().iterator();
        while (cls.hasNext()) {
            Map.Entry<Var, Expr> e = cls.next();
            Expr c = e.getValue();
            if (!(c instanceof Value)) continue;
            Map.Entry<Var, Expr> e2 = e;
            if (propagate == null) {
                propagate = new ArrayList<Map.Entry<Var, Expr>>();
            }
            propagate.add(e2);
            cls.remove();
        }
        return propagate == null ? Collections.emptyList() : propagate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        if (this.compiled) {
            return this;
        }
        this.compiled = true;
        for (Map.Entry<Var, Expr> e : this.nonLocal.entrySet()) {
            Expr bound = e.getValue().compile(ctx, scp);
            e.setValue(bound);
            e.getKey().refineType(bound.type(), ctx, this.info);
        }
        try {
            this.expr = this.expr.compile(ctx, this.scope);
        }
        catch (QueryException qe) {
            this.expr = FNInfo.error(qe, this.ret != null ? this.ret : this.expr.type());
        }
        finally {
            this.scope.cleanUp(this);
        }
        this.expr.markTailCalls(ctx);
        return this.optimize(ctx, scp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expr optimize(QueryContext ctx, VarScope scp) throws QueryException {
        SeqType r = this.expr.type();
        SeqType retType = this.updating ? SeqType.EMP : (this.ret == null || r.instanceOf(this.ret) ? r : this.ret);
        this.type = FuncType.get(this.ann, this.args, retType).seqType();
        this.size = 1L;
        try {
            for (Map.Entry<Var, Value> e : this.staticBindings()) {
                Var v = e.getKey();
                Expr inlined = this.expr.inline(ctx, this.scope, v, v.checkType(e.getValue(), ctx, this.info, true));
                if (inlined == null) continue;
                this.expr = inlined;
            }
        }
        catch (QueryException qe) {
            this.expr = FNInfo.error(qe, this.ret != null ? this.ret : this.expr.type());
        }
        finally {
            this.scope.cleanUp(this);
        }
        return this.nonLocal.isEmpty() ? this.preEval(ctx) : this;
    }

    @Override
    public VarUsage count(Var v) {
        Map.Entry<Var, Expr> e;
        VarUsage all = VarUsage.NEVER;
        Iterator<Map.Entry<Var, Expr>> i$ = this.nonLocal.entrySet().iterator();
        while (i$.hasNext() && (all = all.plus((e = i$.next()).getValue().count(v))) != VarUsage.MORE_THAN_ONCE) {
        }
        return all;
    }

    @Override
    public Expr inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        boolean change = false;
        for (Map.Entry<Var, Expr> entry : this.nonLocal.entrySet()) {
            Expr ex = entry.getValue().inline(ctx, scp, v, e);
            if (ex == null) continue;
            change = true;
            entry.setValue(ex);
        }
        return change ? this.optimize(ctx, scp) : null;
    }

    @Override
    public Expr copy(QueryContext cx, VarScope scp, IntObjMap<Var> vs) {
        VarScope v = this.scope.copy(cx, vs);
        HashMap<Var, Expr> nl = new HashMap<Var, Expr>();
        for (Map.Entry<Var, Expr> e : this.nonLocal.entrySet()) {
            Var var = vs.get(e.getKey().id);
            Expr ex = e.getValue().copy(cx, scp, vs);
            nl.put(var, ex);
        }
        Var[] a = (Var[])this.args.clone();
        for (int i = 0; i < a.length; ++i) {
            a[i] = vs.get(a[i].id);
        }
        Expr e = this.expr.copy(cx, v, vs);
        e.markTailCalls(null);
        return this.copyType(new Closure(this.info, this.name, this.ret, a, e, this.ann, nl, this.sc, v));
    }

    @Override
    public Expr inlineExpr(Expr[] exprs, QueryContext ctx, VarScope scp, InputInfo ii) throws QueryException {
        if (this.expr.has(Expr.Flag.CTX)) {
            return null;
        }
        ctx.compInfo("inlining %", this);
        LinkedList<GFLWOR.Clause> cls = exprs.length == 0 && this.nonLocal.isEmpty() ? null : new LinkedList<GFLWOR.Clause>();
        IntObjMap<Var> vs = new IntObjMap<Var>();
        for (int i = 0; i < this.args.length; ++i) {
            Var old = this.args[i];
            Var v = scp.newCopyOf(ctx, old);
            vs.put(old.id, v);
            cls.add(new Let(v, exprs[i], false, ii).optimize(ctx, scp));
        }
        for (Map.Entry<Var, Expr> e : this.nonLocal.entrySet()) {
            Var old = e.getKey();
            Var v = scp.newCopyOf(ctx, old);
            vs.put(old.id, v);
            cls.add(new Let(v, e.getValue(), false, ii).optimize(ctx, scp));
        }
        Expr cpy = this.expr.copy(ctx, scp, vs);
        Expr rt = this.ret == null ? cpy : new TypeCheck(this.sc, ii, cpy, this.ret, true).optimize(ctx, scp);
        return cls == null ? rt : new GFLWOR(ii, cls, rt).optimize(ctx, scp);
    }

    @Override
    public FuncItem item(QueryContext ctx, InputInfo ii) throws QueryException {
        Expr body;
        FuncType ft = (FuncType)this.type().type;
        if (!this.nonLocal.isEmpty()) {
            LinkedList<GFLWOR.Clause> cls = new LinkedList<GFLWOR.Clause>();
            for (Map.Entry<Var, Expr> e : this.nonLocal.entrySet()) {
                cls.add(new Let(e.getKey(), e.getValue().value(ctx), false, ii));
            }
            body = new GFLWOR(ii, cls, this.expr);
        } else {
            body = this.expr;
        }
        Expr checked = this.ret == null ? body : new TypeCheck(this.sc, this.info, body, this.ret, true).optimize(ctx, this.scope);
        return new FuncItem(this.sc, this.ann, null, this.args, ft, checked, this.scope.stackSize());
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        return this.item(ctx, this.info);
    }

    @Override
    public ValueIter iter(QueryContext ctx) throws QueryException {
        return this.value(ctx).iter();
    }

    @Override
    public boolean has(Expr.Flag flag) {
        Boolean b = this.map.get((Object)flag);
        if (b == null) {
            this.map.put(flag, false);
            b = this.expr == null || super.has(flag);
            this.map.put(flag, b);
        }
        return b;
    }

    @Override
    public boolean removable(Var v) {
        for (Map.Entry<Var, Expr> e : this.nonLocal.entrySet()) {
            if (e.getValue().removable(v)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void plan(FElem plan) {
        FElem el = this.planElem(new Object[0]);
        this.addPlan(plan, el, this.expr);
        for (int i = 0; i < this.args.length; ++i) {
            el.add(this.planAttr("arg" + i, this.args[i].name.string()));
        }
    }

    @Override
    public boolean visit(ASTVisitor visitor) {
        for (Map.Entry<Var, Expr> v : this.nonLocal.entrySet()) {
            if (v.getValue().accept(visitor) && visitor.declared(v.getKey())) continue;
            return false;
        }
        for (Var v : this.args) {
            if (visitor.declared(v)) continue;
            return false;
        }
        return this.expr.accept(visitor);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.nonLocal.isEmpty()) {
            sb.append("((: inline-closure :) ");
            for (Map.Entry<Var, Expr> e : this.nonLocal.entrySet()) {
                sb.append("let ").append(e.getKey()).append(" := ").append(e.getValue()).append(' ');
            }
            sb.append("return").append(' ');
        }
        sb.append("function").append("(");
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.args[i]);
        }
        sb.append(")").append(' ');
        if (this.ret != null) {
            sb.append("as ").append(this.ret).append(' ');
        }
        sb.append("{ ").append(this.expr).append(" }");
        if (!this.nonLocal.isEmpty()) {
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    public void checkUp() throws QueryException {
        boolean u = this.expr.has(Expr.Flag.UPD);
        if (u) {
            this.expr.checkUp();
        }
        InputInfo ii = (this.expr instanceof ParseExpr ? (ParseExpr)this.expr : this).info;
        if (this.updating) {
            if (this.ret != null) {
                throw Err.UPFUNCTYPE.get(this.info, new Object[0]);
            }
            if (!u && !this.expr.isVacuous()) {
                throw Err.UPEXPECTF.get(ii, new Object[0]);
            }
        } else if (u) {
            throw Err.UPNOT.get(ii, this.description());
        }
    }

    @Override
    public boolean isVacuous() {
        return !this.has(Expr.Flag.UPD) && this.ret != null && this.ret.eq(SeqType.EMP);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        for (Map.Entry<Var, Expr> e : this.nonLocal.entrySet()) {
            if (e.getValue().accept(visitor)) continue;
            return false;
        }
        return visitor.inlineFunc(this);
    }

    @Override
    public int exprSize() {
        int sz = 1;
        for (Map.Entry<Var, Expr> e : this.nonLocal.entrySet()) {
            sz += e.getValue().exprSize();
        }
        return sz + this.expr.exprSize();
    }

    @Override
    public boolean compiled() {
        return this.compiled;
    }

    public Iterator<Map.Entry<Var, Expr>> nonLocalBindings() {
        return this.nonLocal.entrySet().iterator();
    }
}

