/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.core.BaseXException;
import org.basex.io.out.ArrayOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.server.ClientQuery;
import org.basex.server.ClientSession;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FNClient
extends StandardFunc {
    private static final Pattern QUERYPAT = Pattern.compile("\\[(.*?)\\] (.*)", 8);

    public FNClient(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        this.checkCreate(ctx);
        switch (this.sig) {
            case _CLIENT_QUERY: {
                return this.query(ctx).iter(ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _CLIENT_QUERY: {
                return this.query(ctx);
            }
        }
        return super.value(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        this.checkCreate(ctx);
        switch (this.sig) {
            case _CLIENT_CONNECT: {
                return this.connect(ctx);
            }
            case _CLIENT_EXECUTE: {
                return this.execute(ctx);
            }
            case _CLIENT_INFO: {
                return this.info(ctx);
            }
            case _CLIENT_CLOSE: {
                return this.close(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private Uri connect(QueryContext ctx) throws QueryException {
        String host = Token.string(this.checkStr(this.expr[0], ctx));
        String user = Token.string(this.checkStr(this.expr[2], ctx));
        String pass = Token.string(this.checkStr(this.expr[3], ctx));
        int port = (int)this.checkItr(this.expr[1], ctx);
        try {
            return ctx.sessions().add(new ClientSession(host, port, user, pass));
        }
        catch (IOException ex) {
            throw Err.BXCL_CONN.get(this.info, ex);
        }
    }

    private Str execute(QueryContext ctx) throws QueryException {
        ClientSession cs = this.session(ctx, false);
        String cmd = Token.string(this.checkStr(this.expr[1], ctx));
        try {
            ArrayOutput ao = new ArrayOutput();
            cs.setOutputStream(ao);
            cs.execute(cmd);
            cs.setOutputStream(null);
            return Str.get(ao.toArray());
        }
        catch (BaseXException ex) {
            throw Err.BXCL_COMMAND.get(this.info, ex);
        }
        catch (IOException ex) {
            throw Err.BXCL_COMM.get(this.info, ex);
        }
    }

    private Str info(QueryContext ctx) throws QueryException {
        return Str.get(this.session(ctx, false).info().replaceAll("\r\n?", "\n").trim());
    }

    private Value query(QueryContext ctx) throws QueryException {
        ClientSession cs = this.session(ctx, false);
        String query = Token.string(this.checkStr(this.expr[1], ctx));
        ValueBuilder vb = new ValueBuilder();
        ClientQuery cq = null;
        try {
            Object result;
            cq = cs.query(query);
            for (Map.Entry<String, Value> binding : this.bindings(2, ctx).entrySet()) {
                ArrayOutput value;
                String k = binding.getKey();
                Value v = binding.getValue();
                if (!v.isItem()) {
                    throw Err.BXCL_ITEM.get(this.info, v);
                }
                Item it = (Item)v;
                Type t = v.type;
                if (it instanceof FuncItem) {
                    throw Err.FIVALUE.get(this.info, t);
                }
                ArrayOutput arrayOutput = value = t instanceof NodeType ? v.serialize() : Token.string(it.string(this.info));
                if (k.isEmpty()) {
                    cq.context(value, t.toString());
                    continue;
                }
                cq.bind(k, value, t.toString());
            }
            while (cq.more()) {
                result = cq.next();
                vb.add(cq.type().castString((String)result, ctx, this.sc, this.info));
            }
            result = vb.value();
            return result;
        }
        catch (QueryIOException ex) {
            throw ex.getCause(this.info);
        }
        catch (BaseXException ex) {
            Matcher m = QUERYPAT.matcher(ex.getMessage());
            if (m.find()) {
                QueryException exc = Err.get(m.group(1), this.info, m.group(2));
                throw exc == null ? new QueryException(this.info, new QNm(m.group(1)), m.group(2), new Object[0]) : exc;
            }
            throw Err.BXCL_QUERY.get(this.info, ex);
        }
        catch (IOException ex) {
            throw Err.BXCL_COMM.get(this.info, ex);
        }
        finally {
            if (cq != null) {
                try {
                    cq.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    private Item close(QueryContext ctx) throws QueryException {
        try {
            this.session(ctx, true).close();
            return null;
        }
        catch (IOException ex) {
            throw Err.BXCL_COMMAND.get(this.info, ex);
        }
    }

    private ClientSession session(QueryContext ctx, boolean del) throws QueryException {
        Uri id = (Uri)this.checkType(this.expr[0].item(ctx, this.info), AtomType.URI);
        ClientSession cs = ctx.sessions().get(id);
        if (cs == null) {
            throw Err.BXCL_NOTAVL.get(this.info, id);
        }
        if (del) {
            ctx.sessions().remove(id);
        }
        return cs;
    }
}

