/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.Locale;
import org.basex.data.Data;
import org.basex.data.FTPosData;
import org.basex.data.MemData;
import org.basex.index.IndexType;
import org.basex.index.query.IndexEntries;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.ft.FTContainsExpr;
import org.basex.query.ft.FTContent;
import org.basex.query.ft.FTDistance;
import org.basex.query.ft.FTExpr;
import org.basex.query.ft.FTIndexAccess;
import org.basex.query.ft.FTOrder;
import org.basex.query.ft.FTScope;
import org.basex.query.ft.FTWindow;
import org.basex.query.ft.FTWords;
import org.basex.query.func.FNIndex;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.DataBuilder;
import org.basex.query.util.Err;
import org.basex.query.util.IndexContext;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.DBNodeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.ft.FTContents;
import org.basex.util.ft.FTDiacritics;
import org.basex.util.ft.FTDistanceOptions;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTIndexOptions;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTMode;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.FTOptions;
import org.basex.util.ft.FTScopeOptions;
import org.basex.util.ft.FTUnit;
import org.basex.util.ft.FTWindowOptions;
import org.basex.util.ft.Language;
import org.basex.util.list.IntList;
import org.basex.util.options.Options;

public final class FNFt
extends StandardFunc {
    private static final QNm Q_OPTIONS = QNm.get("options");
    private static final byte[] MARK = Token.token("mark");

    public FNFt(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _FT_CONTAINS: {
                return this.contains(ctx);
            }
            case _FT_COUNT: {
                return this.count(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _FT_SEARCH: {
                return this.search(ctx);
            }
            case _FT_SCORE: {
                return this.score(ctx);
            }
            case _FT_MARK: {
                return this.mark(ctx, false);
            }
            case _FT_EXTRACT: {
                return this.mark(ctx, true);
            }
            case _FT_TOKENS: {
                return this.tokens(ctx);
            }
            case _FT_TOKENIZE: {
                return this.tokenize(ctx);
            }
        }
        return super.iter(ctx);
    }

    private Item count(QueryContext ctx) throws QueryException {
        Item it;
        FTPosData tmp = ctx.ftPosData;
        ctx.ftPosData = new FTPosData();
        Iter ir = ctx.iter(this.expr[0]);
        while ((it = ir.next()) != null) {
            this.checkDBNode(it);
        }
        int s = ctx.ftPosData.size();
        ctx.ftPosData = tmp;
        return Int.get(s);
    }

    private Iter mark(final QueryContext ctx, boolean ex) throws QueryException {
        int l;
        byte[] m = MARK;
        int n = l = ex ? 150 : Integer.MAX_VALUE;
        if (this.expr.length > 1 && !XMLToken.isQName(m = this.checkStr(this.expr[1], ctx))) {
            throw Err.valueError(this.info, AtomType.QNM, m);
        }
        if (this.expr.length > 2) {
            l = (int)this.checkItr(this.expr[2], ctx);
        }
        final byte[] mark = m;
        final int len = l;
        return new Iter(){
            final FTPosData ftd = new FTPosData();
            Iter ir;
            ValueIter vi;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Item next() throws QueryException {
                while (true) {
                    if (this.vi != null) {
                        Item it = this.vi.next();
                        if (it != null) {
                            return it;
                        }
                        this.vi = null;
                    }
                    FTPosData tmp = ctx.ftPosData;
                    try {
                        Item it;
                        ctx.ftPosData = this.ftd;
                        if (this.ir == null) {
                            this.ir = ctx.iter(FNFt.this.expr[0]);
                        }
                        if ((it = this.ir.next()) == null) {
                            Item item = null;
                            return item;
                        }
                        MemData md = new MemData(ctx.context.options);
                        DataBuilder db = new DataBuilder(md);
                        db.ftpos(mark, ctx.ftPosData, len).build(FNFt.this.checkDBNode(it));
                        IntList il = new IntList();
                        for (int p = 0; p < md.meta.size; p += md.size(p, md.kind(p))) {
                            il.add(p);
                        }
                        this.vi = DBNodeSeq.get(il, (Data)md, false, false).iter();
                        continue;
                    }
                    finally {
                        ctx.ftPosData = tmp;
                        continue;
                    }
                    break;
                }
            }
        };
    }

    private Iter score(final QueryContext ctx) throws QueryException {
        return new Iter(){
            final Iter iter;
            {
                this.iter = FNFt.this.expr[0].iter(ctx);
            }

            @Override
            public Dbl next() throws QueryException {
                Item item = this.iter.next();
                return item == null ? null : Dbl.get(item.score());
            }
        };
    }

    private Bln contains(QueryContext ctx) throws QueryException {
        Value input = ctx.value(this.expr[0]);
        Value query = ctx.value(this.expr[1]);
        FTOptions opts = this.checkOptions(2, Q_OPTIONS, new FTOptions(), ctx);
        FTOpt opt = new FTOpt();
        FTMode mode = opts.get(FTIndexOptions.MODE);
        opt.set(FTFlag.FZ, opts.get(FTIndexOptions.FUZZY));
        opt.set(FTFlag.WC, opts.get(FTIndexOptions.WILDCARDS));
        opt.set(FTFlag.DC, opts.get(FTOptions.DIACRITICS) == FTDiacritics.SENSITIVE);
        opt.set(FTFlag.ST, opts.get(FTOptions.STEMMING));
        opt.ln = Language.get(opts.get(FTOptions.LANGUAGE));
        opt.cs = opts.get(FTOptions.CASE);
        if (opt.is(FTFlag.FZ) && opt.is(FTFlag.WC)) {
            throw Err.BXFT_MATCH.get(this.info, this);
        }
        FTOpt tmp = ctx.ftOpt();
        ctx.ftOpt(opt);
        FTWords fte = new FTWords(this.info, query, mode, null).compile(ctx, null);
        ctx.ftOpt(tmp);
        return new FTContainsExpr(input, this.options(fte, opts), this.info).item(ctx, this.info);
    }

    private Iter search(QueryContext ctx) throws QueryException {
        Data data = this.checkData(ctx);
        Value terms = ctx.value(this.expr[1]);
        FTOptions opts = this.checkOptions(2, Q_OPTIONS, new FTOptions(), ctx);
        IndexContext ic = new IndexContext(data, false);
        if (!data.meta.ftxtindex) {
            throw Err.BXDB_INDEX.get(this.info, data.meta.name, IndexType.FULLTEXT.toString().toLowerCase(Locale.ENGLISH));
        }
        FTOpt opt = new FTOpt().copy(data.meta);
        FTMode mode = opts.get(FTIndexOptions.MODE);
        opt.set(FTFlag.FZ, opts.get(FTIndexOptions.FUZZY));
        opt.set(FTFlag.WC, opts.get(FTIndexOptions.WILDCARDS));
        if (opt.is(FTFlag.FZ) && opt.is(FTFlag.WC)) {
            throw Err.BXFT_MATCH.get(this.info, this);
        }
        FTOpt tmp = ctx.ftOpt();
        ctx.ftOpt(opt);
        FTWords fte = new FTWords(this.info, ic, terms, mode).compile(ctx, null);
        ctx.ftOpt(tmp);
        return new FTIndexAccess(this.info, this.options(fte, opts), ic).iter(ctx);
    }

    private FTExpr options(FTExpr ftexpr, FTOptions opts) {
        FTExpr fte = ftexpr;
        if (opts != null) {
            FTUnit unit;
            Options fopts;
            if (opts.get(FTIndexOptions.ORDERED).booleanValue()) {
                fte = new FTOrder(this.info, fte);
            }
            if (opts.contains(FTIndexOptions.DISTANCE)) {
                fopts = opts.get(FTIndexOptions.DISTANCE);
                Int min = Int.get(fopts.get(FTDistanceOptions.MIN).intValue());
                Int max = Int.get(fopts.get(FTDistanceOptions.MAX).intValue());
                FTUnit unit2 = fopts.get(FTDistanceOptions.UNIT);
                fte = new FTDistance(this.info, fte, min, max, unit2);
            }
            if (opts.contains(FTIndexOptions.WINDOW)) {
                fopts = opts.get(FTIndexOptions.WINDOW);
                Int sz = Int.get(fopts.get(FTWindowOptions.SIZE).intValue());
                unit = fopts.get(FTWindowOptions.UNIT);
                fte = new FTWindow(this.info, fte, sz, unit);
            }
            if (opts.contains(FTIndexOptions.SCOPE)) {
                fopts = opts.get(FTIndexOptions.SCOPE);
                boolean same = fopts.get(FTScopeOptions.SAME);
                unit = fopts.get(FTScopeOptions.UNIT).unit();
                fte = new FTScope(this.info, fte, same, unit);
            }
            if (opts.contains(FTIndexOptions.CONTENT)) {
                FTContents cont = opts.get(FTIndexOptions.CONTENT);
                fte = new FTContent(this.info, fte, cont);
            }
        }
        return fte;
    }

    private Iter tokens(QueryContext ctx) throws QueryException {
        byte[] entry;
        Data data = this.checkData(ctx);
        byte[] byArray = entry = this.expr.length < 2 ? Token.EMPTY : this.checkStr(this.expr[1], ctx);
        if (entry.length != 0) {
            FTLexer ftl = new FTLexer(new FTOpt().copy(data.meta));
            ftl.init(entry);
            entry = ftl.nextToken();
        }
        return FNIndex.entries(data, new IndexEntries(entry, IndexType.FULLTEXT), this);
    }

    private Iter tokenize(QueryContext ctx) throws QueryException {
        FTOpt opt = new FTOpt().copy(ctx.ftOpt());
        final FTLexer ftl = new FTLexer(opt).init(this.checkStr(this.expr[0], ctx));
        return new Iter(){

            @Override
            public Str next() {
                return ftl.hasNext() ? Str.get(ftl.nextToken()) : null;
            }
        };
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return (!FNFt.oneOf(this.sig, Function._FT_SEARCH, Function._FT_TOKENS) || this.dataLock(visitor)) && super.accept(visitor);
    }
}

