/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.out.ArrayOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.util.InputInfo;
import org.basex.util.Prop;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.options.Options;

public final class FNXslt
extends StandardFunc {
    private static final QNm Q_PARAMETERS = QNm.get("parameters", QueryText.XSLTURI);
    private static final String[] IMPL = new String[]{"", "Java", "1.0", "net.sf.saxon.TransformerFactoryImpl", "Saxon HE", "2.0", "com.saxonica.config.ProfessionalTransformerFactory", "Saxon PE", "2.0", "com.saxonica.config.EnterpriseTransformerFactory", "Saxon EE", "2.0"};
    private static final int OFFSET;

    private static String get(boolean name) {
        return IMPL[OFFSET + (name ? 1 : 2)];
    }

    public FNXslt(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _XSLT_PROCESSOR: {
                return Str.get(FNXslt.get(true));
            }
            case _XSLT_VERSION: {
                return Str.get(FNXslt.get(false));
            }
            case _XSLT_TRANSFORM: {
                return this.transform(ctx, true);
            }
            case _XSLT_TRANSFORM_TEXT: {
                return this.transform(ctx, false);
            }
        }
        return super.item(ctx, ii);
    }

    private Item transform(QueryContext ctx, boolean node) throws QueryException {
        this.checkCreate(ctx);
        IO in = this.read(this.expr[0], ctx);
        IO xsl = this.read(this.expr[1], ctx);
        Options opts = this.checkOptions(2, Q_PARAMETERS, new Options(), ctx);
        PrintStream tmp = System.err;
        ArrayOutput ao = new ArrayOutput();
        try {
            System.setErr(new PrintStream(ao));
            byte[] result = FNXslt.transform(in, xsl, opts.free());
            Item item = node ? new DBNode(new IOContent(result), ctx.context.options) : Str.get(result);
            return item;
        }
        catch (IOException ex) {
            System.setErr(tmp);
            throw Err.IOERR.get(this.info, ex);
        }
        catch (TransformerException ex) {
            System.setErr(tmp);
            throw Err.BXSL_ERROR.get(this.info, new Object[]{Token.trim(Token.utf8(ao.toArray(), Prop.ENCODING))});
        }
        finally {
            System.setErr(tmp);
        }
    }

    private IO read(Expr e, QueryContext ctx) throws QueryException {
        Item it = this.checkItem(e, ctx);
        if (it.type.isNode()) {
            try {
                IOContent io = new IOContent(it.serialize().toArray());
                io.name(Token.string(((ANode)it).baseURI()));
                return io;
            }
            catch (QueryIOException ex) {
                ex.getCause(this.info);
            }
        }
        if (it.type.isStringOrUntyped()) {
            return this.checkPath(it, ctx);
        }
        throw Err.STRNODTYPE.get(this.info, this, it.type);
    }

    private static byte[] transform(IO in, IO xsl, HashMap<String, String> par) throws TransformerException {
        TransformerFactory tc = TransformerFactory.newInstance();
        Transformer tr = tc.newTransformer(xsl.streamSource());
        for (Map.Entry<String, String> entry : par.entrySet()) {
            tr.setParameter(entry.getKey(), entry.getValue());
        }
        ArrayOutput ao = new ArrayOutput();
        tr.transform(in.streamSource(), new StreamResult(ao));
        return ao.toArray();
    }

    static {
        String fac = TransformerFactory.class.getName();
        String impl = System.getProperty(fac);
        if (System.getProperty(fac) != null) {
            FNXslt.IMPL[1] = impl;
            FNXslt.IMPL[2] = "Unknown";
            OFFSET = 0;
        } else {
            int s;
            for (s = IMPL.length - 3; s != 0 && Reflect.find(IMPL[s]) == null; s -= 3) {
            }
            OFFSET = s;
            if (s != 0) {
                System.setProperty(fac, IMPL[s]);
            }
        }
    }
}

