/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.lang.reflect.Method;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryModule;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.JavaFunc;
import org.basex.query.func.JavaMapping;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class JavaModuleFunc
extends JavaMapping {
    private final Object module;
    private final Method mth;
    private final Class<?>[] params;
    private final boolean[] vTypes;

    JavaModuleFunc(StaticContext sctx, InputInfo ii, Object jm, Method m, Expr[] a) {
        super(sctx, ii, a);
        this.module = jm;
        this.mth = m;
        this.params = m.getParameterTypes();
        this.vTypes = JavaFunc.values(this.params);
    }

    @Override
    protected Object eval(Value[] vals, QueryContext ctx) throws QueryException {
        Object[] args;
        if (this.module instanceof QueryModule) {
            QueryModule mod = (QueryModule)this.module;
            mod.staticContext = this.sc;
            mod.queryContext = ctx;
        }
        if ((args = JavaFunc.args(this.params, this.vTypes, vals, true)) != null) {
            try {
                return this.mth.invoke(this.module, args);
            }
            catch (Exception ex) {
                Throwable e = ex;
                if (e.getCause() != null) {
                    Util.debug(e);
                    e = e.getCause();
                }
                throw e instanceof QueryException ? ((QueryException)e).info(this.info) : Err.JAVAERR.get(this.info, e);
            }
        }
        TokenBuilder expect = new TokenBuilder();
        for (Class<?> c : this.mth.getParameterTypes()) {
            if (!expect.isEmpty()) {
                expect.add(", ");
            }
            expect.add(Util.className(c));
        }
        throw Err.JAVAMOD.get(this.info, this.mth.getName() + '(' + expect + ')', this.mth.getName() + '(' + JavaModuleFunc.foundArgs(vals) + ')');
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new JavaModuleFunc(this.sc, this.info, this.module, this.mth, JavaModuleFunc.copyAll((QueryContext)ctx, (VarScope)scp, vs, (Expr[])this.expr));
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.NAM, this.name()), this.expr);
    }

    @Override
    public String description() {
        return this.name() + " method";
    }

    private String name() {
        return Util.className(this.module) + ':' + this.mth.getName();
    }

    @Override
    public String toString() {
        return this.name() + "(" + this.toString(", ") + ")";
    }

    @Override
    public boolean has(Expr.Flag f) {
        return f == Expr.Flag.NDT && this.mth.getAnnotation(QueryModule.Deterministic.class) == null || (f == Expr.Flag.CTX || f == Expr.Flag.FCS) && this.mth.getAnnotation(QueryModule.FocusDependent.class) == null || super.has(f);
    }
}

