/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.ArrayList;
import org.basex.core.Text;
import org.basex.data.ExprInfo;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Functions;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.StaticFuncCall;
import org.basex.query.util.Ann;
import org.basex.query.util.Err;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.TypedFunc;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Levenshtein;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.IntList;

public final class StaticFuncs
extends ExprInfo {
    private final TokenObjMap<FuncCache> funcs = new TokenObjMap();

    static byte[] sig(QNm name, long arity) {
        return new TokenBuilder(name.id()).add(35).add(Token.token(arity)).finish();
    }

    public StaticFunc declare(Ann ann, QNm nm, Var[] args, SeqType ret, Expr body, StaticContext sc, VarScope scp, String xqdoc, InputInfo ii) throws QueryException {
        byte[] uri = nm.uri();
        if (uri.length == 0) {
            throw Err.FUNNONS.get(ii, new Object[]{nm.string()});
        }
        if (NSGlobal.reserved(uri)) {
            throw Err.NAMERES.get(ii, new Object[]{nm.string()});
        }
        StaticFunc fn = new StaticFunc(ann, nm, args, ret, body, sc, scp, xqdoc, ii);
        byte[] sig = fn.id();
        FuncCache fc = this.funcs.get(sig);
        if (fc != null) {
            fc.setFunc(fn);
        } else {
            this.funcs.put(sig, new FuncCache(fn));
        }
        return fn;
    }

    TypedFunc getRef(QNm name, Expr[] args, StaticContext sc, InputInfo ii) throws QueryException {
        FuncCache fc = this.funcs.get(StaticFuncs.sig(name, args.length));
        return fc == null ? null : fc.newCall(name, args, sc, ii);
    }

    public TypedFunc getFuncRef(QNm name, Expr[] args, StaticContext sc, InputInfo ii) throws QueryException {
        QueryException qe;
        if (NSGlobal.reserved(name.uri()) && (qe = this.similarError(name, ii)) != null) {
            throw qe;
        }
        byte[] sig = StaticFuncs.sig(name, args.length);
        if (!this.funcs.contains(sig)) {
            this.funcs.put(sig, new FuncCache(null));
        }
        return this.getRef(name, args, sc, ii);
    }

    public void check(QueryContext qc) throws QueryException {
        int id = 0;
        for (FuncCache fc : this.funcs.values()) {
            StaticFuncCall call;
            StaticFuncCall staticFuncCall = call = fc.calls.isEmpty() ? null : fc.calls.get(0);
            if (fc.func == null) {
                int oid = 0;
                IntList al = new IntList();
                for (FuncCache ofc : this.funcs.values()) {
                    if (oid++ == id || ofc.func == null || !call.name.eq(ofc.name())) continue;
                    al.add(ofc.func.arity());
                }
                if (!al.isEmpty()) {
                    int a;
                    StringBuilder exp = new StringBuilder();
                    int as = al.size();
                    for (a = 0; a < as; ++a) {
                        if (a != 0) {
                            exp.append(a + 1 < as ? "," : " or ");
                        }
                        exp.append(al.get(a));
                    }
                    a = call.expr.length;
                    throw (a == 1 ? Err.FUNCTYPESG : Err.FUNCTYPEPL).get(call.info, call.name.string(), a, exp);
                }
                QueryException qe = this.similarError(call.name, call.info);
                throw qe == null ? Err.FUNCUNKNOWN.get(call.info, new Object[]{call.name.string()}) : qe;
            }
            if (call != null) {
                if (fc.func.expr == null) {
                    throw Err.FUNCNOIMPL.get(call.info, new Object[]{call.name.string()});
                }
                qc.updating |= fc.func.updating;
            }
            ++id;
        }
    }

    public void checkUp() throws QueryException {
        for (FuncCache fc : this.funcs.values()) {
            fc.func.checkUp();
        }
    }

    public void compile(QueryContext ctx) {
        for (FuncCache fc : this.funcs.values()) {
            if (fc.calls.isEmpty()) continue;
            fc.func.compile(ctx);
        }
    }

    public StaticFunc get(QNm name, long arity, InputInfo ii, boolean error) throws QueryException {
        QueryException qe;
        FuncCache fc = this.funcs.get(StaticFuncs.sig(name, arity));
        if (fc != null) {
            return fc.func;
        }
        if (error && NSGlobal.reserved(name.uri()) && (qe = this.similarError(name, ii)) != null) {
            throw qe;
        }
        return null;
    }

    public QueryException similarError(QNm name, InputInfo ii) {
        QueryException qe = Functions.get().similarError(name, ii);
        if (qe == null) {
            Levenshtein ls = new Levenshtein();
            byte[] nm = Token.lc(name.local());
            for (FuncCache fc : this.funcs.values()) {
                StaticFunc sf = fc.func;
                if (sf == null || sf.expr == null || !ls.similar(nm, Token.lc(sf.name.local()))) continue;
                qe = Err.FUNCSIMILAR.get(ii, name.string(), sf.name.string());
                break;
            }
        }
        return qe;
    }

    @Override
    public void plan(FElem plan) {
        if (!this.funcs.isEmpty()) {
            FElem el = this.planElem(new Object[0]);
            plan.add(el);
            for (StaticFunc f : this.funcs()) {
                if (f == null || !f.compiled()) continue;
                f.plan(el);
            }
        }
    }

    public StaticFunc[] funcs() {
        int fs = this.funcs.size();
        StaticFunc[] sf = new StaticFunc[fs];
        int i = 0;
        for (FuncCache fc : this.funcs.values()) {
            sf[i++] = fc.func;
        }
        return sf;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (FuncCache fc : this.funcs.values()) {
            if (fc.func == null || !fc.func.compiled()) continue;
            sb.append(fc.func).append(Text.NL);
        }
        return sb.toString();
    }

    private static class FuncCache {
        final ArrayList<StaticFuncCall> calls = new ArrayList(0);
        StaticFunc func;

        FuncCache(StaticFunc sf) {
            this.func = sf;
        }

        public void setFunc(StaticFunc fn) throws QueryException {
            if (this.func != null) {
                throw Err.FUNCDEFINED.get(fn.info, new Object[]{fn.name.string()});
            }
            this.func = fn;
            for (StaticFuncCall call : this.calls) {
                call.init(fn);
            }
        }

        public TypedFunc newCall(QNm nm, Expr[] args, StaticContext sc, InputInfo ii) throws QueryException {
            StaticFuncCall call = new StaticFuncCall(nm, args, sc, ii);
            this.calls.add(call);
            if (this.func == null) {
                return new TypedFunc(call, new Ann());
            }
            return new TypedFunc(call.init(this.func), this.func.ann);
        }

        public QNm name() {
            return this.func != null ? this.func.name : this.calls.get((int)0).name;
        }
    }
}

