/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.gflwor;

import java.util.List;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Context;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.func.Function;
import org.basex.query.gflwor.GFLWOR;
import org.basex.query.gflwor.Let;
import org.basex.query.iter.Iter;
import org.basex.query.path.AxisPath;
import org.basex.query.path.Path;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.IntObjMap;

public final class For
extends GFLWOR.Clause {
    final Var var;
    final Var pos;
    final Var score;
    Expr expr;
    final boolean empty;

    public For(Var v, Var p, Var s, Expr e, boolean emp, InputInfo ii) {
        super(ii, For.vars(v, p, s));
        this.var = v;
        this.pos = p;
        this.score = s;
        this.expr = e;
        this.empty = emp;
    }

    @Override
    GFLWOR.Eval eval(final GFLWOR.Eval sub) {
        return new GFLWOR.Eval(){
            private Iter iter;
            private long p;

            @Override
            public boolean next(QueryContext ctx) throws QueryException {
                while (true) {
                    Item it;
                    Item item = it = this.iter == null ? null : this.iter.next();
                    if (it != null) {
                        ++this.p;
                        ctx.set(For.this.var, it, For.this.info);
                        if (For.this.pos != null) {
                            ctx.set(For.this.pos, Int.get(this.p), For.this.info);
                        }
                        if (For.this.score != null) {
                            ctx.set(For.this.score, Dbl.get(it.score()), For.this.info);
                        }
                        return true;
                    }
                    if (For.this.empty && this.iter != null && this.p == 0L) {
                        ctx.set(For.this.var, Empty.SEQ, For.this.info);
                        if (For.this.pos != null) {
                            ctx.set(For.this.pos, Int.get(this.p), For.this.info);
                        }
                        if (For.this.score != null) {
                            ctx.set(For.this.score, Dbl.get(0.0), For.this.info);
                        }
                        this.iter = null;
                        return true;
                    }
                    if (!sub.next(ctx)) {
                        return false;
                    }
                    this.iter = For.this.expr.iter(ctx);
                    this.p = 0L;
                }
            }
        };
    }

    @Override
    public void plan(FElem plan) {
        FElem e2;
        FElem e = this.planElem(new Object[0]);
        if (this.empty) {
            e.add(this.planAttr(Token.token("empty"), Token.TRUE));
        }
        this.var.plan(e);
        if (this.pos != null) {
            e2 = new FElem("at");
            this.pos.plan(e2);
            e.add(e2);
        }
        if (this.score != null) {
            e2 = new FElem("score");
            this.score.plan(e2);
            e.add(e2);
        }
        this.expr.plan(e);
        plan.add(e);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("for").append(' ').append(this.var);
        if (this.empty) {
            sb.append(' ').append("allowing").append(' ').append("empty");
        }
        if (this.pos != null) {
            sb.append(' ').append("at").append(' ').append(this.pos);
        }
        if (this.score != null) {
            sb.append(' ').append("score").append(' ').append(this.score);
        }
        return sb.append(' ').append("in").append(' ').append(this.expr).toString();
    }

    @Override
    public boolean has(Expr.Flag flag) {
        return this.expr.has(flag);
    }

    @Override
    public For compile(QueryContext ctx, VarScope scp) throws QueryException {
        this.expr = this.expr.compile(ctx, scp);
        return this.optimize(ctx, scp);
    }

    @Override
    public For optimize(QueryContext ctx, VarScope scp) throws QueryException {
        SeqType tp = this.expr.type();
        boolean emp = this.empty && tp.mayBeZero();
        this.type = SeqType.get(tp.type, emp ? SeqType.Occ.ZERO_ONE : SeqType.Occ.ONE);
        this.var.refineType(this.type, ctx, this.info);
        if (this.pos != null) {
            this.pos.refineType(SeqType.ITR, ctx, this.info);
        }
        if (this.score != null) {
            this.score.refineType(SeqType.DBL, ctx, this.info);
        }
        this.size = emp ? -1L : 1L;
        return this;
    }

    @Override
    public boolean removable(Var v) {
        return this.expr.removable(v);
    }

    @Override
    public VarUsage count(Var v) {
        return this.expr.count(v);
    }

    @Override
    public GFLWOR.Clause inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        Expr sub = this.expr.inline(ctx, scp, v, e);
        if (sub == null) {
            return null;
        }
        this.expr = sub;
        return this.optimize(ctx, scp);
    }

    @Override
    public For copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        Var s;
        Var p;
        Var v = scp.newCopyOf(ctx, this.var);
        vs.put(this.var.id, v);
        Var var = p = this.pos == null ? null : scp.newCopyOf(ctx, this.pos);
        if (p != null) {
            vs.put(this.pos.id, p);
        }
        Var var2 = s = this.score == null ? null : scp.newCopyOf(ctx, this.score);
        if (s != null) {
            vs.put(this.score.id, s);
        }
        return new For(v, p, s, this.expr.copy(ctx, scp, vs), this.empty, this.info);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return !(!this.expr.accept(visitor) || !visitor.declared(this.var) || this.pos != null && !visitor.declared(this.pos) || this.score != null && !visitor.declared(this.score));
    }

    private static Var[] vars(Var v, Var p, Var s) {
        Var[] varArray;
        if (p == null) {
            if (s == null) {
                Var[] varArray2 = new Var[1];
                varArray = varArray2;
                varArray2[0] = v;
            } else {
                Var[] varArray3 = new Var[2];
                varArray3[0] = v;
                varArray = varArray3;
                varArray3[1] = s;
            }
        } else if (s == null) {
            Var[] varArray4 = new Var[2];
            varArray4[0] = v;
            varArray = varArray4;
            varArray4[1] = p;
        } else {
            Var[] varArray5 = new Var[3];
            varArray5[0] = v;
            varArray5[1] = p;
            varArray = varArray5;
            varArray5[2] = s;
        }
        return varArray;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.expr);
    }

    boolean asLet(List<GFLWOR.Clause> clauses, int p) {
        if (this.expr.size() != 1L && !this.expr.type().one()) {
            return false;
        }
        clauses.set(p, Let.fromFor(this));
        if (this.score != null) {
            clauses.add(p + 1, Let.fromForScore(this));
        }
        if (this.pos != null) {
            clauses.add(p + 1, new Let(this.pos, Int.get(1L), false, this.info));
        }
        return true;
    }

    boolean toPred(QueryContext ctx, VarScope scp, Expr prd) throws QueryException {
        Expr pred;
        if (this.empty || this.vars.length != 1 || !prd.uses(this.var) || !prd.removable(this.var)) {
            return false;
        }
        Context c = new Context(this.info);
        c.type = this.expr.type().type.seqType();
        Expr r = prd.inline(ctx, scp, this.var, c);
        Expr inl = r == null ? prd : r;
        Expr expr = pred = inl.type().mayBeNumber() ? Function.BOOLEAN.get(null, this.info, inl) : inl;
        this.expr = this.expr instanceof AxisPath ? ((Path)this.expr).addPreds(ctx, scp, pred) : (this.expr instanceof Filter ? ((Filter)this.expr).addPred(ctx, scp, pred) : Filter.get(this.info, this.expr, pred).optimize(ctx, scp));
        return true;
    }

    @Override
    long calcSize(long count) {
        long sz = this.expr.size();
        return sz < 0L ? -1L : (sz > 0L ? sz * count : (this.empty ? 1L : 0L));
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize();
    }
}

