/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.gflwor.Let;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueIter;
import org.basex.query.up.ContextModifier;
import org.basex.query.up.TransformModifier;
import org.basex.query.up.Updates;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Transform
extends Arr {
    private final Let[] copies;

    public Transform(InputInfo info, Let[] copies, Expr mod, Expr ret) {
        super(info, mod, ret);
        this.copies = copies;
    }

    @Override
    public void checkUp() throws QueryException {
        for (Let c : this.copies) {
            c.checkUp();
        }
        Expr m = this.expr[0];
        m.checkUp();
        if (!m.isVacuous() && !m.has(Expr.Flag.UPD)) {
            throw Err.UPMODIFY.get(this.info, new Object[0]);
        }
        this.checkNoUp(this.expr[1]);
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        for (Let c : this.copies) {
            c.expr = c.expr.compile(ctx, scp);
        }
        super.compile(ctx, scp);
        return this;
    }

    @Override
    public ValueIter iter(QueryContext ctx) throws QueryException {
        return this.value(ctx).iter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value value(QueryContext ctx) throws QueryException {
        int o = (int)ctx.output.size();
        if (ctx.updates == null) {
            ctx.updates = new Updates();
        }
        ContextModifier tmp = ctx.updates.mod;
        TransformModifier pu = new TransformModifier();
        ctx.updates.mod = pu;
        try {
            for (Let fo : this.copies) {
                Iter ir = ctx.iter(fo.expr);
                Item i = ir.next();
                if (!(i instanceof ANode) || ir.next() != null) {
                    throw Err.UPCOPYMULT.get(fo.info, fo.var.name);
                }
                i = ((ANode)i).dbCopy(ctx.context.options);
                ctx.set(fo.var, i, this.info);
                pu.addData(i.data());
            }
            ctx.value(this.expr[0]);
            ctx.updates.apply();
            Value value = ctx.value(this.expr[1]);
            return value;
        }
        finally {
            ctx.output.size(o);
            ctx.updates.mod = tmp;
        }
    }

    @Override
    public boolean has(Expr.Flag flag) {
        return flag != Expr.Flag.UPD && super.has(flag);
    }

    @Override
    public boolean removable(Var v) {
        for (Let c : this.copies) {
            if (c.removable(v)) continue;
            return false;
        }
        return super.removable(v);
    }

    @Override
    public VarUsage count(Var v) {
        return VarUsage.sum(v, this.copies).plus(super.count(v));
    }

    @Override
    public Expr inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        boolean cp = Transform.inlineAll(ctx, scp, this.copies, v, e);
        return Transform.inlineAll(ctx, scp, this.expr, v, e) || cp ? this.optimize(ctx, scp) : null;
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new Transform(this.info, (Let[])Transform.copyAll((QueryContext)ctx, (VarScope)scp, vs, (Expr[])this.copies), this.expr[0].copy(ctx, scp, vs), this.expr[1].copy(ctx, scp, vs));
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.copies, this.expr});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("copy ");
        for (Let t : this.copies) {
            sb.append(t.var).append(' ').append(":=").append(' ').append(t.expr).append(' ');
        }
        return sb.append("modify " + this.expr[0] + ' ' + "return" + ' ' + this.expr[1]).toString();
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return Transform.visitAll(visitor, this.copies) && super.accept(visitor);
    }

    @Override
    public int exprSize() {
        int sz = 1;
        for (Let lt : this.copies) {
            sz += lt.exprSize();
        }
        for (Expr e : this.expr) {
            sz += e.exprSize();
        }
        return sz;
    }
}

