/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import org.basex.core.Context;
import org.basex.data.FTPosData;
import org.basex.data.MemData;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.util.ANodeList;
import org.basex.query.util.DataFTBuilder;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.list.TokenList;

public final class DataBuilder {
    private final MemData data;
    private DataFTBuilder ftbuilder;
    private int marker;

    public DataBuilder(MemData md) {
        this.data = md;
    }

    public DataBuilder ftpos(byte[] tag, FTPosData pos, int len) {
        this.ftbuilder = new DataFTBuilder(pos, len);
        this.marker = this.data.tagindex.index(tag, null, false);
        return this;
    }

    public void build(ANode node) {
        this.build(new ANodeList(node));
    }

    public void build(ANodeList nodes) {
        this.data.meta.update();
        int ds = this.data.meta.size;
        for (ANode n : nodes) {
            ds = this.addNode(n, ds, -1, null);
        }
    }

    private int addNode(ANode node, int pre, int par, ANode pNode) {
        switch (node.nodeType()) {
            case DOC: {
                return this.addDoc(node, pre);
            }
            case ELM: {
                return this.addElem(node, pre, par);
            }
            case TXT: {
                return this.addText(node, pre, par, pNode);
            }
            case ATT: {
                return this.addAttr(node, pre, par);
            }
            case COM: {
                return this.addComm(node, pre, par);
            }
        }
        return this.addPI(node, pre, par);
    }

    private int addDoc(ANode node, int pre) {
        ANode ch;
        int ds = this.data.meta.size;
        int s = DataBuilder.size(node, false);
        this.data.doc(ds, s, node.baseURI());
        this.data.insert(ds);
        int p = pre + 1;
        AxisMoreIter ai = node.children();
        while ((ch = ai.next()) != null) {
            p = this.addNode(ch, p, pre, null);
        }
        if (s != p - pre) {
            this.data.size(ds, 0, p - pre);
        }
        return p;
    }

    private int addAttr(ANode node, int pre, int par) {
        int ds = this.data.meta.size;
        QNm q = node.qname();
        byte[] uri = q.uri();
        int u = 0;
        if (uri.length != 0) {
            if (par == -1) {
                this.data.nspaces.add(ds, pre + 1, q.prefix(), uri, this.data);
            }
            u = this.data.nspaces.uri(uri);
        }
        int n = this.data.atnindex.index(q.string(), null, false);
        this.data.attr(ds, pre - par, n, node.string(), u, par == -1 && u != 0);
        this.data.insert(ds);
        return pre + 1;
    }

    private int addText(ANode node, int pre, int par, ANode pNode) {
        QNm n;
        ANode p;
        TokenList tl;
        int dist = pre - par;
        TokenList tokenList = tl = this.ftbuilder != null ? this.ftbuilder.build(node) : null;
        if (tl == null) {
            return pre + this.addText(node.string(), dist);
        }
        for (p = pNode; p != null && ((n = p.qname()) == null || n.hasPrefix()); p = p.parent()) {
        }
        int u = 0;
        if (p != null) {
            u = this.data.nspaces.uri(p.name(), true);
        }
        int ts = tl.size();
        for (int t = 0; t < ts; ++t) {
            boolean elem;
            byte[] text = tl.get(t);
            boolean bl = elem = text == null;
            if (elem) {
                this.data.elem(dist + t, this.marker, 1, 2, u, false);
                this.data.insert(this.data.meta.size);
                text = tl.get(++t);
            }
            this.addText(text, elem ? 1 : dist + t);
        }
        return pre + ts;
    }

    private int addText(byte[] text, int dist) {
        int ds = this.data.meta.size;
        this.data.text(ds, dist, text, 2);
        this.data.insert(ds);
        return 1;
    }

    private int addPI(ANode node, int pre, int par) {
        int ds = this.data.meta.size;
        byte[] v = Token.trim(Token.concat(node.name(), Token.SPACE, node.string()));
        this.data.text(ds, pre - par, v, 5);
        this.data.insert(ds);
        return pre + 1;
    }

    private int addComm(ANode node, int pre, int par) {
        int ds = this.data.meta.size;
        this.data.text(ds, pre - par, node.string(), 4);
        this.data.insert(ds);
        return pre + 1;
    }

    private int addElem(ANode node, int pre, int par) {
        ANode ch;
        int ds = this.data.meta.size;
        this.data.nspaces.prepare();
        Atts ns = par == -1 ? node.nsScope() : node.namespaces();
        int nl = ns.size();
        for (int n = 0; n < nl; ++n) {
            this.data.nspaces.add(ns.name(n), ns.value(n), ds);
        }
        QNm name = node.qname();
        int tn = this.data.tagindex.index(name.string(), null, false);
        int s = DataBuilder.size(node, false);
        int u = this.data.nspaces.uri(name.uri());
        this.data.elem(pre - par, tn, DataBuilder.size(node, true), s, u, nl != 0);
        this.data.insert(ds);
        int p = pre + 1;
        AxisMoreIter ai = node.attributes();
        while ((ch = ai.next()) != null) {
            p = this.addAttr(ch, p, pre);
        }
        ai = node.children();
        while ((ch = ai.next()) != null) {
            p = this.addNode(ch, p, pre, node);
        }
        this.data.nspaces.close(ds);
        if (s != p - pre) {
            this.data.size(ds, 1, p - pre);
        }
        return p;
    }

    private static int size(ANode node, boolean att) {
        if (node instanceof DBNode) {
            DBNode dbn = (DBNode)node;
            int k = node.kind();
            return att ? dbn.data.attSize(dbn.pre, k) : dbn.data.size(dbn.pre, k);
        }
        int s = 1;
        AxisMoreIter ai = node.attributes();
        while (ai.next() != null) {
            ++s;
        }
        if (!att) {
            ANode i;
            ai = node.children();
            while ((i = ai.next()) != null) {
                s += DataBuilder.size(i, att);
            }
        }
        return s;
    }

    public static ANode stripNS(ANode node, byte[] ns, Context ctx) {
        if (node.type != NodeType.ELM) {
            return node;
        }
        MemData md = new MemData(ctx.options);
        DataBuilder db = new DataBuilder(md);
        db.build(node);
        boolean del = true;
        for (int pre = 0; pre < md.meta.size; ++pre) {
            byte[] uri;
            int kind = md.kind(pre);
            if (kind != 1 && kind != 3 || (uri = md.nspaces.uri(md.uri(pre, kind))) == null || !Token.eq(uri, ns)) continue;
            byte[] name = md.name(pre, kind);
            if (Token.prefix(name).length == 0) {
                if (kind != 1) continue;
                md.update(pre, 1, name, Token.EMPTY);
                md.nsFlag(pre, false);
                continue;
            }
            del = false;
        }
        if (del) {
            md.nspaces.delete(ns);
        }
        return new DBNode(md);
    }
}

