/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.archive;

import java.io.IOException;
import java.util.zip.ZipEntry;
import org.basex.io.out.ArrayOutput;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.util.archive.ArchiveIn;
import org.basex.query.util.archive.GZIPOut;
import org.basex.query.util.archive.ZIPOut;
import org.basex.util.InputInfo;

public abstract class ArchiveOut {
    final ArrayOutput ao = new ArrayOutput();
    final byte[] data = new byte[4096];

    public static ArchiveOut get(String format, InputInfo info) throws QueryException {
        try {
            if (format.equals("zip")) {
                return new ZIPOut();
            }
            if (format.equals("gzip")) {
                return new GZIPOut();
            }
        }
        catch (IOException ex) {
            throw Err.ARCH_FAIL.get(info, ex);
        }
        throw Err.ARCH_UNKNOWN.get(info, new Object[0]);
    }

    public abstract void level(int var1);

    public abstract void write(ArchiveIn var1) throws IOException;

    public abstract void write(ZipEntry var1, byte[] var2) throws IOException;

    public abstract void close();

    public final byte[] toArray() {
        return this.ao.toArray();
    }
}

