/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.format;

import org.basex.query.util.format.Formatter;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.TokenParser;

final class FormatterDE
extends Formatter {
    private static final byte[] ZERO = Token.token("Null");
    private static final byte[][] WORDS = Token.tokens("", "eins", "zwei", "drei", "vier", "f\u00fcnf", "sechs", "sieben", "acht", "neun", "zehn", "elf", "zw\u00f6lf", "dreizehn", "vierzehn", "f\u00fcnfzehn", "sechzehn", "siebzehn", "achtzehn", "neunzehn");
    private static final byte[][] WORDS20 = Token.tokens("", "", "zwanzig", "drei\u00dfig", "vierzig", "f\u00fcnfzig", "sechzig", "siebzig", "achtzig", "neunzig");
    private static final byte[][] WORDS1000000 = Token.tokens("million", "milliard", "billion", "billiard", "trillion");
    private static final long[] UNITS100 = new long[]{1000000L, 1000000000L, 1000000000000L, 1000000000000000L, 1000000000000000000L};
    private static final byte[][] ORDINALS = Token.tokens("", "erst", "zweit", "dritt", "viert", "f\u00fcnft", "sechst", "siebt", "acht", "neunt", "zehnt", "elft", "zw\u00f6lft", "dreizehnt", "vierzehnt", "f\u00fcnfzehnt", "sechzehnt", "siebzehnt", "achtzehnt", "neunzehnt");
    private static final byte[][][] DAYS = new byte[][][]{Token.tokens("Mo", "Mon", "Montag"), Token.tokens("Di", "Die", "Dienstag"), Token.tokens("Mi", "Mit", "Mittwoch"), Token.tokens("Do", "Don", "Donnerstag"), Token.tokens("Fr", "Fre", "Freitag"), Token.tokens("Sa", "Sam", "Samstag"), Token.tokens("So", "Son", "Sonntag")};
    private static final byte[][] MONTHS = Token.tokens("Januar", "Februar", "M\u00e4rz", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember");
    private static final byte[][] AMPM = Token.tokens("a.m.", "p.m.");
    private static final byte[] UND = Token.token("und");
    private static final byte[] EIN = Token.token("ein");
    private static final byte[] EINE = Token.token("eine");
    private static final byte[] E = Token.token("e");
    private static final byte[] HUNDERT = Token.token("hundert");
    private static final byte[] TAUSEND = Token.token("tausend");
    private static final byte[][] ERAS = Token.tokens("v. Chr.", "n. Chr.");

    FormatterDE() {
    }

    @Override
    public byte[] word(long n, byte[] ord) {
        TokenBuilder tb = new TokenBuilder();
        if (n == 0L) {
            tb.add(ZERO);
            if (ord != null) {
                tb.add("t").add(ord.length == 0 ? E : ord);
            }
        } else {
            FormatterDE.word(tb, n, ord);
        }
        TokenParser tp = new TokenParser(tb.finish());
        tb.reset();
        boolean u = true;
        while (tp.more()) {
            tb.add(u ? Token.uc(tp.next()) : Token.lc(tp.next()));
            u = false;
        }
        return tb.finish();
    }

    @Override
    public byte[] ordinal(long n, byte[] ord) {
        return ord == null ? Token.EMPTY : E;
    }

    @Override
    public byte[] month(int n, int min, int max) {
        TokenBuilder tb = new TokenBuilder();
        tb.add(Token.substring(MONTHS[n], 0, Math.max(3, max)));
        while (tb.size() < min) {
            tb.add(32);
        }
        return tb.finish();
    }

    @Override
    public byte[] day(int n, int min, int max) {
        TokenBuilder tb = new TokenBuilder();
        byte[][] formats = DAYS[n];
        int f = formats.length;
        while (--f > 0 && max < formats[f].length) {
        }
        tb.add(formats[f]);
        while (tb.size() < min) {
            tb.add(32);
        }
        return tb.finish();
    }

    @Override
    public byte[] ampm(boolean am) {
        return AMPM[am ? 0 : 1];
    }

    @Override
    public byte[] calendar() {
        return ERAS[1];
    }

    @Override
    public byte[] era(long year) {
        return ERAS[year <= 0L ? 0 : 1];
    }

    private static void word(TokenBuilder tb, long n, byte[] ord) {
        if (n == 0L) {
            if (ord != null) {
                tb.add("st").add(ord.length == 0 ? E : ord);
            }
        } else if (n < 20L) {
            if (ord == null) {
                tb.add(WORDS[(int)n]);
            } else {
                tb.add(ORDINALS[(int)n]).add(ord.length == 0 ? E : ord);
            }
        } else if (n < 100L) {
            int r = (int)(n % 10L);
            if (r != 0) {
                tb.add(r == 1 ? EIN : WORDS[r]).add(UND);
            }
            tb.add(WORDS20[(int)n / 10]);
            if (ord != null) {
                tb.add("st").add(ord.length == 0 ? E : ord);
            }
        } else if (n < 1000L) {
            if (n < 200L) {
                tb.add("ein");
            } else {
                FormatterDE.word(tb, n / 100L, null);
            }
            tb.add(HUNDERT);
            FormatterDE.word(tb, n % 100L, ord);
        } else if (n < 1000000L) {
            if (n < 2000L) {
                tb.add("ein");
            }
            if (n >= 2000L) {
                FormatterDE.word(tb, n / 1000L, null);
            }
            tb.add(TAUSEND);
            FormatterDE.word(tb, n % 1000L, ord);
        } else {
            int w = WORDS1000000.length;
            while (--w > 0 && n < UNITS100[w]) {
            }
            long f = UNITS100[w];
            long i = n / f;
            if (ord == null) {
                if (i == 1L) {
                    tb.add(EINE);
                } else {
                    FormatterDE.word(tb, i, null);
                }
                tb.add(32);
            } else if (i != 1L) {
                FormatterDE.word(tb, i, null);
            }
            tb.add(WORDS1000000[w]);
            long r = n % f;
            if (ord != null && r == 0L) {
                tb.add("st").add(ord.length == 0 ? E : ord);
            } else if (i > 1L) {
                tb.add("en");
            } else if (Token.endsWith(WORDS1000000[w], 102)) {
                tb.add("e");
            }
            if (r != 0L) {
                tb.add(32);
                FormatterDE.word(tb, r, ord);
            }
        }
    }
}

