/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.inspect;

import org.basex.io.IO;
import org.basex.query.LibraryModule;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryParser;
import org.basex.query.QueryText;
import org.basex.query.StaticScope;
import org.basex.query.func.StaticFunc;
import org.basex.query.util.Ann;
import org.basex.query.util.inspect.Inspect;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.StaticVar;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;

public final class XQDoc
extends Inspect {
    private static final byte[] URI = Token.token("http://www.xqdoc.org/1.0");
    private static final byte[] PREFIX = Token.token("xqdoc");
    private final TokenMap nsCache = new TokenMap();

    public XQDoc(QueryContext qc, InputInfo ii) {
        super(qc, ii);
    }

    @Override
    public FElem parse(IO io) throws QueryException {
        QueryParser qp = this.parseQuery(io);
        FElem xqdoc = new FElem(PREFIX, PREFIX, URI).declareNS();
        FElem control = this.elem("control", xqdoc);
        this.elem("date", control).add(this.ctx.initDateTime().dtm.string(this.info));
        this.elem("version", control).add("1.1");
        String type = this.module instanceof LibraryModule ? "library" : "main";
        FElem mod = this.elem("module", xqdoc).add("type", type);
        if (this.module instanceof LibraryModule) {
            QNm name = ((LibraryModule)this.module).name;
            this.elem("uri", mod).add(name.uri());
            this.elem("name", mod).add(io.name());
        } else {
            this.elem("uri", mod).add(io.name());
        }
        this.comment(this.module, mod);
        FElem namespaces = this.elem("namespaces", xqdoc);
        for (byte[] pref : qp.namespaces) {
            this.nsCache.put(pref, qp.namespaces.get(pref));
        }
        FElem imports = this.elem("imports", xqdoc);
        for (byte[] imp : qp.modules) {
            this.elem("uri", this.elem("import", imports).add("type", "library")).add(imp);
        }
        FElem variables = this.elem("variables", xqdoc);
        for (StaticVar sv : qp.vars) {
            FElem variable = this.elem("variable", variables);
            this.elem("name", variable).add(sv.name.string());
            if (sv.name.hasPrefix()) {
                this.nsCache.put(sv.name.prefix(), sv.name.uri());
            }
            this.comment(sv, variable);
            this.annotations(sv.ann, variable);
            this.type(sv.type(), variable);
        }
        FElem functions = this.elem("functions", xqdoc);
        for (StaticFunc sf : qp.funcs) {
            int al = sf.arity();
            QNm name = sf.funcName();
            FuncType t = sf.funcType();
            FElem function = this.elem("function", functions).add("arity", Token.token(al));
            this.comment(sf, function);
            this.elem("name", function).add(name.string());
            if (name.hasPrefix()) {
                this.nsCache.put(name.prefix(), name.uri());
            }
            this.annotations(sf.ann, function);
            TokenBuilder tb = new TokenBuilder("declare").add(32).addExt(sf.ann, new Object[0]);
            tb.add("function").add(32).add(name.string()).add("(");
            for (int i = 0; i < al; ++i) {
                Var v = sf.args[i];
                if (i > 0) {
                    tb.add(", ");
                }
                tb.add("$").add(v.name.string()).add(32).add("as").add(32).addExt(t.args[i], new Object[0]);
            }
            tb.add(")").add(" as " + t.ret);
            if (sf.expr == null) {
                tb.add(" external");
            }
            this.elem("signature", function).add(tb.toString());
            if (al != 0) {
                FElem fparameters = this.elem("parameters", function);
                for (int a = 0; a < al; ++a) {
                    FElem fparameter = this.elem("parameter", fparameters);
                    Var v = sf.args[a];
                    this.elem("name", fparameter).add(v.name.string());
                    this.type(t.args[a], fparameter);
                }
            }
            this.type(sf.type(), this.elem("return", function));
        }
        for (byte[] pref : this.nsCache) {
            FElem namespace = this.elem("namespace", namespaces);
            namespace.add("prefix", pref).add("uri", this.nsCache.get(pref));
        }
        return xqdoc;
    }

    @Override
    protected FElem elem(String name, FElem parent) {
        FElem elem = new FElem(PREFIX, Token.token(name), URI);
        parent.add(elem);
        return elem;
    }

    @Override
    protected FElem tag(byte[] tag, FElem parent) {
        return Token.eq(tag, QueryText.DOC_TAGS) ? this.elem(Token.string(tag), parent) : this.elem("custom", parent).add("tag", tag);
    }

    private void comment(StaticScope scope, FElem parent) {
        TokenObjMap<TokenList> map = scope.doc();
        if (map != null) {
            this.comment(map, this.elem("comment", parent));
        }
    }

    private void annotations(Ann ann, FElem parent) throws QueryException {
        if (!ann.isEmpty()) {
            this.annotation(ann, this.elem("annotations", parent), false);
        }
        for (int a = 0; a < ann.size(); ++a) {
            QNm name = ann.names[a];
            if (!name.hasPrefix()) continue;
            this.nsCache.put(name.prefix(), name.uri());
        }
    }

    private void type(SeqType st, FElem parent) {
        if (st == null) {
            return;
        }
        FElem type = this.elem("type", parent).add(st.typeString());
        String occ = st.occ.toString();
        if (!occ.isEmpty()) {
            type.add("occurrence", occ);
        }
    }
}

