/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.pkg;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.basex.core.Context;
import org.basex.core.GlobalOptions;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.query.QueryException;
import org.basex.query.QueryModule;
import org.basex.query.QueryParser;
import org.basex.query.QueryText;
import org.basex.query.util.Err;
import org.basex.query.util.pkg.JarDesc;
import org.basex.query.util.pkg.JarParser;
import org.basex.query.util.pkg.Package;
import org.basex.query.util.pkg.PkgParser;
import org.basex.query.util.pkg.PkgText;
import org.basex.query.util.pkg.PkgValidator;
import org.basex.util.InputInfo;
import org.basex.util.JarLoader;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.Version;
import org.basex.util.hash.TokenSet;

public final class ModuleLoader {
    private static final ClassLoader LOADER = Thread.currentThread().getContextClassLoader();
    private final ArrayList<URL> urls = new ArrayList();
    private ClassLoader loader = LOADER;
    private HashMap<Object, ArrayList<Method>> javaModules;
    private final Context context;

    public ModuleLoader(Context ctx) {
        this.context = ctx;
    }

    public void close() {
        if (this.loader instanceof JarLoader) {
            ((JarLoader)this.loader).close();
        }
    }

    public boolean addImport(byte[] uri, InputInfo ii, QueryParser qp) throws QueryException {
        String path;
        boolean java;
        String uriPath;
        TokenSet pkgs = this.context.repo.nsDict().get(uri);
        if (pkgs != null) {
            Version ver = null;
            byte[] nm = null;
            for (byte[] name : pkgs) {
                Version v = new Version(Package.version(name));
                if (ver != null && v.compareTo(ver) <= 0) continue;
                ver = v;
                nm = name;
            }
            if (nm != null) {
                this.addRepo(nm, new TokenSet(), new TokenSet(), ii, qp);
                return true;
            }
        }
        if ((uriPath = ModuleLoader.uri2path(Token.string((java = Token.startsWith(uri, QueryText.JAVAPREF)) ? Token.substring(uri, QueryText.JAVAPREF.length) : uri))) == null) {
            return false;
        }
        if (!java) {
            path = this.context.globalopts.get(GlobalOptions.REPOPATH) + uriPath;
            for (String suf : IO.XQSUFFIXES) {
                IOFile file = new IOFile(path + suf);
                if (!file.exists()) continue;
                qp.module(Token.token(file.path()), uri);
                return true;
            }
        }
        uriPath = ModuleLoader.capitalize(uriPath);
        path = this.context.globalopts.get(GlobalOptions.REPOPATH) + uriPath;
        IOFile file = new IOFile(path + ".jar");
        if (file.exists()) {
            this.addURL(file);
        }
        this.addJava(uriPath, ii);
        return true;
    }

    public Class<?> findClass(String name) throws Throwable {
        int us = this.urls.size();
        if (us != 0) {
            this.loader = new JarLoader(this.urls.toArray(new URL[us]), this.loader);
            this.urls.clear();
        }
        return this.loader == LOADER ? Reflect.forName(name) : Class.forName(name, true, this.loader);
    }

    public Object findImport(String clz) {
        if (this.javaModules != null) {
            for (Object jm : this.javaModules.keySet()) {
                if (!jm.getClass().getName().equals(clz)) continue;
                return jm;
            }
        }
        return null;
    }

    public static String uri2path(String uri) {
        try {
            URI u = new URI(uri);
            TokenBuilder tb = new TokenBuilder();
            String auth = u.getAuthority();
            if (auth != null) {
                String[] comp = auth.split("\\.");
                for (int c = comp.length - 1; c >= 0; --c) {
                    tb.add(47).add(comp[c]);
                }
            } else {
                tb.add(47);
            }
            String path = u.getPath();
            if (path == null) {
                return null;
            }
            tb.add((path = path.replace('.', '/')).isEmpty() ? "/" : path);
            String pth = tb.toString();
            return pth.endsWith("/") ? pth + "index" : pth;
        }
        catch (URISyntaxException ex) {
            Util.debug(ex);
            return null;
        }
    }

    public static String capitalize(String path) {
        int i = path.lastIndexOf(47);
        return i == -1 || i + 1 >= path.length() ? path : path.substring(0, i + 1) + Character.toUpperCase(path.charAt(i + 1)) + path.substring(i + 2);
    }

    private void addJava(String path, InputInfo ii) throws QueryException {
        Class<?> clz;
        String cp = Token.camelCase(path.replace('/', '.').substring(1));
        try {
            clz = this.findClass(cp);
        }
        catch (ClassNotFoundException ex) {
            throw Err.WHICHCLASS.get(ii, ex.getMessage());
        }
        catch (Throwable th) {
            throw Err.MODINITERR.get(ii, th);
        }
        boolean qm = clz.getSuperclass() == QueryModule.class;
        Object jm = Reflect.get(clz);
        if (jm == null) {
            throw Err.INSTERR.get(ii, cp);
        }
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method m : clz.getMethods()) {
            if (qm && m.getDeclaringClass() != clz) continue;
            list.add(m);
        }
        if (this.javaModules == null) {
            this.javaModules = new HashMap();
        }
        this.javaModules.put(jm, list);
    }

    private void addRepo(byte[] name, TokenSet toLoad, TokenSet loaded, InputInfo ii, QueryParser qp) throws QueryException {
        if (loaded.contains(name)) {
            return;
        }
        byte[] pDir = this.context.repo.pkgDict().get(name);
        if (pDir == null) {
            throw Err.BXRE_NOTINST.get(ii, new Object[]{name});
        }
        IOFile pkgDir = this.context.repo.path(Token.string(pDir));
        IOFile pkgDesc = new IOFile(pkgDir, "expath-pkg.xml");
        if (!((IO)pkgDesc).exists()) {
            Util.debug("Missing package descriptor for package '%'", Token.string(name));
        }
        Package pkg = new PkgParser(this.context.repo, ii).parse(pkgDesc);
        IOFile jarDesc = new IOFile(pkgDir, PkgText.JARDESC);
        if (jarDesc.exists()) {
            this.addJar(jarDesc, pkgDir, Token.string(pkg.abbrev), ii);
        }
        if (!pkg.dep.isEmpty()) {
            toLoad.add(name);
        }
        for (Package.Dependency d : pkg.dep) {
            if (d.pkg == null) continue;
            byte[] depPkg = new PkgValidator(this.context.repo, ii).depPkg(d);
            if (depPkg == null) {
                throw Err.BXRE_NOTINST.get(ii, Token.string(d.pkg));
            }
            if (toLoad.contains(depPkg)) {
                throw Err.CIRCMODULE.get(ii, new Object[0]);
            }
            this.addRepo(depPkg, toLoad, loaded, ii, qp);
        }
        for (Package.Component comp : pkg.comps) {
            String p = new IOFile(new IOFile(pkgDir, Token.string(pkg.abbrev)), Token.string(comp.file)).path();
            qp.module(Token.token(p), comp.uri);
        }
        if (toLoad.contains(name)) {
            toLoad.delete(name);
        }
        loaded.add(name);
    }

    private void addJar(IOFile jarDesc, IOFile pkgDir, String modDir, InputInfo ii) throws QueryException {
        JarDesc desc = new JarParser(this.context, ii).parse(jarDesc);
        for (byte[] u : desc.jars) {
            this.addURL(new IOFile(new IOFile(pkgDir, modDir), Token.string(u)));
        }
    }

    private void addURL(IOFile jar) {
        try {
            this.urls.add(new URL(jar.url()));
        }
        catch (MalformedURLException ex) {
            Util.errln(ex, new Object[0]);
        }
    }
}

