/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import org.basex.data.ExprInfo;
import org.basex.io.in.ArrayInput;
import org.basex.io.in.BufferInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.Collation;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Int;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public abstract class Item
extends Value {
    public static final int UNDEF = Integer.MIN_VALUE;
    protected Double score;

    protected Item(Type t) {
        super(t);
    }

    @Override
    public final ValueIter iter() {
        return new ValueIter(){
            private boolean req;

            @Override
            public Item next() {
                if (this.req) {
                    return null;
                }
                this.req = true;
                return Item.this;
            }

            @Override
            public long size() {
                return 1L;
            }

            @Override
            public Item get(long i) {
                return Item.this;
            }

            @Override
            public boolean reset() {
                this.req = false;
                return true;
            }

            @Override
            public Value value() {
                return Item.this;
            }
        };
    }

    @Override
    public final Item item(QueryContext ctx, InputInfo ii) {
        return this;
    }

    @Override
    public final Item itemAt(long pos) {
        return this;
    }

    @Override
    public final Item ebv(QueryContext ctx, InputInfo ii) {
        return this;
    }

    @Override
    public Item test(QueryContext ctx, InputInfo ii) throws QueryException {
        return this.bool(ii) ? this : null;
    }

    @Override
    public final boolean isItem() {
        return true;
    }

    public abstract byte[] string(InputInfo var1) throws QueryException;

    public boolean bool(InputInfo ii) throws QueryException {
        throw Err.CONDTYPE.get(ii, this.type, this);
    }

    public BigDecimal dec(InputInfo ii) throws QueryException {
        return Dec.parse(this.string(ii), ii);
    }

    public long itr(InputInfo ii) throws QueryException {
        return Int.parse(this.string(ii), ii);
    }

    public float flt(InputInfo ii) throws QueryException {
        return Flt.parse(this.string(ii), ii);
    }

    public double dbl(InputInfo ii) throws QueryException {
        return Dbl.parse(this.string(ii), ii);
    }

    public final boolean comparable(Item it) {
        Type t1 = this.type;
        Type t2 = it.type;
        return t1 == t2 || this instanceof ANum && it instanceof ANum || t1.isStringOrUntyped() && t2.isStringOrUntyped() || this instanceof Dur && it instanceof Dur;
    }

    public abstract boolean eq(Item var1, Collation var2, InputInfo var3) throws QueryException;

    public final boolean equiv(Item it, Collation coll, InputInfo ii) throws QueryException {
        return (this == Dbl.NAN || this == Flt.NAN) && it instanceof ANum && Double.isNaN(it.dbl(ii)) || this.comparable(it) && this.eq(it, coll, ii);
    }

    public int diff(Item it, Collation coll, InputInfo ii) throws QueryException {
        throw (this == it ? Err.TYPECMP : Err.INVTYPECMP).get(ii, this.type, it.type);
    }

    public BufferInput input(InputInfo ii) throws QueryException {
        return new ArrayInput(this.string(ii));
    }

    public Item materialize(InputInfo ii) throws QueryException {
        return this;
    }

    @Override
    public final SeqType type() {
        return this.type.seqType();
    }

    @Override
    public final long size() {
        return 1L;
    }

    @Override
    public final boolean iterable() {
        return true;
    }

    public double score() {
        return this.score == null ? 0.0 : this.score;
    }

    public final void score(double s) {
        if (this.score != null || s != 0.0) {
            this.score = s;
        }
    }

    @Override
    public String description() {
        return this.type.toString();
    }

    @Override
    public void plan(FElem plan) {
        try {
            this.addPlan(plan, this.planElem(QueryText.VAL, this.string(null), QueryText.TYP, this.type), new ExprInfo[0]);
        }
        catch (QueryException ex) {
            throw Util.notExpected(ex);
        }
    }

    @Override
    public int hash(InputInfo ii) throws QueryException {
        return Token.hash(this.string(ii));
    }

    @Override
    public final int writeTo(Item[] arr, int start) {
        arr[start] = this;
        return 1;
    }

    @Override
    public final boolean homogeneous() {
        return true;
    }

    public byte[] xdmInfo() {
        return this.typeId().bytes();
    }

    public Type.ID typeId() {
        return this.type.id();
    }
}

