/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import org.basex.query.QueryException;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.Branch;
import org.basex.query.value.map.Leaf;
import org.basex.query.value.map.TrieNode;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.util.Array;
import org.basex.util.InputInfo;

final class List
extends TrieNode {
    final int hash;
    final Item[] keys;
    final Value[] values;

    List(int h, Item[] ks, Value[] vs) {
        super(ks.length);
        this.keys = ks;
        this.values = vs;
        this.hash = h;
        assert (this.verify());
    }

    List(int h, Item k1, Value v1, Item k2, Value v2) {
        this(h, new Item[]{k1, k2}, new Value[]{v1, v2});
    }

    @Override
    TrieNode delete(int h, Item k, int l, InputInfo ii) throws QueryException {
        if (h == this.hash) {
            int i = this.size;
            while (i-- > 0) {
                if (!List.eq(k, this.keys[i], ii)) continue;
                if (this.size == 2) {
                    int o = i ^ 1;
                    return new Leaf(h, this.keys[o], this.values[o]);
                }
                return new List(h, Array.delete(this.keys, i), Array.delete(this.values, i));
            }
        }
        return this;
    }

    @Override
    TrieNode insert(int h, Item k, Value v, int l, InputInfo ii) throws QueryException {
        int used;
        int b;
        if (h == this.hash) {
            int i = this.keys.length;
            while (i-- > 0) {
                if (!List.eq(k, this.keys[i], ii)) continue;
                Value[] vs = (Value[])this.values.clone();
                vs[i] = v;
                return new List(h, (Item[])this.keys.clone(), vs);
            }
            return new List(this.hash, Array.add(this.keys, k), Array.add(this.values, v));
        }
        TrieNode[] ch = new TrieNode[32];
        int a = List.key(h, l);
        if (a == (b = List.key(this.hash, l))) {
            ch[a] = this.insert(h, k, v, l + 1, ii);
            used = 1 << a;
        } else {
            ch[a] = new Leaf(h, k, v);
            ch[b] = this;
            used = 1 << a | 1 << b;
        }
        return new Branch(ch, used, this.size + 1);
    }

    @Override
    Value get(int h, Item k, int l, InputInfo ii) throws QueryException {
        if (h == this.hash) {
            int i = this.keys.length;
            while (i-- != 0) {
                if (!List.eq(k, this.keys[i], ii)) continue;
                return this.values[i];
            }
        }
        return null;
    }

    @Override
    boolean contains(int h, Item k, int u, InputInfo ii) throws QueryException {
        if (h == this.hash) {
            int i = this.keys.length;
            while (i-- != 0) {
                if (!List.eq(k, this.keys[i], ii)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    StringBuilder toString(StringBuilder sb, String ind) {
        sb.append(ind).append("`-- Collision (").append(Integer.toHexString(this.hash)).append("):\n");
        for (int i = 0; i < this.keys.length; ++i) {
            sb.append(ind).append("      ").append(this.keys[i]).append(" => ").append(this.values[i]).append('\n');
        }
        return sb;
    }

    @Override
    TrieNode addAll(TrieNode o, int l, InputInfo ii) throws QueryException {
        return o.add(this, l, ii);
    }

    @Override
    TrieNode add(Leaf o, int l, InputInfo ii) throws QueryException {
        int nu;
        int ok;
        if (this.hash == o.hash) {
            for (Item k : this.keys) {
                if (!List.eq(k, o.key, ii)) continue;
                return this;
            }
            return new List(this.hash, Array.add(this.keys, o.key), Array.add(this.values, o.value));
        }
        TrieNode[] ch = new TrieNode[32];
        int k = List.key(this.hash, l);
        if (k == (ok = List.key(o.hash, l))) {
            ch[k] = this.add(o, l + 1, ii);
            nu = 1 << k;
        } else {
            ch[k] = this;
            ch[ok] = o;
            nu = 1 << k | 1 << ok;
        }
        return new Branch(ch, nu, this.size + 1);
    }

    @Override
    TrieNode add(List o, int l, InputInfo ii) throws QueryException {
        int nu;
        int ok;
        if (this.hash == o.hash) {
            Item[] ks = this.keys;
            Value[] vs = this.values;
            block0: for (int i = 0; i < this.size; ++i) {
                Item ok2 = o.keys[i];
                for (Item k : this.keys) {
                    if (List.eq(k, ok2, ii)) continue block0;
                }
                ks = Array.add(ks, ok2);
                vs = Array.add(vs, o.values[i]);
            }
            return ks == this.keys ? this : new List(this.hash, ks, vs);
        }
        TrieNode[] ch = new TrieNode[32];
        int k = List.key(this.hash, l);
        if (k == (ok = List.key(o.hash, l))) {
            ch[k] = this.add(o, l + 1, ii);
            nu = 1 << k;
        } else {
            ch[k] = this;
            ch[ok] = o;
            nu = 1 << k | 1 << ok;
        }
        return new Branch(ch, nu, this.size + o.size);
    }

    @Override
    TrieNode add(Branch o, int l, InputInfo ii) throws QueryException {
        int k = List.key(this.hash, l);
        TrieNode[] ch = o.copyKids();
        TrieNode old = ch[k];
        TrieNode trieNode = old == null ? this : old.addAll(this, l + 1, ii);
        ch[k] = trieNode;
        return new Branch(ch, o.used | 1 << k, o.size + this.size - (old != null ? old.size : 0));
    }

    @Override
    boolean verify() {
        try {
            for (int i = 1; i < this.size; ++i) {
                int j = i;
                while (j-- > 0) {
                    if (!List.eq(this.keys[i], this.keys[j], null)) continue;
                    return false;
                }
            }
        }
        catch (QueryException ex) {
            return false;
        }
        return true;
    }

    @Override
    void keys(ValueBuilder ks) {
        for (Item k : this.keys) {
            ks.add(k);
        }
    }

    @Override
    boolean hasType(AtomType kt, SeqType vt) {
        if (kt != null) {
            for (Value value : this.keys) {
                if (((Item)value).type.instanceOf(kt)) continue;
                return false;
            }
        }
        if (vt != null) {
            for (Value value : this.values) {
                if (vt.instance(value)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    int hash(InputInfo ii) throws QueryException {
        int h = this.hash;
        int i = this.size;
        while (--i >= 0) {
            h ^= this.values[i].hash(ii);
        }
        return h;
    }

    @Override
    boolean deep(InputInfo ii, TrieNode o) throws QueryException {
        if (!(o instanceof List) || this.size != o.size) {
            return false;
        }
        List ol = (List)o;
        block0: for (int i = 0; i < this.size; ++i) {
            Item k = this.keys[i];
            for (int j = 0; j < this.size; ++j) {
                if (!List.eq(k, ol.keys[i], ii)) continue;
                if (List.deep(this.values[i], ol.values[j], ii)) continue block0;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    StringBuilder toString(StringBuilder sb) {
        int i = this.size;
        while (--i >= 0) {
            sb.append(this.keys[i]).append(":=").append(this.values[i]).append(", ");
        }
        return sb;
    }
}

