/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.util.Arrays;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;

public final class DblSeq
extends NativeSeq {
    private final double[] values;

    private DblSeq(double[] vals) {
        super(vals.length, (Type)AtomType.DBL);
        this.values = vals;
    }

    @Override
    public Dbl itemAt(long pos) {
        return Dbl.get(this.values[(int)pos]);
    }

    @Override
    public boolean sameAs(Expr cmp) {
        return cmp instanceof DblSeq && Arrays.equals(this.values, ((DblSeq)cmp).values);
    }

    public double[] toJava() {
        return this.values;
    }

    @Override
    public Value reverse() {
        int s = this.values.length;
        double[] tmp = new double[s];
        int l = 0;
        int r = s - 1;
        while (l < s) {
            tmp[l] = this.values[r];
            ++l;
            --r;
        }
        return DblSeq.get(tmp);
    }

    public static Value get(double[] items) {
        return items.length == 0 ? Empty.SEQ : (items.length == 1 ? Dbl.get(items[0]) : new DblSeq(items));
    }

    public static Value get(Value[] vals, int size) throws QueryException {
        double[] tmp = new double[size];
        int t = 0;
        for (Value val : vals) {
            int vs = (int)val.size();
            if (val instanceof Item) {
                tmp[t++] = ((Item)val).dbl(null);
                continue;
            }
            if (val instanceof DblSeq) {
                DblSeq sq = (DblSeq)val;
                System.arraycopy(sq.values, 0, tmp, t, vs);
                t += vs;
                continue;
            }
            for (int v = 0; v < vs; ++v) {
                tmp[t++] = val.itemAt(v).dbl(null);
            }
        }
        return DblSeq.get(tmp);
    }
}

