/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class ItemSeq
extends Seq {
    private final Item[] item;
    private Type ret;

    private ItemSeq(Item[] it, int s) {
        super(s);
        this.item = it;
    }

    ItemSeq(Item[] it, int s, Type t) {
        this(it, s);
        this.ret = t;
    }

    @Override
    public Item ebv(QueryContext ctx, InputInfo ii) throws QueryException {
        if (this.item[0] instanceof ANode) {
            return this.item[0];
        }
        throw Err.CONDTYPE.get(ii, this);
    }

    @Override
    public SeqType type() {
        if (this.ret == null) {
            Type t = this.item[0].type;
            int s = 1;
            while ((long)s < this.size) {
                if (t != this.item[s].type) {
                    t = AtomType.ITEM;
                    break;
                }
                ++s;
            }
            this.ret = t;
            this.type = t;
        }
        return SeqType.get(this.ret, SeqType.Occ.ONE_MORE);
    }

    @Override
    public boolean iterable() {
        return false;
    }

    @Override
    public boolean sameAs(Expr cmp) {
        if (!(cmp instanceof ItemSeq)) {
            return false;
        }
        ItemSeq is = (ItemSeq)cmp;
        return this.item == is.item && this.size == is.size;
    }

    @Override
    public int writeTo(Item[] arr, int start) {
        System.arraycopy(this.item, 0, arr, start, (int)this.size);
        return (int)this.size;
    }

    @Override
    public Item itemAt(long pos) {
        return this.item[(int)pos];
    }

    @Override
    public boolean homogeneous() {
        return this.ret != null && this.ret != AtomType.ITEM;
    }

    @Override
    public Value reverse() {
        int s = this.item.length;
        Item[] tmp = new Item[s];
        int l = 0;
        int r = s - 1;
        while (l < s) {
            tmp[l] = this.item[r];
            ++l;
            --r;
        }
        return ItemSeq.get(tmp, s, this.type);
    }
}

