/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.api.dom.BXAttr;
import org.basex.api.dom.BXComm;
import org.basex.api.dom.BXDoc;
import org.basex.api.dom.BXElem;
import org.basex.api.dom.BXNode;
import org.basex.api.dom.BXPI;
import org.basex.api.dom.BXText;
import org.basex.build.MemBuilder;
import org.basex.build.xml.DOMWrapper;
import org.basex.core.MainOptions;
import org.basex.io.IOContent;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FAttr;
import org.basex.query.value.node.FComm;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FPI;
import org.basex.query.value.node.FTxt;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public enum NodeType implements Type
{
    NOD("node", AtomType.ITEM, Type.ID.NOD),
    TXT("text", NOD, Type.ID.TXT){

        @Override
        public ANode cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) {
            if (o instanceof BXText) {
                return ((BXNode)o).getNode();
            }
            if (o instanceof Text) {
                return new FTxt((Text)o);
            }
            return new FTxt(o.toString());
        }
    }
    ,
    PI("processing-instruction", NOD, Type.ID.PI){

        @Override
        public ANode cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            if (o instanceof BXPI) {
                return ((BXNode)o).getNode();
            }
            if (o instanceof ProcessingInstruction) {
                return new FPI((ProcessingInstruction)o);
            }
            Matcher m = Pattern.compile("<\\?(.*?) (.*)\\?>").matcher(o.toString());
            if (m.find()) {
                return new FPI(m.group(1), m.group(2));
            }
            throw Err.NODEERR.get(ii, this, Err.chop(o));
        }
    }
    ,
    ELM("element", NOD, Type.ID.ELM){

        @Override
        public ANode cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            if (o instanceof BXElem) {
                return ((BXNode)o).getNode();
            }
            if (o instanceof Element) {
                return new FElem((Element)o, null, new TokenMap());
            }
            try {
                return new DBNode(new IOContent(o.toString()), new MainOptions()).children().next();
            }
            catch (IOException ex) {
                throw Err.NODEERR.get(ii, this, ex);
            }
        }
    }
    ,
    DOC("document-node", NOD, Type.ID.DOC){

        @Override
        public ANode cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            if (o instanceof BXDoc) {
                return ((BXNode)o).getNode();
            }
            try {
                if (o instanceof Document) {
                    DOMWrapper p = new DOMWrapper((Document)o, "", new MainOptions());
                    return new DBNode(MemBuilder.build(p));
                }
                if (o instanceof DocumentFragment) {
                    DocumentFragment df;
                    String bu = (df = (DocumentFragment)o).getBaseURI();
                    return new FDoc(df, bu != null ? Token.token(bu) : Token.EMPTY);
                }
                String c = o.toString();
                if (c.startsWith("<")) {
                    return new DBNode(new IOContent(c), new MainOptions());
                }
                return new FDoc().add(new FTxt(c));
            }
            catch (IOException ex) {
                throw Err.NODEERR.get(ii, this, ex);
            }
        }
    }
    ,
    DEL("document-node(element())", NOD, Type.ID.DEL){

        @Override
        public Item cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return DOC.cast(o, ctx, sc, ii);
        }
    }
    ,
    ATT("attribute", NOD, Type.ID.ATT){

        @Override
        public ANode cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            if (o instanceof BXAttr) {
                return ((BXNode)o).getNode();
            }
            if (o instanceof Attr) {
                return new FAttr((Attr)o);
            }
            Matcher m = Pattern.compile(" (.*?)=\"(.*)\"").matcher(o.toString());
            if (m.find()) {
                return new FAttr(m.group(1), m.group(2));
            }
            throw Err.NODEERR.get(ii, this, Err.chop(o));
        }
    }
    ,
    COM("comment", NOD, Type.ID.COM){

        @Override
        public ANode cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            if (o instanceof BXComm) {
                return ((BXNode)o).getNode();
            }
            if (o instanceof Comment) {
                return new FComm((Comment)o);
            }
            Matcher m = Pattern.compile("<!--(.*?)-->").matcher(o.toString());
            if (m.find()) {
                return new FComm(m.group(1));
            }
            throw Err.NODEERR.get(ii, this, Err.chop(o));
        }
    }
    ,
    NSP("namespace-node", NOD, Type.ID.NSP),
    SCE("schema-element", NOD, Type.ID.SCE),
    SCA("schema-attribute", NOD, Type.ID.SCA);

    private static final NodeType[] VALUES;
    private final byte[] string;
    private final Type par;
    private final Type.ID id;
    private SeqType seq;

    private NodeType(String nm, Type pr, Type.ID i) {
        this.string = Token.token(nm);
        this.par = pr;
        this.id = i;
    }

    @Override
    public final boolean isNode() {
        return true;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isUntyped() {
        return true;
    }

    @Override
    public boolean isNumberOrUntyped() {
        return true;
    }

    @Override
    public boolean isStringOrUntyped() {
        return true;
    }

    @Override
    public Item cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
        return it.type == this ? it : this.error(it, ii);
    }

    @Override
    public Item cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
        throw Util.notExpected(o);
    }

    @Override
    public Item castString(String o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
        return this.cast(o, ctx, sc, ii);
    }

    @Override
    public SeqType seqType() {
        if (this.seq == null) {
            this.seq = new SeqType(this);
        }
        return this.seq;
    }

    @Override
    public boolean eq(Type t) {
        return this == t;
    }

    @Override
    public final boolean instanceOf(Type t) {
        return this == t || this.par.instanceOf(t);
    }

    @Override
    public Type union(Type t) {
        return (Type)((Object)(t.isNode() ? (this == t ? this : NOD) : AtomType.ITEM));
    }

    @Override
    public NodeType intersect(Type t) {
        if (!(t instanceof NodeType)) {
            return this.instanceOf(t) ? this : null;
        }
        return this == t ? this : (this == NOD ? (NodeType)t : (t == NOD ? this : null));
    }

    @Override
    public Type.ID id() {
        return this.id;
    }

    @Override
    public byte[] string() {
        return this.string;
    }

    @Override
    public String toString() {
        return new TokenBuilder(this.string).add("()").toString();
    }

    Item error(Item it, InputInfo ii) throws QueryException {
        throw Err.castError(ii, this, it);
    }

    public static NodeType find(QNm type) {
        if (type.uri().length == 0) {
            byte[] ln = type.local();
            for (NodeType t : VALUES) {
                if (!Token.eq(ln, t.string)) continue;
                return t;
            }
        }
        return null;
    }

    @Override
    public boolean nsSensitive() {
        return false;
    }

    static Type getType(Type.ID id) {
        for (NodeType t : VALUES) {
            if (t.id != id) continue;
            return t;
        }
        return null;
    }

    static {
        VALUES = NodeType.values();
    }
}

