/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.var;

import org.basex.data.ExprInfo;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Ann;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.var.StaticVar;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.IntObjMap;

public final class StaticVarRef
extends ParseExpr {
    private final QNm name;
    private StaticVar var;
    private final StaticContext sc;

    public StaticVarRef(InputInfo ii, QNm nm, StaticContext sctx) {
        super(ii);
        this.name = nm;
        this.sc = sctx;
    }

    @Override
    public void checkUp() {
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope o) throws QueryException {
        this.var.compile(ctx);
        this.type = this.var.type();
        return this.var.value != null ? this.var.value : this;
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        return this.value(ctx).iter();
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        return this.var.value(ctx);
    }

    @Override
    public boolean has(Expr.Flag flag) {
        return this.var != null && this.var.has(flag);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.staticVar(this.var);
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        StaticVarRef ref = new StaticVarRef(this.info, this.name, this.sc);
        ref.var = this.var;
        return ref;
    }

    @Override
    public int exprSize() {
        return 0;
    }

    @Override
    public String toString() {
        return '$' + Token.string(this.name.string());
    }

    @Override
    public boolean removable(Var v) {
        return true;
    }

    @Override
    public VarUsage count(Var v) {
        return VarUsage.NEVER;
    }

    @Override
    public Expr inline(QueryContext ctx, VarScope scp, Var v, Expr e) {
        return null;
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.VAR, this.name), new ExprInfo[0]);
    }

    public void init(StaticVar vr) throws QueryException {
        if (vr.ann.contains(Ann.Q_PRIVATE) && !Token.eq(this.sc.baseURI().string(), vr.sc.baseURI().string())) {
            throw Err.VARPRIVATE.get(this.info, vr);
        }
        this.var = vr;
    }
}

