/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.Collection;
import org.basex.util.TokenBuilder;
import org.basex.util.ft.FTIterator;
import org.basex.util.ft.InternalStemmer;
import org.basex.util.ft.Language;
import org.basex.util.ft.Stemmer;

final class GermanStemmer
extends InternalStemmer {
    private int subst;

    GermanStemmer(FTIterator fti) {
        super(fti);
    }

    @Override
    Stemmer get(Language l, FTIterator fti) {
        return new GermanStemmer(fti);
    }

    @Override
    Collection<Language> languages() {
        return GermanStemmer.collection("de");
    }

    @Override
    protected byte[] stem(byte[] word) {
        this.subst = 0;
        return GermanStemmer.part(GermanStemmer.resub(this.opt(this.strip(this.subst(new TokenBuilder(word)))))).finish();
    }

    private TokenBuilder subst(TokenBuilder tb) {
        this.subst = 0;
        int s = tb.size();
        TokenBuilder tmp = new TokenBuilder(s);
        int ls = 0;
        int nx = tb.cp(0);
        int c = 0;
        while (c < s) {
            int ch = nx;
            nx = (c += tb.cl(c)) < s ? tb.cp(c) : 0;
            int sb = 0;
            if (ch == ls) {
                ch = 42;
            } else if (ch == 228) {
                ch = 97;
            } else if (ch == 246) {
                ch = 111;
            } else if (ch == 252) {
                ch = 117;
            } else if (ch == 223) {
                tmp.add(115);
                ch = 115;
                ++this.subst;
            } else if (ch == 115 && nx == 99 && c + 1 < s && tb.get(c + 1) == 104) {
                ch = 1;
                sb = 2;
            } else if (ch == 99 && nx == 104) {
                ch = 2;
                sb = 1;
            } else if (ch == 101 && nx == 105) {
                ch = 3;
                sb = 1;
            } else if (ch == 105 && nx == 101) {
                ch = 4;
                sb = 1;
            } else if (ch == 105 && nx == 103) {
                ch = 5;
                sb = 1;
            } else if (ch == 115 && nx == 116) {
                ch = 6;
                sb = 1;
            }
            if (sb > 0) {
                nx = (c += sb) < s ? tb.cp(c) : 0;
                this.subst += sb;
            }
            ls = ch;
            tmp.add(ch);
        }
        return tmp;
    }

    private TokenBuilder strip(TokenBuilder tb) {
        while (tb.size() > 3) {
            int tl = tb.size();
            byte c1 = tb.get(tl - 1);
            byte c2 = tb.get(tl - 2);
            if (tl + this.subst > 5 && c2 == 110 && c1 == 100) {
                tb.size(tl - 2);
                continue;
            }
            if (tl + this.subst > 4 && c2 == 101 && (c1 == 109 || c1 == 114)) {
                tb.size(tl - 2);
                continue;
            }
            if (c1 != 101 && c1 != 115 && c1 != 110 && c1 != 116) break;
            tb.size(tl - 1);
        }
        return tb;
    }

    private TokenBuilder opt(TokenBuilder tb) {
        int tl = tb.size();
        if (tl > 5 && tb.get(tl - 5) == 101 && tb.get(tl - 4) == 114 && tb.get(tl - 3) == 105 && tb.get(tl - 2) == 110 && tb.get(tl - 1) == 42) {
            tb.size(tl - 1);
            this.strip(tb);
        }
        if (tb.get((tl = tb.size()) - 1) == 122) {
            tb.set(tl - 1, (byte)120);
        }
        return tb;
    }

    private static TokenBuilder resub(TokenBuilder tb) {
        TokenBuilder tmp = new TokenBuilder();
        int s = tb.size();
        for (int c = 0; c < s; ++c) {
            byte ch = tb.get(c);
            if (ch == 42) {
                tmp.add(tmp.get(c - 1));
                continue;
            }
            if (ch == 1) {
                tmp.add(115).add(99).add(104);
                continue;
            }
            if (ch == 2) {
                tmp.add(99).add(104);
                continue;
            }
            if (ch == 3) {
                tmp.add(101).add(105);
                continue;
            }
            if (ch == 4) {
                tmp.add(105).add(101);
                continue;
            }
            if (ch == 5) {
                tmp.add(105).add(103);
                continue;
            }
            if (ch == 6) {
                tmp.add(115).add(116);
                continue;
            }
            tmp.add(ch);
        }
        return tmp;
    }

    private static TokenBuilder part(TokenBuilder tb) {
        for (int c = 0; c < tb.size() - 4; ++c) {
            if (tb.get(c) != 103 || tb.get(c + 1) != 101 || tb.get(c + 2) != 103 || tb.get(c + 3) != 101) continue;
            tb.delete(c, 2);
            break;
        }
        return tb;
    }
}

