/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.ASet;

public class TokenSet
extends ASet
implements Iterable<byte[]> {
    protected byte[][] keys;

    public TokenSet() {
        super(8);
        this.keys = new byte[8][];
    }

    public TokenSet(byte[] ... key) {
        this();
        for (byte[] i : key) {
            this.add(i);
        }
    }

    public TokenSet(DataInput in) throws IOException {
        this.read(in);
    }

    protected void read(DataInput in) throws IOException {
        this.keys = in.readTokens();
        this.next = in.readNums();
        this.bucket = in.readNums();
        this.size = in.readNum();
    }

    public void write(DataOutput out) throws IOException {
        out.writeTokens(this.keys);
        out.writeNums(this.next);
        out.writeNums(this.bucket);
        out.writeNum(this.size);
    }

    public final boolean add(byte[] key) {
        return this.index(key) > 0;
    }

    public boolean add(String key) {
        return this.add(Token.token(key));
    }

    public final int put(byte[] key) {
        int i = this.index(key);
        return Math.abs(i);
    }

    public final boolean contains(byte[] key) {
        return this.id(key) > 0;
    }

    public final int id(byte[] key) {
        int p = Token.hash(key) & this.bucket.length - 1;
        int i = this.bucket[p];
        while (i != 0) {
            if (Token.eq(key, this.keys[i])) {
                return i;
            }
            i = this.next[i];
        }
        return 0;
    }

    public final byte[] key(int id) {
        return this.keys[id];
    }

    public int delete(byte[] key) {
        int b = Token.hash(key) & this.bucket.length - 1;
        int p = 0;
        int i = this.bucket[b];
        while (i != 0) {
            if (Token.eq(key, this.keys[i])) {
                if (p == 0) {
                    this.bucket[b] = this.next[i];
                } else {
                    this.next[p] = this.next[this.next[i]];
                }
                this.keys[i] = null;
                return i;
            }
            p = i;
            i = this.next[i];
        }
        return 0;
    }

    private int index(byte[] key) {
        this.checkSize();
        int b = Token.hash(key) & this.bucket.length - 1;
        int r = this.bucket[b];
        while (r != 0) {
            if (Token.eq(key, this.keys[r])) {
                return -r;
            }
            r = this.next[r];
        }
        this.next[this.size] = this.bucket[b];
        this.keys[this.size] = key;
        this.bucket[b] = this.size;
        return this.size++;
    }

    @Override
    protected int hash(int id) {
        return Token.hash(this.keys[id]);
    }

    @Override
    protected void rehash(int newSize) {
        this.keys = Array.copyOf(this.keys, newSize);
    }

    @Override
    public final void clear() {
        Arrays.fill((Object[])this.keys, null);
        super.clear();
    }

    @Override
    public final Iterator<byte[]> iterator() {
        return new ArrayIterator<byte[]>((Object[])this.keys, 1, this.size);
    }

    public String toString() {
        TokenBuilder tb = new TokenBuilder();
        for (byte[] key : this) {
            if (!tb.isEmpty()) {
                tb.add(", ");
            }
            if (key == null) continue;
            tb.add(key);
        }
        return new TokenBuilder(Util.className(this.getClass())).add(91).add(tb.finish()).add(93).toString();
    }
}

