/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.ElementList;

public final class TokenList
extends ElementList
implements Iterable<byte[]> {
    private byte[][] list;

    public TokenList() {
        this(8);
    }

    public TokenList(int capacity) {
        this.list = new byte[capacity][];
    }

    public TokenList(double resize) {
        this();
        this.factor = resize;
    }

    public TokenList(TokenSet set) {
        this(set.size());
        for (byte[] e : set) {
            this.add(e);
        }
    }

    public void add(byte[] element) {
        if (this.size == this.list.length) {
            this.list = Array.copyOf(this.list, this.newSize());
        }
        this.list[this.size++] = element;
    }

    public void add(long element) {
        this.add(Token.token(element));
    }

    public void add(String element) {
        this.add(Token.token(element));
    }

    public void insert(int index, byte[][] elements) {
        int l = elements.length;
        if (l == 0) {
            return;
        }
        if (this.size + l > this.list.length) {
            this.list = Array.copyOf(this.list, this.newSize(this.size + l));
        }
        Array.move(this.list, index, l, this.size - index);
        System.arraycopy(elements, 0, this.list, index, l);
        this.size += l;
    }

    public byte[] deleteAt(int index) {
        byte[] l = this.list[index];
        Array.move(this.list, index + 1, -1, --this.size - index);
        return l;
    }

    public byte[] get(int index) {
        return index < this.list.length ? this.list[index] : null;
    }

    public void set(int index, byte[] element) {
        if (index >= this.list.length) {
            this.list = Array.copyOf(this.list, this.newSize(index + 1));
        }
        this.list[index] = element;
        this.size = Math.max(this.size, index + 1);
    }

    public byte[] pop() {
        return this.list[--this.size];
    }

    public void push(byte[] element) {
        this.add(element);
    }

    public byte[] peek() {
        return this.list[this.size - 1];
    }

    public boolean contains(byte[] element) {
        for (int i = 0; i < this.size; ++i) {
            if (!Token.eq(this.list[i], element)) continue;
            return true;
        }
        return false;
    }

    public byte[][] toArray() {
        return Array.copyOf(this.list, this.size);
    }

    public String[] toStringArray() {
        int is = this.size;
        byte[][] l = this.list;
        String[] items = new String[is];
        for (int i = 0; i < is; ++i) {
            items[i] = Token.string(l[i]);
        }
        return items;
    }

    public TokenList sort(boolean cs) {
        return this.sort(cs, true);
    }

    public TokenList sort(boolean cs, boolean asc) {
        Comparator<byte[]> comp = cs ? Token.COMP : Token.LC_COMP;
        Arrays.sort(this.list, 0, this.size, asc ? comp : Collections.reverseOrder(comp));
        return this;
    }

    public TokenList unique() {
        if (this.size != 0) {
            int s = 0;
            for (int l = 1; l < this.size; ++l) {
                if (Token.eq(this.list[l], this.list[s])) continue;
                this.list[++s] = this.list[l];
            }
            this.size = s + 1;
        }
        return this;
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new ArrayIterator<byte[]>((Object[])this.list, this.size);
    }

    public String toString() {
        TokenBuilder tb = new TokenBuilder(Util.className(this) + '[');
        for (int i = 0; i < this.size; ++i) {
            if (i != 0) {
                tb.add(", ");
            }
            tb.add(this.list[i]);
        }
        return tb.add(93).toString();
    }

    public TokenList copy() {
        TokenList tl = new TokenList(this.list.length);
        tl.factor = this.factor;
        for (int i = 0; i < this.size; ++i) {
            tl.add((byte[])this.list[i].clone());
        }
        return tl;
    }
}

