/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.options;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.basex.core.BaseXException;
import org.basex.core.Text;
import org.basex.io.IOFile;
import org.basex.io.in.NewlineInput;
import org.basex.util.Levenshtein;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.Comment;
import org.basex.util.options.EnumOption;
import org.basex.util.options.NumberOption;
import org.basex.util.options.NumbersOption;
import org.basex.util.options.Option;
import org.basex.util.options.OptionsOption;
import org.basex.util.options.StringOption;
import org.basex.util.options.StringsOption;

public class Options
implements Iterable<Option<?>> {
    private static final String PROPUSER = "# Local Options";
    protected final TreeMap<String, Option<?>> options = new TreeMap();
    private final TreeMap<String, Object> values = new TreeMap();
    private final HashMap<String, String> free = new HashMap();
    private final StringBuilder user = new StringBuilder();
    private IOFile file;

    public Options() {
        this(null);
    }

    protected Options(IOFile opts) {
        this.init();
        if (opts != null) {
            this.read(opts);
        }
    }

    private void init() {
        try {
            for (Option<?> opt : Options.options(this.getClass())) {
                if (opt instanceof Comment) continue;
                String name = opt.name();
                this.values.put(name, opt.value());
                this.options.put(name, opt);
            }
        }
        catch (Exception ex) {
            throw Util.notExpected(ex);
        }
    }

    public final synchronized void write() {
        TokenBuilder tmp = new TokenBuilder();
        try {
            boolean first = true;
            for (Option<?> opt : Options.options(this.getClass())) {
                int i;
                String name = opt.name();
                if (opt instanceof Comment) {
                    if (!first) {
                        tmp.add(Prop.NL);
                    }
                    tmp.add("# " + name).add(Prop.NL);
                } else if (opt instanceof NumbersOption) {
                    int[] ints = this.get((NumbersOption)opt);
                    int is = ints == null ? 0 : ints.length;
                    for (i = 0; i < is; ++i) {
                        tmp.add(name + i + " = " + ints[i]).add(Prop.NL);
                    }
                } else if (opt instanceof StringsOption) {
                    String[] strings = this.get((StringsOption)opt);
                    int ss = strings == null ? 0 : strings.length;
                    tmp.add(name + " = " + ss).add(Prop.NL);
                    for (i = 0; i < ss; ++i) {
                        tmp.add(name + (i + 1) + " = " + strings[i]).add(Prop.NL);
                    }
                } else {
                    tmp.add(name + " = " + this.get(opt)).add(Prop.NL);
                }
                first = false;
            }
            tmp.add(Prop.NL).add(PROPUSER).add(Prop.NL);
            tmp.add(this.user.toString());
            byte[] content = tmp.array();
            if (!this.file.exists() || !Token.eq(content, this.file.read())) {
                this.file.write(content);
            }
        }
        catch (Exception ex) {
            Util.errln("% could not be written.", this.file);
            Util.debug(ex);
        }
    }

    public final synchronized Option<?> option(String name) {
        return this.options.get(name);
    }

    public final synchronized Object get(Option<?> option) {
        return this.values.get(option.name());
    }

    public final synchronized void put(Option<?> option, Object value) {
        this.values.put(option.name(), value);
    }

    public final synchronized boolean contains(Option<?> option) {
        return this.get(option) != null;
    }

    public final synchronized String get(StringOption option) {
        return (String)this.get((Option<?>)option);
    }

    public final synchronized Integer get(NumberOption option) {
        return (Integer)this.get((Option<?>)option);
    }

    public final synchronized Boolean get(BooleanOption option) {
        return (Boolean)this.get((Option<?>)option);
    }

    public final synchronized String[] get(StringsOption option) {
        String[] v = (String[])this.get((Option<?>)option);
        return v == null ? null : (String[])v.clone();
    }

    public final synchronized int[] get(NumbersOption option) {
        int[] v = (int[])this.get((Option<?>)option);
        return v == null ? null : (int[])v.clone();
    }

    public final synchronized <O extends Options> O get(OptionsOption<O> option) {
        Options o = (Options)this.get((Option<?>)option);
        if (o == null) {
            return null;
        }
        try {
            Options n = (Options)o.getClass().newInstance();
            n.parse(o.toString());
            return (O)n;
        }
        catch (Exception ex) {
            throw Util.notExpected(ex);
        }
    }

    public final synchronized <V extends Enum<V>> V get(EnumOption<V> option) {
        return (V)((Enum)this.get((Option<?>)option));
    }

    public final synchronized void set(StringOption option, String value) {
        this.put(option, value);
    }

    public final synchronized void set(NumberOption option, int value) {
        this.put(option, value);
    }

    public final synchronized void set(BooleanOption option, boolean value) {
        this.put(option, value);
    }

    public final synchronized void set(StringsOption option, String[] value) {
        this.put(option, value);
    }

    public final synchronized void set(NumbersOption option, int[] value) {
        this.put(option, value);
    }

    public final synchronized <O extends Options> void set(OptionsOption<O> option, O value) {
        this.put(option, value);
    }

    public final synchronized <V extends Enum<V>> void set(EnumOption<V> option, Enum<V> value) {
        this.put(option, value);
    }

    public final synchronized <V extends Enum<V>> void set(EnumOption<V> option, String value) {
        this.put(option, option.get(value));
    }

    public synchronized void assign(String name, String val) throws BaseXException {
        if (this.options.isEmpty()) {
            this.free.put(name, val);
        } else {
            this.assign(name, val, -1, true);
        }
    }

    public final synchronized HashMap<String, String> free() {
        return this.free;
    }

    public final synchronized String error(String name) {
        String sim = this.similar(name);
        return Util.info(sim != null ? Text.UNKNOWN_OPT_SIMILAR_X_X : Text.UNKNOWN_OPTION_X, name, sim);
    }

    public final synchronized boolean invert(BooleanOption option) {
        boolean val = this.get(option) == false;
        this.set(option, val);
        return val;
    }

    public final void setSystem() {
        StringList sl = new StringList();
        for (Object key : System.getProperties().keySet()) {
            String k = key.toString();
            if (!k.startsWith("org.basex.")) continue;
            sl.add(k);
        }
        for (Object key : sl) {
            String v = System.getProperty((String)key);
            try {
                String k = ((String)key).substring("org.basex.".length()).toUpperCase(Locale.ENGLISH);
                if (!this.assign(k, v, -1, false)) continue;
                Util.debug(k + ": " + v, new Object[0]);
            }
            catch (BaseXException ignore) {}
        }
    }

    @Override
    public final synchronized Iterator<Option<?>> iterator() {
        return this.options.values().iterator();
    }

    public final synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> e : this.values.entrySet()) {
            String name = e.getKey();
            Object value = e.getValue();
            if (value == null) continue;
            StringList sl = new StringList();
            Object value2 = this.options.get(name).value();
            if (value instanceof String[]) {
                for (String s : (String[])value) {
                    sl.add(s);
                }
            } else if (value instanceof int[]) {
                for (int s : (int[])value) {
                    sl.add(Integer.toString(s));
                }
            } else if (value instanceof Options) {
                String string = value.toString();
                if (value2 == null || !string.equals(value2.toString())) {
                    sl.add(string);
                }
            } else if (!value.equals(value2)) {
                sl.add(value.toString());
            }
            for (String s : sl) {
                if (sb.length() != 0) {
                    sb.append(',');
                }
                sb.append(name).append('=').append(s.replace(",", ",,"));
            }
        }
        return sb.toString();
    }

    public static String getSystem(Option<?> option) {
        String v;
        String name = option.name().toLowerCase(Locale.ENGLISH);
        if (!name.startsWith("org.basex.")) {
            name = "org.basex." + name;
        }
        return (v = System.getProperty(name)) == null ? "" : v;
    }

    public static void setSystem(Option<?> option, Object val) {
        Options.setSystem(option.name(), val);
    }

    public static void setSystem(String key, Object val) {
        String name;
        String string = name = key.indexOf(46) == -1 ? "org.basex." + key.toLowerCase(Locale.ENGLISH) : key;
        if (System.getProperty(name) == null) {
            System.setProperty(name, val.toString());
        }
    }

    public static Option<?>[] options(Class<? extends Options> clz) throws IllegalAccessException {
        ArrayList<Option> opts = new ArrayList<Option>();
        for (Field f : clz.getFields()) {
            Object obj;
            if (!Modifier.isStatic(f.getModifiers()) || !((obj = f.get(null)) instanceof Option)) continue;
            opts.add((Option)obj);
        }
        return opts.toArray(new Option[opts.size()]);
    }

    public static String allowed(Option<?> option, Object ... all) {
        TokenBuilder vals = new TokenBuilder();
        for (Object a : all) {
            vals.add(vals.isEmpty() ? "" : ",").add(a.toString());
        }
        return Util.info("Value of '%' must be one of (%).", option.name(), vals);
    }

    public synchronized void parse(String string) throws BaseXException {
        int sl = string.length();
        int i = 0;
        while (i < sl) {
            char ch;
            int k = string.indexOf(61, i);
            if (k == -1) {
                k = sl;
            }
            String key = string.substring(i, k).trim();
            StringBuilder val = new StringBuilder();
            i = k;
            while (++i < sl && ((ch = string.charAt(i)) != ',' || ++i != sl && string.charAt(i) == ',')) {
                val.append(ch);
            }
            this.assign(key, val.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void read(IOFile opts) {
        this.file = opts;
        StringList read = new StringList();
        StringList errs = new StringList();
        boolean exists = this.file.exists();
        if (exists) {
            NewlineInput nli = null;
            try {
                String line;
                nli = new NewlineInput(opts);
                boolean local = false;
                while ((line = nli.readLine()) != null) {
                    if ((line = line.trim()).equals(PROPUSER)) {
                        local = true;
                        continue;
                    }
                    if (local) {
                        this.user.append(line).append(Prop.NL);
                    }
                    if (line.isEmpty() || line.charAt(0) == '#') continue;
                    int d = line.indexOf(61);
                    if (d < 0) {
                        errs.add("line \"" + line + "\" ignored.");
                        continue;
                    }
                    String val = line.substring(d + 1).trim();
                    String name = line.substring(0, d).trim();
                    int num = 0;
                    int ss = name.length();
                    for (int s = 0; s < ss; ++s) {
                        if (!Character.isDigit(name.charAt(s))) continue;
                        num = Token.toInt(name.substring(s));
                        name = name.substring(0, s);
                        break;
                    }
                    if (local) {
                        Options.setSystem(name, (Object)val);
                        continue;
                    }
                    try {
                        this.assign(name, val, num, true);
                        read.add(name);
                    }
                    catch (BaseXException ex) {
                        errs.add(ex.getMessage());
                    }
                }
            }
            catch (IOException ex) {
                errs.add("file could not be parsed.");
                Util.errln(ex, new Object[0]);
            }
            finally {
                if (nli != null) {
                    try {
                        nli.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
        boolean ok = true;
        if (errs.isEmpty()) {
            try {
                for (Option<?> opt : Options.options(this.getClass())) {
                    if (!ok || opt instanceof Comment) continue;
                    ok = read.contains(opt.name());
                }
            }
            catch (IllegalAccessException ex) {
                throw Util.notExpected(ex);
            }
        }
        if (!(ok && exists && errs.isEmpty())) {
            this.write();
            errs.add("writing new configuration file.");
            for (String s : errs) {
                Util.errln(this.file + ": " + s, new Object[0]);
            }
        }
    }

    private synchronized boolean assign(String name, String val, int num, boolean error) throws BaseXException {
        Option<?> option = this.options.get(name);
        if (option == null) {
            if (error) {
                throw new BaseXException(this.error(name), new Object[0]);
            }
            return false;
        }
        if (option instanceof BooleanOption) {
            boolean v;
            if (val == null || val.isEmpty()) {
                Boolean b = this.get((BooleanOption)option);
                if (b == null) {
                    throw new BaseXException("Value of '%' must be a boolean.", option.name());
                }
                v = b == false;
            } else {
                v = Util.yes(val);
                if (!v && !Util.no(val)) {
                    throw new BaseXException("Value of '%' must be a boolean.", option.name());
                }
            }
            this.put(option, v);
        } else if (option instanceof NumberOption) {
            int v = Token.toInt(val);
            if (v == Integer.MIN_VALUE) {
                throw new BaseXException("Value of '%' must be a number.", option.name());
            }
            this.put(option, v);
        } else if (option instanceof StringOption) {
            this.put(option, val);
        } else if (option instanceof EnumOption) {
            EnumOption eo = (EnumOption)option;
            Object v = eo.get(val);
            if (v == null) {
                throw new BaseXException(Options.allowed(option, eo.values()), new Object[0]);
            }
            this.put(option, v);
        } else if (option instanceof OptionsOption) {
            Object o = ((OptionsOption)option).newInstance();
            ((Options)o).parse(val);
            this.put(option, o);
        } else if (option instanceof NumbersOption) {
            int v = Token.toInt(val);
            if (v == Integer.MIN_VALUE) {
                throw new BaseXException("Value of '%' must be a number.", option.name());
            }
            int[] ii = (int[])this.get(option);
            if (num == -1) {
                if (ii == null) {
                    ii = new int[]{};
                }
                IntList il = new IntList(ii.length + 1);
                for (int i : ii) {
                    il.add(i);
                }
                il.add(v);
                this.put(option, il.toArray());
            } else {
                if (num < 0 || num >= ii.length) {
                    throw new BaseXException("List counter for '%' is invalid.", option.name());
                }
                ii[num] = v;
            }
        } else if (option instanceof StringsOption) {
            String[] ss = (String[])this.get(option);
            if (num == -1) {
                if (ss == null) {
                    ss = new String[]{};
                }
                StringList sl = new StringList(ss.length + 1);
                for (String s : ss) {
                    sl.add(s);
                }
                sl.add(val);
                this.put(option, sl.toArray());
            } else if (num == 0) {
                int v = Token.toInt(val);
                if (v == Integer.MIN_VALUE) {
                    throw new BaseXException("Value of '%' must be a number.", option.name());
                }
                this.values.put(name, new String[v]);
            } else {
                if (num <= 0 || num > ss.length) {
                    throw new BaseXException("List counter for '%' is invalid.", option.name());
                }
                ss[num - 1] = val;
            }
        }
        return true;
    }

    private String similar(String name) {
        byte[] nm = Token.token(name);
        Levenshtein ls = new Levenshtein();
        for (String opts : this.options.keySet()) {
            if (!ls.similar(nm, Token.token(opts))) continue;
            return opts;
        }
        return null;
    }
}

