/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.basex.core.MainOptions;
import org.basex.http.HTTPContext;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.in.BufferInput;
import org.basex.query.QueryException;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.util.http.HTTPPayload;
import org.basex.query.value.Value;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;

public final class HTTPParams {
    private final HTTPContext http;
    private Map<String, String[]> map;
    private Map<String, Value> query;
    private Map<String, Value> form;
    private IOContent content;

    public HTTPParams(HTTPContext http) {
        this.http = http;
    }

    public Map<String, String[]> map() throws IOException {
        try {
            if (this.map == null) {
                this.map = this.http.req.getParameterMap();
            }
            return this.map;
        }
        catch (IllegalStateException ex) {
            throw new IOException(ex);
        }
    }

    public Value content() throws QueryException, IOException {
        return HTTPPayload.value((IO)this.body(), (MainOptions)this.http.context().options, (String)this.http.contentType(), (String)this.http.contentTypeExt());
    }

    public Map<String, Value> form() throws QueryException, IOException {
        if (this.form == null) {
            this.form = new HashMap<String, Value>();
            String ct = this.http.contentType();
            if ("multipart/form-data".equals(ct)) {
                this.addMultipart(this.form, this.http.contentTypeExt());
            } else if ("application/x-www-form-urlencoded".equals(ct)) {
                this.addURLEncoded(this.form);
            }
        }
        return this.form;
    }

    public Map<String, Value> query() throws IOException {
        if (this.query == null) {
            this.query = new HashMap<String, Value>();
            for (Map.Entry<String, String[]> entry : this.map().entrySet()) {
                String key = entry.getKey();
                String[] values = entry.getValue();
                ValueBuilder vb = new ValueBuilder(values.length);
                for (String v : values) {
                    vb.add((Item)new Atm(v));
                }
                this.query.put(key, vb.value());
            }
        }
        return this.query;
    }

    private void addMultipart(Map<String, Value> params, String ext) throws QueryException, IOException {
        MainOptions opts = this.http.context().options;
        HTTPPayload hp = new HTTPPayload((InputStream)this.body().inputStream(), true, null, opts);
        HashMap mp = hp.multiForm(ext);
        for (Map.Entry entry : mp.entrySet()) {
            params.put((String)entry.getKey(), (Value)entry.getValue());
        }
    }

    private void addURLEncoded(Map<String, Value> params) throws IOException {
        for (String nv : this.body().toString().split("&")) {
            String[] parts = nv.split("=", 2);
            if (parts.length != 2) continue;
            params.put(parts[0], (Value)Str.get((String)URLDecoder.decode(parts[1], "UTF-8")));
        }
    }

    private IOContent body() throws IOException {
        if (this.content == null) {
            this.content = new IOContent(new BufferInput((InputStream)this.http.req.getInputStream()).content());
            this.content.name(this.http.method + ".xml");
        }
        return this.content;
    }
}

