/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import java.io.IOException;
import java.util.Map;
import org.basex.core.Command;
import org.basex.core.GlobalOptions;
import org.basex.core.Text;
import org.basex.core.cmd.XQuery;
import org.basex.core.parse.CommandParser;
import org.basex.http.HTTPCode;
import org.basex.http.rest.RESTQuery;
import org.basex.http.rest.RESTSession;
import org.basex.io.IOFile;
import org.basex.query.QueryException;
import org.basex.util.Util;

public final class RESTRun
extends RESTQuery {
    private final String path;

    private RESTRun(RESTSession rs, Map<String, String[]> vars, String val, String pth) {
        super(rs, vars, val);
        this.path = pth;
    }

    @Override
    protected void run0() throws IOException {
        this.query(this.path);
    }

    static RESTQuery get(RESTSession rs, String path, Map<String, String[]> vars, String val) throws IOException {
        IOFile root = new IOFile(rs.context.globalopts.get(GlobalOptions.WEBPATH));
        IOFile file = new IOFile(root, path);
        if (!file.exists() || file.isDir() || !file.path().startsWith(root.path())) {
            throw HTTPCode.NOT_FOUND_X.get(Util.info((Object)Text.RES_NOT_FOUND_X, (Object[])new Object[]{path}));
        }
        String input = file.string();
        if (file.hasSuffix(new String[]{".bxs"})) {
            try {
                for (Command cmd : new CommandParser(input, rs.context).parse()) {
                    rs.add(cmd);
                }
            }
            catch (QueryException ex) {
                throw new IOException(ex);
            }
        } else {
            rs.add((Command)new XQuery(input));
        }
        return new RESTRun(rs, vars, val, file.path());
    }
}

