/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import java.io.IOException;
import org.basex.core.BaseXException;
import org.basex.core.cmd.Open;
import org.basex.http.BaseXServlet;
import org.basex.http.HTTPCode;
import org.basex.http.HTTPContext;
import org.basex.http.HTTPMethod;
import org.basex.http.rest.RESTCmd;
import org.basex.http.rest.RESTDelete;
import org.basex.http.rest.RESTGet;
import org.basex.http.rest.RESTPost;
import org.basex.http.rest.RESTPut;
import org.basex.http.rest.RESTSession;

public final class RESTServlet
extends BaseXServlet {
    @Override
    protected void run(HTTPContext http) throws IOException {
        RESTSession rs = new RESTSession(http, http.authenticate());
        RESTCmd cmd = RESTServlet.code(rs);
        try {
            cmd.execute(rs.context);
        }
        catch (BaseXException ex) {
            String msg = Open.dbnf((String)http.db());
            if (ex.getMessage().equals(msg)) {
                throw HTTPCode.NOT_FOUND_X.get(msg);
            }
            throw ex;
        }
        HTTPCode code = cmd.code;
        if (code != null) {
            throw code.get(cmd.info());
        }
    }

    private static RESTCmd code(RESTSession rs) throws IOException {
        String mth = rs.http.method;
        if (mth.equals(HTTPMethod.GET.name())) {
            return RESTGet.get(rs);
        }
        if (mth.equals(HTTPMethod.POST.name())) {
            return RESTPost.get(rs);
        }
        if (mth.equals(HTTPMethod.PUT.name())) {
            return RESTPut.get(rs);
        }
        if (mth.equals(HTTPMethod.DELETE.name())) {
            return RESTDelete.get(rs);
        }
        throw HTTPCode.NOT_IMPLEMENTED_X.get(rs.http.req.getMethod());
    }
}

