/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.AuthenticationService;
import com.bradmcevoy.http.ExistingEntityHandler;
import com.bradmcevoy.http.FileItem;
import com.bradmcevoy.http.HandlerHelper;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.RequestParseException;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.ResourceHandler;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.UrlAdapter;
import com.bradmcevoy.http.UrlAdapterImpl;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.exceptions.NotFoundException;
import com.bradmcevoy.http.http11.Http11ResponseHandler;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceHandlerHelper {
    private static final Logger log = LoggerFactory.getLogger(ResourceHandlerHelper.class);
    public static final String ATT_NAME_PARAMS = "_params";
    public static final String ATT_NAME_FILES = "_files";
    private final HandlerHelper handlerHelper;
    private final Http11ResponseHandler responseHandler;
    private UrlAdapter urlAdapter = new UrlAdapterImpl();

    public ResourceHandlerHelper(HandlerHelper handlerHelper, Http11ResponseHandler responseHandler) {
        if (responseHandler == null) {
            throw new IllegalArgumentException("responseHandler may not be null");
        }
        if (handlerHelper == null) {
            throw new IllegalArgumentException("handlerHelper may not be null");
        }
        this.handlerHelper = handlerHelper;
        this.responseHandler = responseHandler;
    }

    public void process(HttpManager manager, Request request, Response response, ResourceHandler handler) throws NotAuthorizedException, ConflictException, BadRequestException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        HashMap<String, FileItem> files = new HashMap<String, FileItem>();
        try {
            request.parseRequestParameters(params, files);
        }
        catch (RequestParseException ex) {
            log.warn("exception parsing request. probably interrupted upload", (Throwable)ex);
            return;
        }
        request.getAttributes().put(ATT_NAME_PARAMS, params);
        request.getAttributes().put(ATT_NAME_FILES, files);
        if (!this.handlerHelper.checkExpects(this.responseHandler, request, response)) {
            return;
        }
        String host = request.getHostHeader();
        String url = this.urlAdapter.getUrl(request);
        Resource r = manager.getResourceFactory().getResource(host, url);
        if (r == null) {
            this.responseHandler.respondNotFound(response, request);
            return;
        }
        handler.processResource(manager, request, response, r);
    }

    public void processResource(HttpManager manager, Request request, Response response, Resource resource, ExistingEntityHandler handler) throws NotAuthorizedException, ConflictException, BadRequestException {
        this.processResource(manager, request, response, resource, handler, false, null, null);
    }

    public void processResource(HttpManager manager, Request request, Response response, Resource resource, ExistingEntityHandler handler, Map<String, String> params, Map<String, FileItem> files) throws NotAuthorizedException, ConflictException, BadRequestException {
        this.processResource(manager, request, response, resource, handler, false, params, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResource(HttpManager manager, Request request, Response response, Resource resource, ExistingEntityHandler handler, boolean allowRedirect, Map<String, String> params, Map<String, FileItem> files) throws NotAuthorizedException, ConflictException, BadRequestException {
        log.trace("processResource");
        long t = System.currentTimeMillis();
        try {
            manager.onProcessResourceStart(request, response, resource);
            if (this.handlerHelper.isNotCompatible(resource, request.getMethod()) || !handler.isCompatible(resource)) {
                if (log.isInfoEnabled()) {
                    log.info("resource not compatible. Resource class: " + resource.getClass() + " handler: " + handler.getClass());
                }
                this.responseHandler.respondMethodNotImplemented(resource, response, request);
                return;
            }
            boolean authorised = this.handlerHelper.checkAuthorisation(manager, resource, request);
            if (allowRedirect) {
                log.trace("check redirect");
                if (this.handlerHelper.doCheckRedirect(this.responseHandler, request, response, resource)) {
                    return;
                }
            }
            if (!authorised) {
                if (log.isInfoEnabled()) {
                    log.info("authorisation failed. respond with: " + this.responseHandler.getClass().getCanonicalName() + " resource: " + resource.getClass().getCanonicalName());
                }
                this.responseHandler.respondUnauthorised(resource, response, request);
                return;
            }
            if (request.getMethod().isWrite && request.getMethod() != Request.Method.POST && this.handlerHelper.isLockedOut(request, resource)) {
                response.setStatus(Response.Status.SC_LOCKED);
                return;
            }
            try {
                handler.processExistingResource(manager, request, response, resource);
            }
            catch (NotFoundException ex) {
                log.warn("Not found exception thrown from handler: " + handler.getClass(), (Throwable)ex);
                this.responseHandler.respondNotFound(response, request);
            }
        }
        finally {
            t = System.currentTimeMillis() - t;
            manager.onProcessResourceFinish(request, response, resource, t);
        }
    }

    public boolean isNotCompatible(Resource r, Request.Method m) {
        return this.handlerHelper.isNotCompatible(r, m);
    }

    public boolean isLockedOut(Request inRequest, Resource inResource) {
        return this.handlerHelper.isLockedOut(inRequest, inResource);
    }

    public AuthenticationService.AuthStatus checkAuthentication(HttpManager manager, Resource resource, Request request) {
        return this.handlerHelper.checkAuthentication(manager, resource, request);
    }

    public UrlAdapter getUrlAdapter() {
        return this.urlAdapter;
    }

    public void setUrlAdapter(UrlAdapter urlAdapter) {
        this.urlAdapter = urlAdapter;
    }
}

