/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.http11;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.http11.CacheControlHelper;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCacheControlHelper
implements CacheControlHelper {
    private static final Logger log = LoggerFactory.getLogger(DefaultCacheControlHelper.class);
    private boolean usePrivateCache = false;

    @Override
    public void setCacheControl(GetableResource resource, Response response, Auth auth) {
        Long delta = resource.getMaxAgeSeconds(auth);
        if (log.isTraceEnabled()) {
            log.trace("setCacheControl: " + delta + " - " + resource.getClass());
        }
        if (delta != null && delta > 0L) {
            if (this.usePrivateCache && auth != null) {
                response.setCacheControlPrivateMaxAgeHeader(delta);
            } else {
                response.setCacheControlMaxAgeHeader(delta);
            }
        } else {
            response.setCacheControlNoCacheHeader();
        }
    }

    public static Date calcExpiresAt(Date modifiedDate, long deltaSeconds) {
        long deltaMs = deltaSeconds * 1000L;
        long expiresAt = System.currentTimeMillis() + deltaMs;
        return new Date(expiresAt);
    }
}

