/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.http11.auth;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.AuthenticationHandler;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.SecurityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityManagerBasicAuthHandler
implements AuthenticationHandler {
    private static final Logger log = LoggerFactory.getLogger(SecurityManagerBasicAuthHandler.class);
    private final SecurityManager securityManager;

    public SecurityManagerBasicAuthHandler(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    @Override
    public boolean supports(Resource r, Request request) {
        Auth auth = request.getAuthorization();
        if (auth == null) {
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace("supports basic? requested scheme: " + (Object)((Object)auth.getScheme()));
        }
        return auth.getScheme().equals((Object)Auth.Scheme.BASIC);
    }

    @Override
    public Object authenticate(Resource resource, Request request) {
        log.debug("authenticate");
        Auth auth = request.getAuthorization();
        Object o = this.securityManager.authenticate(auth.getUser(), auth.getPassword());
        log.debug("result: " + o);
        return o;
    }

    @Override
    public String getChallenge(Resource resource, Request request) {
        String realm = this.securityManager.getRealm(request.getHostHeader());
        return "Basic realm=\"" + realm + "\"";
    }

    @Override
    public boolean isCompatible(Resource resource) {
        return true;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }
}

