/*
 * Decompiled with CFR 0.152.
 */
package rb.httpd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import rb.httpd.HttpClass;
import rb.httpd.RequestArguments;
import rb.httpd.RequestHeader;
import rb.httpd.RequestProcessorClass;
import rb.httpd.address.ABAddress;
import rb.httpd.address.ABAddressBook;
import rb.httpd.address.ABPage;
import rb.httpd.address.ABPerson;
import rb.util.StringUtil;
import rb.util.SystemRB;
import rb.util.VectorRB;
import sun.misc.Compare;
import sun.misc.Sort;

public class AddressBook
extends RequestProcessorClass {
    long argPageID;
    long argMasterID;
    long argAddressID;
    long argPersonID;
    long argOptions = 0L;
    ABPage argPage;
    ABAddress argMaster;
    ABAddress argAddress;
    ABPerson argPerson;
    ABAddressBook book;
    boolean showLicense = false;
    static Hashtable books = new Hashtable();
    static final String Title = "WWW Address Book 1.0 - Rolf Breuning";
    static String TitleBar = SystemRB.getPropertyString("rb.httpd.titlebar", "WWW Address Book 1.0 - Rolf Breuning");
    static final int BCreate = 1;
    static final int BChange = 2;
    static final int BRemove = 4;
    static final int BRemoveConfirm = 8;
    static final int BCancel = 128;
    static final int Master = 256;
    static final int NoForm = 32768;
    static final long AdrShowParent = 2L;
    static final long AdrBorder = 4L;
    static final long AdrEditIcons = 1024L;
    static final long AdrEmailIcon = 4096L;
    static final long AdrURLIcon = 16384L;
    static final long AdrPhoneFax = 65536L;
    static final long AdrAddressNote = 262144L;
    static final long AdrNoMessage = 0x100000L;
    static final long AdrDefault = 17412L;
    static final long AdrPrint = 17412L;
    static final int BForm = 30;
    static final String BSrv = "";
    static final String InheritKey = "Inh";
    static final int InheritPrefix = 1;
    static final int InheritPostfix = 2;
    static final String PageEdit = "showPageEditor";
    static final String MasterEdit = "showMasterAddressEditor";
    static final String PersonNew = "showPersonNew";
    static final String PersonEdit = "showPerson";
    static final String ShowPage = "showPage";
    static final String SetPage = "setPage";
    static final String SetMaster = "setMasterAddress";
    static final String SetPersonAndAddress = "setPersonAndAddress";
    static final String DropBooks = "dropBooks";

    void addressEditorPrim(ABAddress aBAddress, int n) {
        if (aBAddress == null) {
            aBAddress = new ABAddress();
        }
        ABAddress aBAddress2 = this.argMaster;
        boolean bl = (n & 0x100) != 0;
        boolean bl2 = !bl;
        this.sendHiddenFields();
        this.print.print("<table border=0 cellpadding=2 cellspacing=0> <tbody>\n");
        if (bl2 && aBAddress2 != null) {
            this.print.print("<tr valign=top><td><b>Address:</b></td>  <td></td>  <td><b>Inherits as:</b></td>  <td><b>from: </b>\n  ");
            this.print.print("  " + AddressBook.shortHttp(aBAddress2) + "</td>");
        }
        if (bl) {
            this.print.print("  <tr><td>Name:</td>");
            this.print.print("  <td><input type=text name=name value=\"" + HttpClass.toHttp(aBAddress.getName()) + "\"></td>\n");
        }
        this.addressEditorPrimLine("Phone number:", "tel", aBAddress.getPhone(), bl ? null : aBAddress2.getPhone(), 1);
        this.addressEditorPrimLine("Fax number:", "fax", aBAddress.getFax(), bl ? null : aBAddress2.getFax(), 1);
        this.addressEditorPrimLine("Email:", "email", aBAddress.getEmail(), bl ? null : aBAddress2.getEmail(), 2);
        this.addressEditorPrimLine("URL:", "url", aBAddress.getURL(), bl ? null : aBAddress2.getURL(), 1);
        this.addressEditorPrimLine("Country:", "country", aBAddress.getCountry(), bl ? null : aBAddress2.getCountry(), 1);
        this.addressEditorPrimLine("State:", "state", aBAddress.getState(), bl ? null : aBAddress2.getState(), 1);
        this.addressEditorPrimLine("City:", "city", aBAddress.getCity(), bl ? null : aBAddress2.getCity(), 1);
        this.addressEditorPrimLine("Zip:", "zip", aBAddress.getZip(), bl ? null : aBAddress2.getZip(), 1);
        this.addressEditorPrimLine("Street:", "street", aBAddress.getStreet(), bl ? null : aBAddress2.getStreet(), 1);
        this.addressEditorPrimLine("House:", "house", aBAddress.getHouse(), bl ? null : aBAddress2.getHouse(), 1);
        this.print.print("  <tr valign=top><td>Note:</td>");
        this.print.print("  <td><textarea rows=3 name=note>" + HttpClass.toHttp(aBAddress.getNote()) + "</textarea></td>\n");
        if (bl2) {
            this.print.print("<td></td>  <td>" + HttpClass.toHttp(aBAddress2.getNote(), "-") + "</td>");
        }
        this.print.print("</tbody> </table>");
        this.sendButtons(n);
    }

    void addressEditorPrimLine(String string, String string2, String string3, String string4, int n) {
        boolean bl;
        boolean bl2 = bl = string3.indexOf("\u0001") >= 0;
        if (bl) {
            string3 = StringUtil.replace(string3, "\u0001", BSrv);
        }
        this.print.print("<tr><td>" + string + "</td>\n");
        this.print.print("  <td><input type=text name=" + string2 + " value=\"" + HttpClass.toHttp(string3) + "\"></td>\n");
        if (string4 == null) {
            return;
        }
        this.print.print("  <td><input type=checkbox name=" + string2 + InheritKey);
        if (bl) {
            this.print.print(" checked>");
        } else {
            this.print.print(">");
        }
        this.print.print(n == 1 ? "prefix:" : "postfix:");
        this.print.print("</td>\n  <td>");
        this.print.print(HttpClass.toHttp(string4, "-"));
        this.print.print("</td>\n");
    }

    String addressPrim(String string, String string2) {
        return HttpClass.toHttp(StringUtil.replace(string.trim(), "\u0001", BSrv), string2);
    }

    void addressPrim(ABAddress aBAddress, ABPage aBPage, long l) {
        String string;
        String string2;
        ABPerson aBPerson = aBAddress.getPerson();
        this.print.print("<tr valign=top>  <td>");
        if (!aBAddress.isLeaf()) {
            if ((l & 0x400L) > 0L) {
                this.sendLink(this.tagImg("ABMaster.gif", "left"), "?cmd=showMasterAddressEditor&pageID=" + aBPage.getID() + "&masterID=" + aBAddress.getID(), BSrv, "edit/remove parent address");
                this.sendLink(this.tagImg("ABPersonNew.gif", "left"), "?cmd=showPersonNew&pageID=" + aBPage.getID() + "&masterID=" + aBAddress.getID(), BSrv, "register new address");
            }
            this.print.print(AddressBook.shortHttp(aBAddress));
        } else {
            if ((l & 0x400L) > 0L) {
                this.sendLink(this.tagImg("ABPerson.gif", "left"), "?cmd=showPerson&pageID=" + aBPage.getID() + "&masterID=" + aBAddress.getParent().getID() + "&addressID=" + aBAddress.getID() + "&personID=" + aBPerson.getID(), BSrv, "edit/remove address");
            }
            if ((l & 2L) == 0L) {
                this.print.print(AddressBook.shortHttp(aBPerson));
                if (aBPerson.getAddressCount() > 1) {
                    this.print.print("[" + aBPerson.getAddressCount() + "]");
                }
            }
        }
        this.print.print("</td><td>" + this.addressPrim(aBAddress.getPhone(), RequestProcessorClass.blank));
        if ((l & 0x10000L) > 0L) {
            this.print.print("; ");
        } else {
            this.print.print("</td><td>");
        }
        this.print.print(String.valueOf(this.addressPrim(aBAddress.getFax(), RequestProcessorClass.blank)) + "</td><td>");
        boolean bl = true;
        if (this.addressPrim(aBAddress.getURL(), BSrv).length() > 0) {
            string2 = aBAddress.getFullURL();
            if ((l & 0x4000L) == 0L) {
                this.sendLink(this.addressPrim(aBAddress.getURL(), BSrv), HttpClass.toURL(string2), BSrv, BSrv);
            } else {
                this.sendLink(this.tagImg("ABURL.gif", "left"), HttpClass.toURL(string2), BSrv, "Go to " + HttpClass.toHttp(string2));
            }
            bl = false;
            this.print.print(" ");
        }
        if ((string2 = aBAddress.getFullEmail()).length() > 0) {
            string = this.addressPrim(aBAddress.getEmail(), BSrv);
            if (string2.indexOf(",") < 0 && string2.indexOf("<") < 0 && aBPerson != null) {
                string2 = String.valueOf(aBPerson.getFirstName()) + " " + aBPerson.getName() + " <" + string2 + ">";
            }
            string2 = "mailto:" + HttpClass.toHttp(string2);
            if (string.length() == 0) {
                this.sendLink("-", string2, BSrv, BSrv);
            } else if ((l & 0x1000L) == 0L) {
                this.sendLink(string, string2, BSrv, BSrv);
            } else {
                this.sendLink(this.tagImg("ABEmail.gif", BSrv), string2, BSrv, BSrv);
            }
            bl = false;
        }
        if (bl) {
            this.print.print(RequestProcessorClass.blank);
        }
        this.print.print("</td><td>");
        string = aBAddress.getAddressString().trim();
        String string3 = aBAddress.getNote().trim();
        this.print.print(this.addressPrim(string, RequestProcessorClass.blank));
        if ((l & 0x40000L) == 0L) {
            this.print.print("</td><td>");
        } else if (string3.length() > 0 && string.length() > 0) {
            this.print.print("/<br>");
        }
        this.print.print(this.addressPrim(string3, RequestProcessorClass.blank));
        if ((l & 2L) > 0L) {
            this.print.print("</td><td>" + AddressBook.shortHttp(aBAddress.getParent()));
        }
        this.print.print("</td></tr>\n");
    }

    boolean check() {
        try {
            int n = 30;
            SystemRB.setProperty("rb.httpd.address.free", BSrv + n);
            if (this.book.getAddressCount() < n) {
                return true;
            }
            String string = SystemRB.getPropertyString("rb.httpd.AddressBook.license", "address.lic");
            File file = new File(RequestProcessorClass.DefaultDirectory, string);
            BufferedReader bufferedReader = null;
            int n2 = 0;
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                n2 = Integer.parseInt(bufferedReader.readLine().trim());
                String string2 = this.header.getLocalAddress().trim();
                String string3 = SystemRB.getDigest("check" + n2 + string2).trim();
                while (!bufferedReader.readLine().trim().equals(string3)) {
                }
            }
            catch (Throwable throwable) {
                n2 = 0;
            }
            try {
                bufferedReader.close();
            }
            catch (Throwable throwable) {}
            return this.book.getAddressCount() < n2;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public void dropBooks() {
        books = new Hashtable();
        this.print.print("<h2><center>WWW Address Book</center></h2>");
        this.print.print("Books dropped. Further actions will reload books.");
    }

    String getArg(String string) {
        String string2 = this.arguments.get(string);
        if (string2 == null) {
            string2 = BSrv;
        }
        return string2;
    }

    String getArg(String string, int n) {
        String string2 = this.arguments.get(string);
        if (string2 == null) {
            string2 = BSrv;
        }
        if (!this.arguments.containsKey(String.valueOf(string) + InheritKey)) {
            return string2;
        }
        if (n == 2) {
            return String.valueOf(string2) + "\u0001";
        }
        if (n == 1) {
            return "\u0001" + string2;
        }
        return string2;
    }

    String getFullUrl(long l) {
        long l2;
        String string = this.header.getURLClassName();
        if (this.book.getName().length() > 0) {
            string = String.valueOf(string) + "/bookName=" + HttpClass.toURL(this.book.getName());
        }
        if ((l2 = this.argOptions | l) == this.argOptions) {
            l2 -= l;
        }
        if (l2 != 17412L) {
            string = String.valueOf(string) + "/options=" + (l2 - 17412L);
        }
        string = this.showLicense ? String.valueOf(string) + "/?cmd=showMaximum" : String.valueOf(string) + "/?cmd=showPage&pageID=" + this.argPageID;
        return string;
    }

    public void importCSV() {
        Vector vector;
        String string = this.arguments.get("fileName");
        ABAddress aBAddress = (ABAddress)this.book.getEntry(this.argMasterID);
        File file = new File(RequestProcessorClass.DefaultDirectory, string);
        BufferedReader bufferedReader = null;
        Vector vector2 = null;
        Vector<Vector> vector3 = new Vector<Vector>();
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                vector = this.importCSVLine(string2);
                if (vector.indexOf("NAME_") >= 0) {
                    vector2 = vector;
                    continue;
                }
                vector3.addElement(vector);
            }
        }
        catch (IOException iOException) {}
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {}
        int n = 0;
        while (n < vector3.size()) {
            vector = (Vector)vector3.elementAt(n);
            ABPerson aBPerson = this.book.setPerson(new ABPerson(), this.importCSVGet(vector2, vector, "NAME_"), this.importCSVGet(vector2, vector, "FIRSTNAME_"), this.importCSVGet(vector2, vector, "TITLE_"), BSrv);
            int n2 = 0;
            while (n2 <= 9) {
                String string3 = this.importCSVGet(vector2, vector, "NOTE_" + n2);
                String string4 = this.importCSVGet(vector2, vector, "EMAIL_" + n2);
                String string5 = this.importCSVGet(vector2, vector, "FAX_" + n2);
                String string6 = this.importCSVGet(vector2, vector, "PHONE_" + n2);
                String string7 = this.importCSVGet(vector2, vector, "URL_" + n2);
                String string8 = this.importCSVGet(vector2, vector, "COUNTRY_" + n2);
                String string9 = this.importCSVGet(vector2, vector, "STATE_" + n2);
                String string10 = this.importCSVGet(vector2, vector, "CITY_" + n2);
                String string11 = this.importCSVGet(vector2, vector, "ZIP_" + n2);
                String string12 = this.importCSVGet(vector2, vector, "STREET_" + n2);
                String string13 = this.importCSVGet(vector2, vector, "BUILDING_" + n2);
                if (!BSrv.equals(String.valueOf(string3) + string4 + string5 + string6 + string7 + string8 + string9 + string10 + string12 + string13)) {
                    this.book.setAddress(new ABAddress(), aBAddress, aBPerson, BSrv, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13);
                }
                ++n2;
            }
            ++n;
        }
    }

    String importCSVGet(Vector vector, Vector vector2, String string) {
        int n = vector.indexOf(string);
        if (n < 0) {
            return BSrv;
        }
        if (vector2.size() <= n) {
            return BSrv;
        }
        return (String)vector2.elementAt(n);
    }

    Vector importCSVLine(String string) {
        Vector<String> vector = new Vector<String>();
        try {
            int n = -1;
            while (true) {
                if (string.charAt(++n) == ' ') {
                    continue;
                }
                int n2 = n;
                if (string.charAt(n2) == '\"') {
                    n = string.indexOf(34, n2 + 1);
                    vector.addElement(string.substring(n2 + 1, n));
                    n = string.indexOf(44, n);
                } else {
                    n = string.indexOf(44, n2);
                    vector.addElement(string.substring(n2, n));
                }
                if (n < 0) break;
            }
        }
        catch (Exception exception) {}
        return vector;
    }

    void initArgs() {
        String string = this.getArg("bookName");
        this.book = (ABAddressBook)books.get(string);
        if (this.book == null) {
            String string2 = SystemRB.getPropertyString("rb.httpd.AddressBook.file", "address.adr");
            if (!string.equals(BSrv)) {
                string2 = String.valueOf(string) + ".adr";
            }
            File file = new File(RequestProcessorClass.DefaultDirectory, string2);
            this.book = new ABAddressBook(file, string);
            books.put(string, this.book);
            this.check();
        }
        try {
            this.argOptions = 17412L;
            this.argOptions += (long)Integer.parseInt(this.getArg("options"));
        }
        catch (Exception exception) {}
        try {
            this.argPageID = -1L;
            this.argPage = null;
            this.argPageID = Long.parseLong(this.getArg("pageID"));
            this.argPage = (ABPage)this.book.getEntry(this.argPageID);
        }
        catch (Exception exception) {}
        try {
            this.argMasterID = -1L;
            this.argMaster = null;
            this.argMasterID = Long.parseLong(this.getArg("masterID"));
            this.argMaster = (ABAddress)this.book.getEntry(this.argMasterID);
        }
        catch (Exception exception) {}
        try {
            this.argAddressID = -1L;
            this.argAddress = null;
            this.argAddressID = Long.parseLong(this.getArg("addressID"));
            this.argAddress = (ABAddress)this.book.getEntry(this.argAddressID);
        }
        catch (Exception exception) {}
        try {
            this.argPersonID = -1L;
            this.argPerson = null;
            this.argPersonID = Long.parseLong(this.getArg("personID"));
            this.argPerson = (ABPerson)this.book.getEntry(this.argPersonID);
        }
        catch (Exception exception) {}
    }

    void personEditor() {
        ABPerson aBPerson = this.argPerson;
        if (aBPerson == null) {
            aBPerson = new ABPerson();
        }
        this.sendHiddenFields();
        this.print.print("<table border=0 cellpadding=2 cellspacing=0> <tbody>\n");
        this.print.print("<tr><td colspan=2><b>Person:</b></td></tr>");
        this.print.print("<tr><td>First name:</td>");
        this.print.print("<td><input type=text name=pfirstName value=\"" + HttpClass.toHttp(aBPerson.getFirstName()) + "\"></td>\n");
        this.print.print("<tr><td>Name:</td>");
        this.print.print("<td><input type=text name=pname value=\"" + HttpClass.toHttp(aBPerson.getName(), BSrv) + "\"></td>\n");
        this.print.print("<tr><td>Title:</td>");
        this.print.print("<td><input type=text name=ptitle value=\"" + HttpClass.toHttp(aBPerson.getTitle(), BSrv) + "\"></td>\n");
        this.print.print("</tbody> </table>");
    }

    public void replyTo(RequestHeader requestHeader, InputStream inputStream, OutputStream outputStream) throws Throwable {
        this.init(requestHeader, outputStream);
        this.arguments = new RequestArguments(requestHeader.getURLParameters());
        this.arguments.readFrom(requestHeader.getURLPath(), "/", false);
        this.initArgs();
        String string = this.getArg("cmd");
        if (string.equals(BSrv) || this.arguments.containsKey("cancel")) {
            string = ShowPage;
        }
        if (string.startsWith("set")) {
            this.invokeMethod(string);
        } else if (string.equals("showClassInfo") || string.equals(DropBooks)) {
            this.sendHeader("text/html", -1L, true);
            this.sendHtmlStart(Title);
            this.invokeMethod(string);
            this.sendHtmlEnd();
        } else {
            this.sendHeaderAndPageList();
            this.invokeMethod(string);
            this.sendHtmlEnd();
        }
    }

    void sendButtons(int n) {
        if ((n & 1) > 0) {
            this.print.print("<input type=submit name=create value=\"New\">");
        }
        if ((n & 2) > 0) {
            this.print.print("<input type=submit name=change value=\"Change\">");
        }
        if ((n & 4) > 0) {
            this.print.print("<input type=submit name=remove value=\"Remove\">");
        }
        if ((n & 8) > 0) {
            this.print.print("<input type=submit name=removeConfirm value=\"Remove...\">");
        }
        if ((n & 0x80) > 0) {
            this.print.print("<input type=submit name=cancel value=\"Cancel\">");
        }
        this.print.print("\n");
    }

    void sendHeaderAndPageList() {
        this.sendHeader("text/html", -1L, true);
        this.sendHtmlStart(Title);
        this.showPageList();
    }

    void sendHiddenFields() {
        super.sendHiddenFields(new String[]{"pageID", "masterID", "addressID", "personID", "noFrames"});
    }

    void sendRedirect() {
        String string = this.getFullUrl(0L);
        if (!"relative".equals(SystemRB.getPropertyString("rb.httpd.address.redirect", BSrv))) {
            string = "http://" + this.header.getLocalAddress() + string;
        }
        this.sendRedirect(string);
    }

    void setArgument(String string, String string2) {
        this.arguments.put(string, string2);
        this.initArgs();
    }

    public void setMasterAddress() {
        if (this.arguments.containsKey("removeConfirm")) {
            this.sendHeaderAndPageList();
            this.showMasterAddressRemoveConfirm();
            this.sendHtmlEnd();
            return;
        }
        ABAddress aBAddress = this.argMaster;
        if (this.arguments.containsKey("create")) {
            aBAddress = null;
        }
        if (this.arguments.containsKey("remove")) {
            this.book.removeEntry(aBAddress);
        } else {
            if (aBAddress == null && !this.check()) {
                this.showLicense = true;
                this.sendRedirect();
                return;
            }
            if ((aBAddress = this.book.setAddress(aBAddress, null, null, this.arguments.get("name"), this.arguments.get("note"), this.arguments.get("email"), this.arguments.get("fax"), this.arguments.get("tel"), this.arguments.get("url"), this.arguments.get("country"), this.arguments.get("state"), this.arguments.get("city"), this.arguments.get("zip"), this.arguments.get("street"), this.arguments.get("house"))).getParent() == null && this.argPage != null) {
                this.book.setConnection(this.argPage, aBAddress, true);
            }
        }
        this.sendRedirect();
    }

    public void setPage() {
        if (this.arguments.containsKey("remove")) {
            this.book.removeEntry(this.argPage);
            this.argPage = null;
        } else {
            if (this.arguments.containsKey("create")) {
                this.argPage = null;
            }
            this.argPage = this.book.setPage(this.argPage, this.getArg("name"), BSrv);
        }
        this.argPageID = this.argPage == null ? -1L : this.argPage.getID();
        this.sendRedirect();
    }

    public void setPersonAndAddress() {
        if (this.arguments.containsKey("removePersonConfirm")) {
            this.sendHeaderAndPageList();
            this.showPerson();
            this.sendHtmlEnd();
            return;
        }
        if (this.arguments.containsKey("removeAddress")) {
            this.book.removeEntry(this.argAddress);
        }
        if (this.arguments.containsKey("removePerson")) {
            this.book.removeEntry(this.argPerson);
        }
        if (this.arguments.containsKey("setData")) {
            if (this.argAddress == null && !this.check()) {
                this.showLicense = true;
                this.sendRedirect();
                return;
            }
            ABPerson aBPerson = this.book.setPerson(this.argPerson, this.getArg("pname"), this.getArg("pfirstName"), this.getArg("ptitle"), BSrv);
            if (this.argMaster != null) {
                this.book.setAddress(this.argAddress, this.argMaster, aBPerson, this.getArg("name", 1), this.getArg("note", 1), this.getArg("email", 2), this.getArg("fax", 1), this.getArg("tel", 1), this.getArg("url", 1), this.getArg("country", 1), this.getArg("state", 1), this.getArg("city", 1), this.getArg("zip", 1), this.getArg("street", 1), this.getArg("house", 1));
            }
        }
        this.sendRedirect();
    }

    static String shortHttp(ABAddress aBAddress) {
        if (aBAddress == null) {
            return "&nbsp;";
        }
        return HttpClass.toHttp(aBAddress.getName().trim(), "&nbsp;");
    }

    static String shortHttp(ABPerson aBPerson) {
        if (aBPerson == null) {
            return "&nbsp;";
        }
        String string = aBPerson.getName().trim();
        String string2 = aBPerson.getFirstName().trim();
        if (string2.length() > 0) {
            string = String.valueOf(string) + ", " + string2;
        }
        if ((string2 = aBPerson.getTitle().trim()).length() > 0) {
            string = String.valueOf(string) + "; " + string2;
        }
        return HttpClass.toHttp(string, "&nbsp;");
    }

    void showAddress(ABAddress aBAddress, ABPage aBPage, long l, int n) {
        if (n > 0) {
            this.print.print("<tr><td colspan=" + n + ">" + RequestProcessorClass.blank + "</tr>");
        }
        this.addressPrim(aBAddress, aBPage, l);
        if (!aBAddress.isLeaf()) {
            ABAddress[] aBAddressArray = AddressBook.sortAddresses(aBAddress.getSubAddresses());
            int n2 = 0;
            while (n2 < aBAddressArray.length) {
                this.addressPrim(aBAddressArray[n2], aBPage, l);
                ++n2;
            }
        }
    }

    public void showClassInfo() {
        this.print.print("<h2><center>WWW Address Book</center></h2>");
        this.print.print("<form action=\"any\">Holding <b>" + books.size() + "</b> books." + this.transparent(10));
        this.print.print("<input type=hidden name=\"cmd\" value=\"dropBooks\">");
        this.print.print("<input type=submit value=\"Drop books\"> </form>");
    }

    public void showMasterAddressEditor() {
        this.print.print("<p>Create / edit / remove a parent address in the selected page.\n");
        this.print.print("<form action=\"any\">");
        this.print.print("<input type=hidden name=\"cmd\" value=\"setMasterAddress\">");
        ABAddress aBAddress = this.argMaster;
        int n = 139;
        if (aBAddress == null) {
            aBAddress = new ABAddress();
            n = 1;
        }
        this.addressEditorPrim(aBAddress, 256);
        this.sendButtons(n);
        this.print.print("</form >");
    }

    public void showMasterAddressRemoveConfirm() {
        this.print.print("<form action=\"any\">");
        this.print.print("<input type=hidden name=\"cmd\" value=\"setMasterAddress\">");
        this.sendHiddenFields();
        this.print.print("Do you really want to delete <ul><li>the master address and <li>its <b>" + this.argMaster.getSubAddresses().size() + "</b> connected addresses ?</ul><br>\n");
        this.sendButtons(132);
        this.print.print("</form >");
    }

    public void showMaximum() {
        this.print.print("<b>You have reached the maximum number of addresses for your current license of the address book.");
        this.print.print(" Please order an <a href=\"&/AddressBook.html#License?text/html-rb\">extended license</a>.</b>");
    }

    public void showPage() {
        if (this.argPageID > -2L) {
            this.showPage(this.argPage, this.argOptions | 0x400L);
        } else {
            ABPage[] aBPageArray = this.book.getTopPages();
            int n = 0;
            while (n < aBPageArray.length) {
                ABPage aBPage = aBPageArray[n];
                this.print.print("\nPage: " + HttpClass.toHttp(aBPage.getName()));
                this.showPage(aBPage, this.argOptions | 0x100000L);
                ++n;
            }
        }
        this.print.print("The address book currently contains " + this.book.getAddressCount() + " addresses for " + this.book.getPersonCount() + " persons.");
    }

    void showPage(ABPage aBPage, long l) {
        String string = "border=0";
        int n = 4;
        if ((l & 4L) != 0L) {
            string = "border=1";
        }
        this.print.print("\n<table " + string + " width=100% cellpadding=0 cellspacing=0> <tbody> <tr bgcolor=" + "#e6e6ff" + ">\n");
        this.print.print("<td>");
        this.sendLink("Name", this.getFullUrl(1024L), BSrv, "Activate / deactive edit icon display");
        this.print.print("</td><td>Phone");
        if ((l & 0x10000L) > 0L) {
            this.print.print("; ");
        } else {
            this.print.print("</td><td>");
            ++n;
        }
        this.sendLink("Fax", this.getFullUrl(65536L), BSrv, "Activate / deactive combined phone / fax display");
        this.print.print("</td><td>");
        this.sendLink("URL", this.getFullUrl(16384L), BSrv, "Activate / deactive url text display");
        this.print.print("/");
        this.sendLink("Email", this.getFullUrl(4096L), BSrv, "Activate / deactive email text display");
        this.print.print("</td><td>Address");
        if ((l & 0x40000L) > 0L) {
            this.print.print(" / ");
        } else {
            this.print.print("</td><td>");
            ++n;
        }
        this.sendLink("Note</", this.getFullUrl(262144L), BSrv, "Activate / deactive combined address / note display");
        this.print.print("</td></tr>\n");
        if (aBPage != null) {
            ABAddress[] aBAddressArray = AddressBook.sortAddresses(aBPage.getAddresses());
            if (aBAddressArray.length > 0) {
                this.showAddress(aBAddressArray[0], aBPage, l, 0);
            }
            int n2 = 1;
            while (n2 < aBAddressArray.length) {
                this.showAddress(aBAddressArray[n2], aBPage, l, n);
                ++n2;
            }
        }
        this.print.print("</tbody> </table> ");
        if (aBPage == null) {
            this.print.print("<br><hr><br>");
            this.print.print("Select the " + this.tagImg("help.gif", "ABSBottom") + " icon in the right top corner for a quick introduction.\n");
            this.print.print("If you are already familiar with the use of the address book, \n");
            if (this.book.getTopPages().length > 0) {
                this.print.print("select one of the address pages above or\n");
            }
            this.print.print(" use the ");
            this.print.print(this.tagImg("ABPage.gif", "ABSBottom"));
            this.print.print("icon in the left top corner to create a new address page e.g. representing a company.<br>\n");
        } else if ((l & 0x100000L) == 0L && aBPage.getAddresses().size() == 0) {
            this.print.print("<br><br><hr><br>");
            this.print.print("The selected address page is empty. <br>You may use the ");
            this.print.print(this.tagImg("ABPage.gif", "ABSBottom"));
            this.print.print(" icon in the left top corner to remove the address page. Or you may use the");
            this.print.print(this.tagImg("ABMasterNew.gif", "ABSBottom"));
            this.print.print(" icon above to add a new parent address e.g. representing a specific building/location of a company.<br>\n");
        }
        this.print.print("<br>");
    }

    public void showPageEditor() {
        ABPage aBPage = this.argPage;
        String string = BSrv;
        if (aBPage != null) {
            string = aBPage.getName();
        }
        this.print.print("<p>Create / edit / remove an address page. Remove only possible for empty pages.\n");
        this.print.print("<form action=\"any\">");
        this.print.print("<input type=hidden name=\"cmd\" value=\"setPage\">");
        this.sendHiddenFields(new String[]{"pageID", "noFrames"});
        this.print.print("<table border=0 cellpadding=2 cellspacing=0> <tbody> <tr>\n");
        this.print.print("<td>Name:");
        this.print.print("<td><input type=text name=name value=\"" + HttpClass.toHttp(string) + "\">\n");
        this.print.print("</tbody> </table>");
        int n = 1;
        if (aBPage != null) {
            n |= 0x82;
            if (aBPage.getAddresses().size() == 0) {
                n |= 4;
            }
        }
        this.sendButtons(n);
        this.print.print("</form >");
    }

    void showPageList() {
        long l = this.argPageID;
        this.print.print("\n<table border=0 width=100% cellpadding=0 cellspacing=0> <tbody><tr>\n");
        this.print.print("<td align=center colspan=2 bgcolor=#e6e6ff>\n");
        this.sendLink(this.tagImg("ABPage.gif", "left"), "?cmd=showPageEditor&pageID=" + l, BSrv, "create/edit/remove address page");
        if (this.argPage != null) {
            this.sendLink(this.tagImg("ABMasterNew.gif", "left"), "?cmd=showMasterAddressEditor&pageID=" + l, BSrv, "create new parent address in selected page");
        }
        this.sendLink(this.tagImg("help.gif", "right"), "&/AddressBook.html?text/html-rb", "_blank", "Help");
        this.sendLink(this.tagImg("pickup.gif", "right"), "?pageID=" + l, "_blank", "New window");
        this.print.print("<B>" + TitleBar + "</B>");
        this.print.print("\n</td></tr>\n<tr><td valign=top width=5%>Pages:</td>\n  <td>");
        ABPage[] aBPageArray = this.book.getTopPages();
        int n = 0;
        while (n < aBPageArray.length) {
            this.print.print(" &nbsp;&nbsp;");
            if (l == aBPageArray[n].getID()) {
                this.print.print(this.tagImg("ABBullet.gif", "none height=9 width=9"));
            } else {
                this.print.print(this.transparent(9));
            }
            this.sendLink(HttpClass.toHttp(aBPageArray[n].getName(), true), "?cmd=showPage&pageID=" + aBPageArray[n].getID(), BSrv, BSrv);
            ++n;
        }
        if (aBPageArray.length > 1) {
            this.print.print(" &nbsp;&nbsp;");
            if (l == -2L) {
                this.print.print(this.tagImg("ABBullet.gif", "none height=9 width=9"));
            } else {
                this.print.print(this.transparent(9));
            }
            this.sendLink(HttpClass.toHttp("[all]"), "?cmd=showPage&pageID=-2", BSrv, BSrv);
        }
        this.print.print("\n</td> </tr>  </tbody> </table> <br>\n");
    }

    public void showPerson() {
        ABPerson aBPerson = this.argPerson;
        if (aBPerson != null) {
            this.print.print("The person \"" + AddressBook.shortHttp(aBPerson) + "\" currently has the following addresses registered:");
            this.print.print("<table border=1 width=100% cellpadding=0 cellspacing=0> <tbody> <tr>\n");
            this.print.print("<td>&nbsp;<td>Phone:<td>Fax:<td>URL/Email:<td>Address:<td>Note:<td>Inherits from:\n");
            Enumeration enumeration = aBPerson.getAddresses().elements();
            while (enumeration.hasMoreElements()) {
                this.addressPrim((ABAddress)enumeration.nextElement(), this.argPage, 17414L);
            }
            this.print.print("</tbody> </table> <br>\n");
        }
        this.print.print("<form action=\"any\">");
        this.print.print("<input type=hidden name=\"cmd\" value=\"setPersonAndAddress\">");
        if (this.arguments.get("removePersonConfirm") != null) {
            this.sendHiddenFields();
            this.print.print("Do you really want to remove the person above and all its registered addresses ?\n");
            this.print.print("<br><input type=submit name=removePerson value=\"Remove\">");
        } else {
            this.personEditor();
            this.print.print("<br>");
            this.addressEditorPrim(this.argAddress, 32768);
            if (this.argAddress == null) {
                this.print.print("\n<input type=submit name=setData value=\"Add new address\">");
            } else {
                this.print.print("\n<input type=submit name=setData value=\"Apply\">");
                this.print.print("\n<input type=submit name=removeAddress value=\"Remove address\">");
            }
            if (aBPerson != null) {
                this.print.print("\n<input type=submit name=removePersonConfirm value=\"Remove person...\">");
            }
        }
        this.print.print("\n<input type=submit name=cancel value=\"Cancel\">");
        this.print.print("\n</form>");
        this.print.print("</body> </html>");
    }

    public void showPersonNew() {
        if (!this.check()) {
            this.showMaximum();
            return;
        }
        this.setArgument("personID", null);
        this.print.println("<form action=\"any\">");
        this.sendHiddenFields();
        this.print.print("<input type=hidden name=\"cmd\" value=\"showPerson\">");
        this.print.print("<b>New address registration</b><br><br>");
        this.print.print("You may register a new address for either a <b>new</b> person or an already <b>listed</b> person.\n");
        this.print.print("<br><br><select name=personID size=15>");
        this.print.print("<option value=-1 selected>&lt;New Person&gt;");
        ABPerson[] aBPersonArray = this.book.getPersons();
        int n = 0;
        while (n < aBPersonArray.length) {
            String string = String.valueOf(aBPersonArray[n].getName()) + ", " + aBPersonArray[n].getFirstName() + ", " + aBPersonArray[n].getTitle();
            this.print.print("<option value=" + aBPersonArray[n].getID() + ">" + HttpClass.toHttp(string));
            ++n;
        }
        this.print.print("</select><br><br>");
        this.print.print("<input type=submit name=select value=\"Register address for selected person...\">");
        this.sendButtons(128);
        this.print.print("</form>\n");
    }

    static ABAddress[] sortAddresses(VectorRB vectorRB) {
        Object[] objectArray = new ABAddress[vectorRB.size()];
        vectorRB.toArray(objectArray);
        Sort.quicksort((Object[])objectArray, (Compare)new Compare(){

            public int doCompare(Object object, Object object2) {
                ABAddress aBAddress = (ABAddress)object;
                ABAddress aBAddress2 = (ABAddress)object2;
                int n = 0;
                n = aBAddress.isLeaf() && aBAddress2.isLeaf() ? aBAddress.getPerson().compareTo(aBAddress2.getPerson()) : aBAddress.getName().compareTo(aBAddress2.getName());
                if (n == 0) {
                    n = aBAddress.getPhone().compareTo(aBAddress2.getPhone());
                }
                if (n == 0) {
                    n = aBAddress.getFax().compareTo(aBAddress2.getFax());
                }
                if (n == 0) {
                    n = aBAddress.getEmail().compareTo(aBAddress2.getEmail());
                }
                if (n == 0) {
                    n = aBAddress.getAddressString().compareTo(aBAddress2.getAddressString());
                }
                if (n == 0) {
                    n = aBAddress.getNote().compareTo(aBAddress2.getNote());
                }
                return n;
            }
        });
        return objectArray;
    }
}

