/*
 * Decompiled with CFR 0.152.
 */
package rb.httpd;

import sun.misc.Compare;

public abstract class HttpClass {
    private static final String[] htmlConversion = HttpClass.defineHtmlConversion();
    private static final String urlConversion = "$+-_.!*(),-:'/|\\?";
    public static final String ClassPrefix = "&";
    public static final String ResourcePostfix = "&";
    public static final Compare StringCompare = new Compare(){

        public int doCompare(Object object, Object object2) {
            return ((String)object).compareTo((String)object2);
        }
    };

    private static String[] defineHtmlConversion() {
        String[] stringArray = new String[]{"\"quot", "&amp", "<lt", ">gt"};
        String[] stringArray2 = new String[stringArray.length + 1];
        StringBuffer stringBuffer = new StringBuffer(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n].charAt(0));
            stringArray2[n + 1] = stringArray[n].substring(1);
            ++n;
        }
        stringArray2[0] = stringBuffer.toString();
        return stringArray2;
    }

    public static String fromURL(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '%') {
                c = (char)Integer.parseInt(string.substring(n + 1, n + 3), 16);
                n += 2;
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String toHttp(String string) {
        return HttpClass.toHttp(string, false);
    }

    public static String toHttp(String string, String string2) {
        if (string != null && string.length() > 0) {
            return HttpClass.toHttp(string);
        }
        return string2;
    }

    public static String toHttp(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '&') {
                stringBuffer.append("&amp;");
            } else if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (bl && c == ' ') {
                stringBuffer.append("&nbsp;");
            } else if (c > ' ' && c <= '~') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append("&#" + Integer.toString(c) + ";");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String toURL(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c >= '0' && c <= '9') {
                stringBuffer.append(c);
            } else if (c >= 'A' && c <= 'Z') {
                stringBuffer.append(c);
            } else if (c >= 'a' && c <= 'z') {
                stringBuffer.append(c);
            } else if (urlConversion.indexOf(c) >= 0) {
                stringBuffer.append(c);
            } else {
                stringBuffer.append("%" + Integer.toString(c, 16));
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

