/*
 * Decompiled with CFR 0.152.
 */
package rb.httpd;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import rb.httpd.HttpClass;
import rb.httpd.HttpRequestServer;
import rb.httpd.HttpServer;
import rb.httpd.RequestArguments;
import rb.httpd.RequestHeader;
import rb.httpd.RequestProcessor;
import rb.httpd.RequestProcessorClass;
import rb.util.StringUtil;
import rb.util.SystemRB;
import rb.util.VectorRB;
import sun.misc.Compare;
import sun.misc.Sort;

public class Info
extends RequestProcessorClass {
    OutputStream out;
    static final DateFormat dateTimeForm = new SimpleDateFormat("yy-MM-dd HH:mm:ss ", Locale.US);
    static final DateFormat timeForm = new SimpleDateFormat("HH:mm:ss ", Locale.US);

    static {
        dateTimeForm.setTimeZone(TimeZone.getTimeZone("GMT"));
        timeForm.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    void printClientInfo() {
        this.print.print("<h3>Client info:</h3>\n");
        this.print.print("<table border=1 cellpadding=0 cellspacing=0><tbody>\n");
        Hashtable hashtable = HttpRequestServer.getClientInfo();
        VectorRB vectorRB = new VectorRB();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            InetAddress inetAddress = (InetAddress)enumeration.nextElement();
            String string = String.valueOf(RequestProcessorClass.blank) + "</td><td>" + RequestProcessorClass.blank + inetAddress.getHostAddress() + RequestProcessorClass.blank + "</td><td>" + RequestProcessorClass.blank + dateTimeForm.format((Date)hashtable.get(inetAddress));
            try {
                string = String.valueOf(inetAddress.getHostName().toLowerCase()) + string;
            }
            catch (Exception exception) {}
            vectorRB.addElement(string);
        }
        vectorRB.sort(HttpClass.StringCompare);
        this.print.print("<tr bgcolor=#e6e6ff><td>" + RequestProcessorClass.blank + "Client name" + RequestProcessorClass.blank + "</td><td>" + RequestProcessorClass.blank + "Client IP" + RequestProcessorClass.blank + "</td><td>" + RequestProcessorClass.blank + "Last access (GMT)" + RequestProcessorClass.blank + "</td></tr>");
        int n = 0;
        while (n < vectorRB.size()) {
            this.print.print("<tr><td>" + RequestProcessorClass.blank + vectorRB.elementAt(n) + RequestProcessorClass.blank + "</td></tr>");
            ++n;
        }
        this.print.print("</tbody>  </table>\n");
    }

    void printRequest(String[] stringArray) {
        this.print.print("<h3>The request:</h3>\n");
        int n = 0;
        while (n < stringArray.length) {
            this.print.print(String.valueOf(stringArray[n]) + "\n<br>");
            ++n;
        }
    }

    void printServerInfo() {
        long l = new Date().getTime() - HttpServer.startTime.getTime();
        long l2 = l / 1000L;
        long l3 = l / 86400000L;
        String string = timeForm.format(new Date(l));
        this.print.print("<h3>Server info:</h3>\n");
        this.print.print("<table border=1 cellpadding=0 cellspacing=0>  <tbody>\n");
        this.print.print("\n<tr>  <td>&nbsp;Server time (GMT):&nbsp;<td>" + RequestProcessorClass.blank + dateTimeForm.format(new Date()) + RequestProcessorClass.blank + "</td></tr>");
        this.print.print("\n<tr>  <td>&nbsp;Server up time:&nbsp;<td>" + RequestProcessorClass.blank + l3 + "d, " + string + " = " + l2 + "s" + RequestProcessorClass.blank + "</td></tr>");
        this.print.print("\n<tr>  <td>&nbsp;Server address:&nbsp;<td>&nbsp;" + HttpClass.toHttp(HttpServer.getRedirectAddress()) + RequestProcessorClass.blank);
        String string2 = "rb.httpd.log.requests";
        String string3 = this.arguments.get(string2);
        boolean bl = SystemRB.getPropertyBoolean(string2, false);
        if (string3 != null) {
            bl = "true".equals(string3);
            SystemRB.setProperty(string2, "" + bl);
        }
        this.print.print("\n<tr><td>" + RequestProcessorClass.blank + string2 + RequestProcessorClass.blank + "=" + RequestProcessorClass.blank);
        this.sendLink("" + bl, "?cmd=showServerInfo&" + string2 + "=" + !bl, "", "Set to " + !bl);
        this.print.print(String.valueOf(RequestProcessorClass.blank) + "</td><td>" + RequestProcessorClass.blank + "If true, write requests to server log file" + RequestProcessorClass.blank + "</td></tr>");
        this.print.print("</tbody></table>");
        this.print.print("<form action=\"-\">");
        this.print.print("<input type=hidden name=cmd value=\"shutdownServer\">");
        this.print.print("Enter shutdown code:&nbsp;<input type=text name=code>&nbsp;");
        this.print.print("<input type=submit value=\"Shutdown\">");
        this.print.print("</form><br>\n");
    }

    public void replyTo(RequestHeader requestHeader, InputStream inputStream, OutputStream outputStream) throws Throwable {
        this.init(requestHeader, outputStream);
        this.out = outputStream;
        String string = StringUtil.toFirst(String.valueOf(requestHeader.getURLPath()) + "/", '/');
        if (string.length() > 1 && !string.equals(this.getClass().getName())) {
            RequestProcessor requestProcessor = HttpRequestServer.getProcessorFor(string, true);
            requestProcessor.replyTo(requestHeader, inputStream, outputStream);
            return;
        }
        this.arguments = new RequestArguments(requestHeader.getURLParameters());
        String string2 = this.arguments.get("cmd");
        if (string2 != null && !"showClassInfo".equals(string2)) {
            this.invokeMethod(string2);
            return;
        }
        this.showTitleBar();
        this.printRequest(requestHeader.getLines());
        this.print.print("</body></html>\n");
        this.print.flush();
    }

    public void showLogFile() throws IOException {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(SystemRB.logFile());
        }
        catch (Exception exception) {
            this.showTitleBar();
            this.print.print("<br><br><center>Could not open log file");
            this.print.print("</body></html>\n");
            this.print.flush();
            return;
        }
        this.sendFile(fileInputStream, this.out, "text/plain");
    }

    public void showProperties() {
        this.showTitleBar();
        Properties properties = System.getProperties();
        VectorRB vectorRB = new VectorRB();
        Object[] objectArray = ((Hashtable)properties).keys();
        while (objectArray.hasMoreElements()) {
            vectorRB.add(objectArray.nextElement());
        }
        objectArray = new String[vectorRB.size()];
        vectorRB.toArray(objectArray);
        Sort.quicksort((Object[])objectArray, (Compare)HttpClass.StringCompare);
        this.print.print("<h3>System properties:</h3>");
        this.print.print("<table cellpadding=0 cellspacing=0 border=1> <tbody>");
        int n = 0;
        while (n < objectArray.length) {
            this.print.print("\n<tr><td>" + HttpClass.toHttp((String)objectArray[n]));
            this.print.print("<td>" + HttpClass.toHttp("" + ((Hashtable)properties).get(objectArray[n])));
            ++n;
        }
        this.print.print("\n</tbody> </table>");
        this.print.print("</body></html>\n");
        this.print.flush();
    }

    public void showRequestProcessors() {
        this.showTitleBar();
        Vector vector = HttpRequestServer.getProcessorClasses();
        Object[] objectArray = new String[vector.size()];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = ((Class)vector.elementAt(n)).getName();
            ++n;
        }
        Sort.quicksort((Object[])objectArray, (Compare)HttpClass.StringCompare);
        this.print.print("<h3>Request processor classes:</h3>");
        this.print.print("<table cellpadding=0 cellspacing=0 border=1> <tbody>");
        n = 0;
        while (n < objectArray.length) {
            this.print.print("\n<tr><td>");
            this.sendLink(HttpClass.toHttp((String)objectArray[n]), String.valueOf(HttpClass.toURL((String)objectArray[n])) + "/?" + "cmd" + "=" + "showClassInfo", "", "");
            ++n;
        }
        this.print.print("\n</tbody> </table>");
        this.print.print("</body></html>\n");
        this.print.flush();
    }

    public void showServerInfo() {
        this.showTitleBar();
        this.printServerInfo();
        this.printClientInfo();
        this.print.print("</body></html>\n");
        this.print.flush();
    }

    void showTitleBar() {
        this.sendHeader("text/html", -1L, true);
        this.sendHtmlStart("Http server - Java &copy; RB");
        this.print.print("<table border=0 cellpadding=0 cellspacing=0 width=\"100%\"><tbody><tr bgcolor=#e6e6ff>");
        this.print.print("<td colspan=6 align=center><b>");
        this.sendLink(this.tagImg("pickup.gif", "right"), "", "_blank", "");
        this.print.print("Java WWW Server - Rolf Breuning</b></td></tr>");
        this.print.print("<tr align=center ><td>Pages:</td><td>");
        this.sendLink("Request", "?", "", "");
        this.print.print("</td><td>");
        this.sendLink("Server Info", "?cmd=showServerInfo", "", "");
        this.print.print("</td><td>");
        this.sendLink("Server Log", "?cmd=showLogFile", "", "");
        this.print.print("</td><td>");
        this.sendLink("System properties", "?cmd=showProperties", "", "");
        this.print.print("</td><td>");
        this.sendLink("Request processors", "?cmd=showRequestProcessors", "", "");
        this.print.print("</td><td align=right>");
        this.print.print("</td></tr></tbody></table>");
    }

    public void shutdownServer() {
        this.sendHeader("text/html", -1L, true);
        this.sendHtmlStart("Http server - Java &copy; RB");
        String string = SystemRB.getPropertyString("rb.httpd.shutdown.code", "shut-down");
        boolean bl = string.equals(this.arguments.get("code"));
        if (bl) {
            this.print.print("Server shut down\n");
        } else {
            this.print.print("Please enter correct shutdown code\n");
        }
        this.print.print("</body></html>\n");
        this.print.flush();
        if (bl) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {}
            System.exit(0);
        }
    }
}

