/*
 * Decompiled with CFR 0.152.
 */
package rb.httpd;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import rb.httpd.HttpClass;
import rb.httpd.RequestArguments;
import rb.httpd.RequestHeader;
import rb.httpd.RequestProcessor;
import rb.util.StringUtil;
import rb.util.SystemRB;

public abstract class RequestProcessorClass
extends HttpClass
implements RequestProcessor {
    RequestArguments arguments = new RequestArguments("");
    RequestHeader header;
    PrintWriter print;
    public static String Email = SystemRB.getPropertyString("rb.httpd.email", "Rolf Breuning; httpd &lt;Rolf.Breuning@t-online.de&gt;");
    public static String blank = SystemRB.getPropertyString("rb.httpd.blank", "&nbsp;");
    public static final File DefaultDirectory = RequestProcessorClass.initDirectory();
    public static final String ColorHighlight = "#e6e6ff";
    static final int FileBufferSize = 4096;

    void init(RequestHeader requestHeader, OutputStream outputStream) throws Throwable {
        this.header = requestHeader;
        this.print = new PrintWriter(outputStream);
    }

    static File initDirectory() {
        String string = new File(".").getAbsolutePath();
        try {
            string = new File(".").getCanonicalPath();
        }
        catch (IOException iOException) {}
        string = SystemRB.getPropertyString("rb.httpd.directory", string);
        File file = new File(string);
        return file;
    }

    void invokeMethod(String string) throws Throwable {
        try {
            Method method = this.getClass().getMethod(string, new Class[0]);
            method.invoke((Object)this, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            SystemRB.log(this, "Error while invoking method: " + string, throwable);
            throw throwable;
        }
    }

    public void sendFile(InputStream inputStream, OutputStream outputStream, String string) throws IOException {
        this.print = new PrintWriter(outputStream);
        if ("text/html-rb".equals(string)) {
            this.sendFileEvaluated(inputStream);
            return;
        }
        int n = inputStream.available();
        this.sendHeader(string, n, false);
        this.print.flush();
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
        outputStream.flush();
    }

    void sendFileEvaluated(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[inputStream.available()];
        new DataInputStream(inputStream).readFully(byArray);
        inputStream.close();
        String string = new String(byArray, "ISO8859_1");
        String string2 = string.toLowerCase();
        this.sendHeader("text/html", -1L, false);
        this.print.flush();
        int n = 0;
        int n2 = 0;
        int n3 = "<server-rb ".length();
        String string3 = null;
        while ((n = string2.indexOf("<server-rb ", n2)) >= 0) {
            if (string3 == null) {
                this.print.print(string.substring(n2, n));
            }
            n2 = string2.indexOf(62, n + n3) + 1;
            String[] stringArray = StringUtil.splitString(string2.substring(n + n3, n2 - 1).trim(), " ");
            if (string3 == null) {
                if (stringArray[0].equals("inserthost")) {
                    this.print.print(this.header.getLocalAddress());
                }
                if (stringArray[0].equals("insertprp")) {
                    String string4 = System.getProperty(stringArray[1]);
                    this.print.print(string4);
                }
                if (!stringArray[0].equals("skiptoprp") || (string3 = System.getProperty(stringArray[1])) == null) continue;
                string3 = string3.toLowerCase();
                continue;
            }
            if (!stringArray[0].equals("skipend") || !string3.equals(System.getProperty(stringArray[1]))) continue;
            string3 = null;
        }
        this.print.print(string.substring(n2));
        this.print.flush();
    }

    void sendHeader(String string, long l, boolean bl) {
        this.print.print("HTTP/1.0 200 OK \n");
        this.print.print("Connection: Close\n");
        if (string != null) {
            this.print.print("Content-Type: " + string + "\n");
        }
        if (bl) {
            this.print.print("Pragma: no-cache\nCache-control: no-cache\n");
        }
        if (l >= 0L) {
            this.print.print("Content-Length: " + l + "\n");
        }
        this.print.print("\n");
    }

    void sendHiddenFields(String[] stringArray) {
        int n = stringArray.length;
        while (--n >= 0) {
            String string = this.arguments.get(stringArray[n]);
            if (string == null) continue;
            this.print.print("<input type=hidden name=\"" + stringArray[n] + "\" value=\"" + string + "\">");
        }
        this.print.print("\n");
    }

    void sendHtmlEnd() {
        this.print.print("</body></html>\n");
        this.print.flush();
    }

    void sendHtmlStart(String string) {
        this.print.print("<html> <head> <title> ");
        this.print.print(string);
        this.print.print("</title> </head> \n");
        this.print.print("<body bgcolor=lightgrey link=\"#000099\" vlink=\"#000099\" alink=\"#000099\">\n");
    }

    void sendLink(String string, String string2, String string3, String string4) {
        string2 = StringUtil.replace(string2, "\u0000", this.header.getURLClassName());
        this.print.print("<a href=\"");
        this.print.print(string2);
        this.print.print("\" ");
        if (string3 != null && string3.length() > 0) {
            this.print.print("target=\"");
            this.print.print(string3);
            this.print.print("\" ");
        }
        if (string4 != null && string4.length() > 0) {
            this.print.print("onMouseOver=\"status='");
            this.print.print(StringUtil.replace(string4, "'", "\\'"));
            this.print.print("'; return true;\" onMouseOut=\"status='';return true;\"");
        }
        this.print.print(">" + string + "</a>");
    }

    void sendRedirect(String string) {
        this.print.print("HTTP/1.0 301 Redirect\n");
        this.print.print("Location: " + string + "\n");
        this.print.print("Pragma: no-cache\nCache-control: no-cache\n");
        this.print.print("\n");
        this.print.print("<html> <head> <meta http-equiv=\"refresh\" content=\"0;URL=" + string + "\"> </head>\n <body>Operation completed. <a href=\"" + string + "\">OK</a>");
        this.print.print("</body></html>\n");
        this.print.flush();
    }

    void showInvalidPath(String string) throws IOException {
        this.sendHeader("text/html", -1L, true);
        this.sendHtmlStart("Java WWW server: " + string);
        this.print.print("<h3>Invalid path</h3>\n");
        this.print.print("The requested path:\n<br>&nbsp;&nbsp;" + string + "<br>is invalid");
        this.print.print("</BODY> </HTML>\n\n");
        this.print.flush();
    }

    String tagImg(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        } else if (string2.length() > 0) {
            string2 = " align=" + string2;
        }
        return "<img src=\"&/" + string + "\"" + string2 + " border=0>";
    }

    public String toString() {
        return this.getClass().getName();
    }

    String transparent(int n) {
        return "<img src=\"&/transparent.gif\" width=" + n + " height=1 border=0 >";
    }

    public abstract void replyTo(RequestHeader var1, InputStream var2, OutputStream var3) throws Throwable;
}

