/*
 * Decompiled with CFR 0.152.
 */
package rb.util;

import java.util.Enumeration;
import rb.util.FactoryEnumeratorRB;
import rb.util.FactoryObjectRB;

public class FactoryRB {
    Object[] objects;
    int stepSize;

    public FactoryRB(int n, Object[] objectArray) {
        this.objects = objectArray;
        this.stepSize = n;
        int n2 = objectArray.length;
        if (n2 % n != 0) {
            this.throwError("Number of factory objects " + n2 + " should be a multiple of stepSize " + n);
        }
        int n3 = 0;
        while (n3 < objectArray.length) {
            int n4;
            if (!(objectArray[n3] instanceof FactoryObjectRB)) {
                this.throwError("Factory object " + n3 + " should implement FactoryObjectRB");
            }
            if (objectArray[(n4 = ((FactoryObjectRB)objectArray[n3]).factoryID()) * n] != objectArray[n3]) {
                this.throwError("Factory object " + n3 + " should have typeID() " + n3 / n);
            }
            n3 += n;
        }
    }

    public Object create(int n) {
        try {
            return ((FactoryObjectRB)this.objects[n * this.stepSize]).clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Object create(Object object, int n) {
        return this.create(this.factoryID(object, n));
    }

    public Enumeration elements(int n) {
        return new FactoryEnumeratorRB(this, n);
    }

    public int factoryID(Object object, int n) {
        int n2 = n;
        while (n2 < this.objects.length) {
            if (object.equals(this.objects[n2])) {
                return n2 / this.stepSize;
            }
            n2 += this.stepSize;
        }
        return -1;
    }

    public Object get(int n, int n2) {
        return this.objects[n * this.stepSize + n2];
    }

    public Object get(Object object, int n, int n2) {
        return this.get(this.factoryID(object, n), n2);
    }

    public int size() {
        return this.objects.length / this.stepSize;
    }

    void throwError(String string) {
        System.err.println("FactoryRB[" + (this.objects == null ? 0 : this.objects.length) + " objects, " + this.stepSize + " columns] error: ");
        System.err.println(string);
        throw new Error();
    }
}

