import java.net.*;
import java.io.*;
import java.util.*;

class HTTPInputStream extends FilterInputStream
{
	public HTTPInputStream(InputStream in) {super(in);}

	public String readLine() throws IOException
	{
		StringBuffer result=new StringBuffer();
		boolean finished=false;
		boolean cr = false;
		do
		{
			int ch=read();
			if (ch==-1) return result.toString();
			result.append((char)ch);
			if (cr&&ch==10) {result.setLength(result.length()-2); return result.toString();}
			cr=(ch==13);
		} while (!finished);
		return result.toString();
	}

	public HTTPRequest getRequest() throws IOException
	{
		HTTPRequest request=new HTTPRequest();
		String line;
		int len=0;
		while (true)
		{
			line=readLine();
			if (line.startsWith("Content-length:")) len=Integer.valueOf(line.substring(16)).intValue();
			if (line.length()>0) request.addLine(line);
			else break;
		}
		if (len>0)
		{
			byte content[]=new byte[len];
			for (int i=0;i<len;++i)
			{
				content[i]=(byte)read();
			}
			request.setContent(content);
		}
		return request;
	}
}

class HTTPOutputStream extends FilterOutputStream
{
	public HTTPOutputStream(OutputStream out) {super(out);}

	public void println(String s) throws IOException
	{
		for(int i=0;i<s.length();++i) write(s.charAt(i));
		write(13); write(10);
	}
}

class HTTPRequest
{
	Vector lines=new Vector();
	byte content[]=null; //Extra content on request (null = no content)

	public HTTPRequest() {}

	public void addLine(String line) {lines.addElement(line);}

	public void setContent(byte c[]) {content=c;}
	public byte[] getContent() {return content;}

	public Vector getLines() {return lines;}

	public void write(OutputStream os) throws IOException
	{
		for (int i=0;i<lines.size();++i)
		{
			String l=(String)lines.elementAt(i);
			byte b[]=new byte[l.length()+1];
			l.getBytes(0,l.length(),b,0);
			os.write(b,0,l.length());
			os.write('\n');
		}
		os.write('\n');
		if (content!=null) os.write(content);
	}

	String requestType()
	{
		if (lines.size()>0)
		{
			String firstLine=(String)lines.elementAt(0);
			if (firstLine.length()>0) return firstLine.substring(0,firstLine.indexOf(' ')).toUpperCase();
		}
		return "";
	}

	String getFileName(String serverRoot,String defaultFile)
	{
		if (lines.size()==0) return "";
		String firstLine=(String)lines.elementAt(0);
		String fileName=firstLine.substring(firstLine.indexOf(" ")+1);
		int n=fileName.indexOf(" ");
		if (n!=-1) fileName=fileName.substring(0,n);
		try {if(fileName.charAt(0)=='/') fileName=fileName.substring(1);} catch (StringIndexOutOfBoundsException ex) {}
		if (fileName.equals("")) fileName=defaultFile;
		if (fileName.charAt(fileName.length()-1)=='/') fileName+=defaultFile;
		return serverRoot+fileName;
	}

	String getCredentials() //Get the authorization information, in the form "user:pass", if present; else ""
	{
		for (int i=0;i<lines.size();++i)
		{
			String l=(String)lines.elementAt(i);
			if (l.startsWith("Authorization: Basic "))
			{
				String credentials=l.substring(21);
				return Base64.decode(credentials);
			}
		}
		return null;
	}

	void log()
	{
		System.out.println((new Date()).toString()+" Received the following request:");
		for (int i=0;i<lines.size();++i)
			System.out.println("  "+(String) lines.elementAt(i));
/*
		if (content!=null)
		{
			System.out.println("");
			System.out.println(content);
		}
*/
	}
}

class Base64
{
	//Encoding string (translates number into character or vice versa)
	static final String encoding="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

	//Encode a string into Base64
	public static String encode(String in)
	{
		return "";
	}

	//Decode a Base64 string
	public static String decode(String in)
	{
		StringBuffer bin=new StringBuffer("");
		for (int i=0;i<in.length();++i)
		{
			char c=in.charAt(i);
			int p=encoding.indexOf(c);
			if (p==-1) p=0;
			for (int bit=5;bit>=0;--bit) if ((p&(1<<bit))!=0) bin.append('1'); else bin.append('0');
		}
		StringBuffer chr=new StringBuffer("");
		for (int i=0;i<bin.length();i+=8)
		{
			int dec=0;
			for (int bit=7;bit>=0;--bit)
			{
				if (bin.charAt(i+7-bit)=='1') dec|=1<<bit;
			}
			chr.append((char)dec);
		}
		return chr.toString();
	}
}
