/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;
import org.w3c.jigadmin.RemoteResourceWrapper;
import org.w3c.jigadmin.editors.ControlServerHelper;
import org.w3c.jigadmin.editors.ServerEditorInterface;
import org.w3c.jigadmin.editors.ServerHelperFactory;
import org.w3c.jigadmin.editors.ServerHelperInterface;
import org.w3c.jigadmin.events.ResourceActionListener;
import org.w3c.jigadmin.events.ResourceActionSource;
import org.w3c.jigadmin.widgets.DnDTabbedPane;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.jigsaw.admin.RemoteResource;
import org.w3c.tools.sorter.Sorter;
import org.w3c.tools.widgets.Utilities;

public class ServerEditor
extends JPanel
implements ServerEditorInterface {
    protected RemoteResourceWrapper server = null;
    protected String name = null;
    protected ServerHelperInterface[] shelpers = null;

    public void setServer(RemoteResourceWrapper remoteResourceWrapper) {
        this.server = remoteResourceWrapper;
        try {
            this.initializeServerHelpers();
            this.build();
        }
        catch (RemoteAccessException remoteAccessException) {
            new Retryer(remoteAccessException).start();
        }
    }

    public Component getComponent() {
        return this;
    }

    protected void initializeServerHelpers() throws RemoteAccessException {
        Object object;
        int n;
        this.shelpers = null;
        RemoteResource remoteResource = this.server.getResource();
        String[] stringArray = remoteResource.enumerateResourceIdentifiers();
        Sorter.sortStringArray((String[])stringArray, (boolean)true);
        this.shelpers = new ServerHelperInterface[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            object = this.server.getChildResource(stringArray[n]);
            this.shelpers[n] = ServerHelperFactory.getServerHelper(stringArray[n], (RemoteResourceWrapper)((Object)object));
        }
        for (n = 0; n < this.shelpers.length; ++n) {
            if (!(this.shelpers[n] instanceof ResourceActionSource)) continue;
            object = (ResourceActionSource)((Object)this.shelpers[n]);
            for (int i = 0; i < this.shelpers.length; ++i) {
                if (i == n || !(this.shelpers[i] instanceof ResourceActionListener)) continue;
                ResourceActionListener resourceActionListener = (ResourceActionListener)((Object)this.shelpers[i]);
                object.addResourceActionListener(resourceActionListener);
            }
        }
    }

    protected void build() {
        this.removeAll();
        this.invalidate();
        this.setLayout(new BorderLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(this.name);
        titledBorder.setTitleFont(Utilities.reallyBigBoldFont);
        this.setBorder(titledBorder);
        DnDTabbedPane dnDTabbedPane = new DnDTabbedPane();
        if (this.shelpers == null) {
            return;
        }
        for (int i = 0; i < this.shelpers.length; ++i) {
            if (this.shelpers[i] instanceof ChangeListener) {
                dnDTabbedPane.addChangeListener((ChangeListener)((Object)this.shelpers[i]));
            }
            if (this.shelpers[i] instanceof ControlServerHelper) {
                this.add(this.shelpers[i].getComponent(), "North");
                continue;
            }
            String string = this.shelpers[i].getName().replace('_', ' ');
            char[] cArray = string.toCharArray();
            cArray[0] = Character.toUpperCase(cArray[0]);
            String string2 = new String(cArray);
            dnDTabbedPane.addTab(string2, null, this.shelpers[i].getComponent(), this.shelpers[i].getToolTip());
        }
        dnDTabbedPane.setSelectedIndex(0);
        this.add((Component)dnDTabbedPane, "Center");
        this.validate();
    }

    public void initialize(String string, RemoteResourceWrapper remoteResourceWrapper, Properties properties) {
        this.server = remoteResourceWrapper;
        this.name = string;
    }

    private class Retryer
    extends Thread {
        RemoteAccessException ex = null;

        public void run() {
            while (ServerEditor.this.server.getServerBrowser().shouldRetry(this.ex)) {
                try {
                    ServerEditor.this.initializeServerHelpers();
                    break;
                }
                catch (RemoteAccessException remoteAccessException) {
                    this.ex = remoteAccessException;
                }
            }
            ServerEditor.this.build();
        }

        private Retryer(RemoteAccessException remoteAccessException) {
            this.ex = remoteAccessException;
        }
    }
}

