/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigedit.filters;

import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.w3c.cvs.CvsDirectory;
import org.w3c.cvs.CvsException;
import org.w3c.jigedit.filters.DeletedEntry;
import org.w3c.jigedit.filters.PutListResource;
import org.w3c.jigedit.filters.PutedEntry;
import org.w3c.jigsaw.forms.URLDecoder;
import org.w3c.jigsaw.frames.PostableFrame;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.sorter.Sorter;

public class PutListFrame
extends PostableFrame {
    PutListResource putlist = null;

    public void registerResource(FramedResource framedResource) {
        super.registerResource(framedResource);
        if (framedResource instanceof PutListResource) {
            this.putlist = (PutListResource)framedResource;
        }
    }

    public ReplyInterface perform(RequestInterface requestInterface) throws ProtocolException, ResourceException {
        if (this.putlist == null) {
            Request request = (Request)requestInterface;
            Reply reply = request.makeReply(500);
            reply.setContent("The PutListFrame must be associated with a PutListResource only!!");
            throw new HTTPException(reply);
        }
        return super.perform(requestInterface);
    }

    protected HtmlGenerator getHtmlGenerator(String string) {
        HtmlGenerator htmlGenerator = new HtmlGenerator(string);
        this.addStyleSheet(htmlGenerator);
        return htmlGenerator;
    }

    public Reply get(Request request) throws ProtocolException, ResourceException {
        String string;
        long l;
        String string2;
        String string3;
        PutedEntry putedEntry;
        int n;
        HtmlGenerator htmlGenerator = this.getHtmlGenerator("Modified files");
        htmlGenerator.append("<h1>List of recently published files</h1>\n");
        Enumeration enumeration = this.putlist.getPublishedEntries();
        if (!enumeration.hasMoreElements()) {
            htmlGenerator.append("<center><b>No recently published file</b></center>\n");
        }
        htmlGenerator.append("<ul>\n");
        Vector vector = Sorter.sortComparableEnumeration((Enumeration)enumeration);
        for (n = 0; n < vector.size(); ++n) {
            putedEntry = (PutedEntry)((Object)vector.elementAt(n));
            string3 = putedEntry.getURL();
            htmlGenerator.append("<li><a href=\"", string3, "\">" + string3 + "</a>");
            htmlGenerator.append("<br>Published by <em>" + putedEntry.getAuthor() + "</em> on <strong>", new Date(putedEntry.getTime()).toString(), "</strong>.</li>\n");
        }
        htmlGenerator.append("</ul>\n");
        enumeration = this.putlist.getEntries();
        if (enumeration.hasMoreElements()) {
            htmlGenerator.append("<h1>List of modified files</h1>\n");
            htmlGenerator.append("<form action=\"" + request.getURL() + "\" method=\"POST\">\n");
            htmlGenerator.append("<dl>\n");
            vector = Sorter.sortComparableEnumeration((Enumeration)enumeration);
            for (n = 0; n < vector.size(); ++n) {
                putedEntry = (PutedEntry)((Object)vector.elementAt(n));
                string3 = putedEntry.getFilename();
                string2 = putedEntry.getAuthor();
                l = putedEntry.getTime();
                string = putedEntry.getURL();
                htmlGenerator.append("<dt><input type=\"checkbox\" name=\"" + putedEntry.getKey() + "\" value =\"mark\">", string3 != null ? string3 : string, "</dt><dd>");
                if (string3 != null) {
                    Object object;
                    File file = new File(string3);
                    File file2 = new File(file.getParent());
                    URL uRL = null;
                    try {
                        uRL = new URL(new URL(string), "CVS");
                    }
                    catch (Exception exception) {
                        uRL = null;
                    }
                    int n2 = -1;
                    try {
                        object = CvsDirectory.getManager((File)file2, (Properties)this.putlist.props);
                        n2 = object.status(file.getName());
                        if (uRL != null) {
                            htmlGenerator.append("Status: <a href=\"" + uRL + "\">", CvsDirectory.statusToString((int)n2), "</a><br>");
                        } else {
                            htmlGenerator.append("Status: ", CvsDirectory.statusToString((int)n2), "<br>");
                        }
                        if (string != null) {
                            htmlGenerator.append("URL: <a href=\"", string, "\">" + string + "</a><br>");
                        }
                    }
                    catch (CvsException cvsException) {
                        htmlGenerator.append("Status: <strong>CVS ERROR</strong>: ", cvsException.getMessage(), "<br>");
                    }
                    if (n2 != 7) {
                        try {
                            object = this.putlist.getServerFile(file);
                            File file3 = new File(((File)object).getParent());
                            CvsDirectory cvsDirectory = CvsDirectory.getManager((File)file3, (Properties)this.putlist.props);
                            int n3 = cvsDirectory.status(file.getName());
                            if (n3 == 5) {
                                htmlGenerator.append("Publish: (needed) <B><U>", CvsDirectory.statusToString((int)n3), "</U></B><br>");
                            } else if (n2 == 4 || n3 != 1) {
                                htmlGenerator.append("Publish: (needed) <em>", CvsDirectory.statusToString((int)n3), "</em><br>");
                            } else {
                                htmlGenerator.append("Publish: <em>", CvsDirectory.statusToString((int)n3), "</em><br>");
                            }
                        }
                        catch (CvsException cvsException) {
                            htmlGenerator.append("Publish: <strong>CVS ERROR</strong>: ", cvsException.getMessage(), "<br>");
                        }
                    }
                }
                if (string2 != null) {
                    htmlGenerator.append("Modified by <em>" + string2 + "</em> on <strong>" + new Date(l).toString() + "</strong>.<br>\n");
                    continue;
                }
                htmlGenerator.append("Modified on <strong>" + new Date(l).toString() + "</strong>.<br>\n");
            }
            htmlGenerator.append("</dl>\n");
            htmlGenerator.append("<hr noshade width=\"40%\">\n<center>\n", "<table border=\"0\">", "<tr align=\"left\"><td>\n");
            htmlGenerator.append("<b>Perform action on marked entries:</b><p>\n");
            htmlGenerator.append("<input type=\"radio\" name=\"action\" ", "value=\"publish\">Publish<br>\n");
            htmlGenerator.append("<input type=\"radio\" name=\"action\" value=\"remove\">Remove \n");
            htmlGenerator.append("</p><center>\n");
            htmlGenerator.append("<input type=\"submit\" name=\"submit\" value=\"Perform Action\">\n");
            htmlGenerator.append("</center>");
            htmlGenerator.append("</form>\n");
            htmlGenerator.append("</td></tr></table></center>\n");
        }
        if ((enumeration = this.putlist.getDelEntries()).hasMoreElements()) {
            htmlGenerator.append("<h1>List of deleted files</h1>\n");
            htmlGenerator.append("<form action=\"" + request.getURL() + "\" method=\"POST\">\n");
            htmlGenerator.append("<dl>\n");
            vector = Sorter.sortComparableEnumeration((Enumeration)enumeration);
            for (n = 0; n < vector.size(); ++n) {
                putedEntry = (DeletedEntry)((Object)vector.elementAt(n));
                if (!((DeletedEntry)putedEntry).isConfirmed()) continue;
                string3 = putedEntry.getFilename();
                string2 = putedEntry.getAuthor();
                l = putedEntry.getTime();
                string = putedEntry.getURL();
                htmlGenerator.append("<dt><input type=\"checkbox\" name=\"" + ((DeletedEntry)putedEntry).getKey() + "\" value =\"mark\">", string3 != null ? string3 : string, "</dt><dd>");
                if (string != null) {
                    htmlGenerator.append("URL: <b>" + string + "</b><br>");
                }
                if (string2 != null) {
                    htmlGenerator.append("Deleted by <em>" + string2 + "</em> on <strong>" + new Date(l).toString() + "</strong>.<br>\n");
                    continue;
                }
                htmlGenerator.append("Deleted on <strong>" + new Date(l).toString() + "</strong>.<br>\n");
            }
            htmlGenerator.append("</dl>\n");
            htmlGenerator.append("<hr noshade width=\"40%\">\n<center>\n", "<table border=\"0\">", "<tr align=\"left\"><td>\n");
            htmlGenerator.append("<b>Perform action on marked entries:</b><p>\n");
            htmlGenerator.append("<input type=\"radio\" name=\"action\" ", "value=\"delete\">Delete<br>\n");
            htmlGenerator.append("<input type=\"radio\" name=\"action\" value=\"removedel\">Remove \n");
            htmlGenerator.append("</p><center>\n");
            htmlGenerator.append("<input type=\"submit\" name=\"submit\" value=\"Perform Action\">\n");
            htmlGenerator.append("</center>");
            htmlGenerator.append("</form>\n");
            htmlGenerator.append("</td></tr></table></center>\n");
        }
        htmlGenerator.append("<h1>Putlist Configuration</h1>");
        htmlGenerator.append("<center>");
        htmlGenerator.append("<table border=\"0\"><tr align=\"left\"><td>");
        htmlGenerator.append("<form action=\"" + request.getURL() + "\" method=\"POST\">\n");
        htmlGenerator.append("<input type=\"hidden\" name=\"action\" value=\"config\">");
        htmlGenerator.append("<input type=\"checkbox\"", this.putlist.getAutoPublishFlag() ? " CHECKED " : " ", "name=\"autopublish\" value=\"mark\"> Auto Publish<br>");
        htmlGenerator.append("<input type=\"checkbox\"", this.putlist.getAutoDeleteFlag() ? " CHECKED " : " ", "name=\"autodelete\" value=\"mark\"> Auto Delete<br>");
        htmlGenerator.append("Max published entries <input type=\"text\" size=\"3\" maxlength=\"2\" name=\"mpe\" value=\"" + this.putlist.getMaxPublishedEntryStored() + "\">");
        htmlGenerator.append("</p><center>");
        htmlGenerator.append("<input type=\"submit\" name=\"submit\" value=\"Save Configuration\">");
        htmlGenerator.append("</center></form>\n");
        htmlGenerator.append("</td></tr></table>\n");
        htmlGenerator.append("</center>");
        htmlGenerator.append("<hr noshade width=\"80%\">");
        htmlGenerator.close();
        Reply reply = this.createDefaultReply(request, 200);
        reply.addPragma("no-cache");
        reply.setNoCache();
        reply.setStream(htmlGenerator);
        return reply;
    }

    protected void performAction(Request request, String string, String string2) throws HTTPException {
        if (string.equals("publish")) {
            PutedEntry putedEntry = this.putlist.getEntry(string2);
            if (putedEntry == null) {
                System.out.println("PutList: " + string2 + " not found !");
                return;
            }
            if (this.putlist.publish(putedEntry) == 4) {
                Reply reply = request.makeReply(409);
                HtmlGenerator htmlGenerator = this.getHtmlGenerator("Warning");
                htmlGenerator.append("<H1>Warning</H1> The file on publish space has been modified directly and attempting to merge has failed.<p>Ask your system administrator.");
                reply.setStream(htmlGenerator);
                throw new HTTPException(reply);
            }
        } else if (string.equals("delete")) {
            DeletedEntry deletedEntry = this.putlist.getDelEntry(string2);
            if (deletedEntry == null) {
                System.out.println("PutList: " + string2 + " not found !");
                return;
            }
            this.putlist.delete(deletedEntry);
        } else if (string.equals("remove")) {
            this.putlist.removeEntry(string2);
        } else if (string.equals("removedel")) {
            this.putlist.removeDelEntry(string2);
        } else {
            System.out.println("PutList: " + string + " unknown.");
        }
    }

    public Reply handle(Request request, URLDecoder uRLDecoder) throws ProtocolException {
        String string;
        Object object;
        String string2 = uRLDecoder.getValue("action");
        if (string2 == null) {
            Reply reply = request.makeReply(500);
            reply.setContent("You must select the action to be performed.");
            return reply;
        }
        if (string2.equals("config")) {
            if (uRLDecoder.getValue("autopublish") != null) {
                this.putlist.setAutoPublish(true);
            } else {
                this.putlist.setAutoPublish(false);
            }
            if (uRLDecoder.getValue("autodelete") != null) {
                this.putlist.setAutoDelete(true);
            } else {
                this.putlist.setAutoDelete(false);
            }
            object = null;
            object = uRLDecoder.getValue("mpe");
            if (object != null) {
                try {
                    this.putlist.setMaxPublishedEntryStored(Integer.parseInt((String)object));
                }
                catch (NumberFormatException numberFormatException) {
                    Reply reply = request.makeReply(400);
                    reply.setContent("Invalid number : " + (String)object);
                    return reply;
                }
            }
        } else {
            object = null;
            object = string2.equals("publish") || string2.equals("remove") ? this.putlist.getEntriesKeys() : this.putlist.getDelEntriesKeys();
            while (object.hasMoreElements()) {
                string = (String)object.nextElement();
                if (uRLDecoder.getValue(string) != null) {
                    System.out.println("PutList: " + string2 + " on " + string);
                    this.performAction(request, string2, string);
                    continue;
                }
                System.out.println("PutList: " + string + " not marked !");
            }
        }
        try {
            return this.get(request);
        }
        catch (ResourceException resourceException) {
            string = request.makeReply(500);
            string.setContent(resourceException.getMessage());
            return string;
        }
    }
}

