/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigedit.filters;

import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeHolder;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.FileResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.LongAttribute;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.StringAttribute;
import org.w3c.tools.sorter.Comparable;

public class PutedEntry
extends AttributeHolder
implements Comparable {
    protected static int ATTR_AUTHOR = -1;
    protected static int ATTR_URL = -1;
    protected static int ATTR_FILENAME = -1;
    protected static int ATTR_TIME = -1;

    final String getAuthor() {
        return this.getString(ATTR_AUTHOR, null);
    }

    final String getURL() {
        return this.getString(ATTR_URL, null);
    }

    final String getFilename() {
        return this.getString(ATTR_FILENAME, null);
    }

    final long getTime() {
        return this.getLong(ATTR_TIME, -1L);
    }

    public String getStringValue() {
        return Long.toString(this.getTime());
    }

    public boolean greaterThan(Comparable comparable) {
        return this.getStringValue().compareTo(comparable.getStringValue()) > 0;
    }

    protected String getKey() {
        String string = this.getFilename();
        if (string == null) {
            return this.getURL();
        }
        return string;
    }

    synchronized void update(Request request) {
        String string = (String)request.getState("org.w3c.jigsaw.auth.AuthFilter.user");
        if (string == null) {
            string = "unknown";
        }
        long l = System.currentTimeMillis();
        this.setValue(ATTR_AUTHOR, string);
        this.setValue(ATTR_TIME, new Long(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PutedEntry makeEntry(Request request) {
        ResourceReference resourceReference = request.getTargetResource();
        Resource resource = null;
        if (resourceReference != null) {
            try {
                resource = resourceReference.lock();
                PutedEntry putedEntry = new PutedEntry();
                putedEntry.setValue(ATTR_URL, request.getURL().toExternalForm());
                if (resource instanceof FileResource) {
                    putedEntry.setValue(ATTR_FILENAME, ((FileResource)resource).getFile().getAbsolutePath());
                }
                putedEntry.update(request);
                PutedEntry putedEntry2 = putedEntry;
                return putedEntry2;
            }
            catch (InvalidResourceException invalidResourceException) {
                PutedEntry putedEntry = null;
                return putedEntry;
            }
            finally {
                resourceReference.unlock();
            }
        }
        return null;
    }

    static {
        Class<?> clazz = null;
        StringAttribute stringAttribute = null;
        try {
            clazz = Class.forName("org.w3c.jigedit.filters.PutedEntry");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        stringAttribute = new StringAttribute("author", null, 2);
        ATTR_AUTHOR = AttributeRegistry.registerAttribute(clazz, (Attribute)stringAttribute);
        stringAttribute = new StringAttribute("url", null, 2);
        ATTR_URL = AttributeRegistry.registerAttribute(clazz, (Attribute)stringAttribute);
        stringAttribute = new StringAttribute("filename", null, 2);
        ATTR_FILENAME = AttributeRegistry.registerAttribute(clazz, (Attribute)stringAttribute);
        stringAttribute = new LongAttribute("time", null, 2);
        ATTR_TIME = AttributeRegistry.registerAttribute(clazz, (Attribute)stringAttribute);
    }
}

