/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.status;

import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.IntegerAttribute;

public class ThreadStatFrame
extends HTTPFrame {
    protected static Integer REFRESH_DEFAULT = new Integer(5);
    protected static int ATTR_REFRESH = -1;
    Runtime runtime = null;

    public void registerResource(FramedResource framedResource) {
        super.registerOtherResource(framedResource);
    }

    public Reply listThreads(Request request) {
        int n = Thread.activeCount();
        HtmlGenerator htmlGenerator = new HtmlGenerator("Thread status");
        htmlGenerator.meta("Refresh", this.getValue(ATTR_REFRESH, (Object)REFRESH_DEFAULT).toString());
        this.addStyleSheet(htmlGenerator);
        Thread[] threadArray = new Thread[n];
        Thread.enumerate(threadArray);
        htmlGenerator.append("<h1>Thread dump</h1>");
        htmlGenerator.append("<ul>");
        String string = this.getResource().getIdentifier();
        for (int i = 0; i < n; ++i) {
            String string2 = threadArray[i].getName();
            htmlGenerator.append("<li><a href=\"" + string + "?" + string2 + "\">" + string2 + "</a>" + (threadArray[i].isDaemon() ? "D " : "  ") + (threadArray[i].isAlive() ? "R " : "  ") + " Prio: " + threadArray[i].getPriority());
        }
        htmlGenerator.append("</ul>");
        htmlGenerator.append("<p>To kill a thread, add a <b>?</b><em>thread-name</em> to the current URL.</p>");
        htmlGenerator.append("<h2>Misc informations</h2>");
        htmlGenerator.append("<p>Total free memory: " + this.runtime.freeMemory());
        htmlGenerator.append("<p>Toal memory      : " + this.runtime.totalMemory());
        htmlGenerator.close();
        Reply reply = request.makeReply(200);
        reply.setStream(htmlGenerator);
        return reply;
    }

    protected Reply dumpThread(Request request) throws HTTPException {
        int n = Thread.activeCount();
        Thread[] threadArray = new Thread[n];
        Thread.enumerate(threadArray);
        String string = request.getQueryString();
        Thread thread = null;
        for (int i = 0; i < n; ++i) {
            if (!threadArray[i].getName().equals(string)) continue;
            thread = threadArray[i];
            break;
        }
        if (thread == null) {
            Reply reply = request.makeReply(404);
            reply.setContent("Thread " + string + " not found.");
            return reply;
        }
        thread.destroy();
        return this.listThreads(request);
    }

    public Reply get(Request request) throws HTTPException {
        if (request.hasQueryString()) {
            return this.dumpThread(request);
        }
        return this.listThreads(request);
    }

    public void initialize(Object[] objectArray) {
        super.initialize(objectArray);
        this.runtime = Runtime.getRuntime();
    }

    static {
        IntegerAttribute integerAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.status.ThreadStatFrame");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        integerAttribute = new IntegerAttribute("refresh", new Integer(5), 2);
        ATTR_REFRESH = AttributeRegistry.registerAttribute(clazz, integerAttribute);
    }
}

