/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.io;

import de.zwanzigeins.io.ExtendedBufferedOutputStreamCallback;
import de.zwanzigeins.util.HelperDebug;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ExtendedBufferedOutputStream
extends FilterOutputStream {
    private byte[] buffer = null;
    private int intBufferCount = 0;
    private boolean blnCommitted = false;
    private ExtendedBufferedOutputStreamCallback flushHandler = null;
    public String STACKTRACE_CLOSE = "";

    public ExtendedBufferedOutputStream(OutputStream out) {
        this(out, 512);
    }

    public ExtendedBufferedOutputStream(OutputStream out, int intSize) {
        super(out);
        this.buffer = new byte[intSize];
    }

    public synchronized void close() throws IOException {
        if (this.out == null) {
            return;
        }
        this.STACKTRACE_CLOSE = HelperDebug.getCallStack();
        this.flush();
        this.out.close();
        this.out = null;
    }

    private void ensureOpen() throws IOException {
        if (this.out != null) {
            return;
        }
        if (this.STACKTRACE_CLOSE.length() > 0) {
            throw new IOException("Stream closed, trace: \r\n" + this.STACKTRACE_CLOSE);
        }
        throw new IOException("Stream closed");
    }

    public synchronized void flush() throws IOException {
        if (this.out == null) {
            return;
        }
        this.flushBuffer();
        this.out.flush();
    }

    private void flushBuffer() throws IOException {
        if (this.flushHandler != null) {
            this.flushHandler.flushBefore();
            this.blnCommitted = true;
        }
        if (this.intBufferCount > 0) {
            this.out.write(this.buffer, 0, this.intBufferCount);
            this.intBufferCount = 0;
            this.blnCommitted = true;
        }
    }

    public synchronized int getBufferSize() {
        return this.buffer.length;
    }

    public synchronized boolean hasWritten() {
        return this.blnCommitted || this.intBufferCount > 0;
    }

    public synchronized boolean isCommitted() {
        return this.blnCommitted;
    }

    public synchronized void reset() {
        this.intBufferCount = 0;
        this.blnCommitted = false;
    }

    public synchronized void setBufferSize(int intNewLength) throws IOException {
        this.flushBuffer();
        this.buffer = new byte[intNewLength];
    }

    public void setHandler(ExtendedBufferedOutputStreamCallback cb) {
        this.flushHandler = cb;
    }

    public String toString() {
        return new String(this.buffer, 0, this.intBufferCount);
    }

    public synchronized void write(int i) throws IOException {
        this.ensureOpen();
        if (this.intBufferCount >= this.buffer.length) {
            this.flushBuffer();
        }
        this.buffer[this.intBufferCount++] = (byte)i;
    }

    public synchronized void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (len >= this.buffer.length) {
            this.flushBuffer();
            this.out.write(b, off, len);
            return;
        }
        if (len > this.buffer.length - this.intBufferCount) {
            this.flushBuffer();
        }
        System.arraycopy(b, off, this.buffer, this.intBufferCount, len);
        this.intBufferCount += len;
    }

    public synchronized void write_direct(int i) throws IOException {
        this.ensureOpen();
        this.out.write(i);
    }

    public synchronized void write_direct(byte[] b) throws IOException {
        this.ensureOpen();
        this.out.write(b);
    }

    public synchronized void write_direct(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        this.out.write(b, off, len);
    }
}

