/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.randomaccessdb;

import de.zwanzigeins.util.HelperFormat;
import java.io.IOException;
import java.io.RandomAccessFile;

public class HeaderRecord {
    public static final byte CURRENT_VERSION = 0;
    public static final byte HEADER_OFFSET = 64;
    private RandomAccessFile raf = null;
    public byte VERSION = 0;
    public int PAGESIZE = 0;
    public int RECS_NORMAL = 0;
    public int RECS_OVERFLOW = 0;

    public HeaderRecord(RandomAccessFile raf) {
        this.raf = raf;
    }

    public void read() throws IOException {
        this.VERSION = 0;
        this.PAGESIZE = 0;
        this.RECS_NORMAL = 0;
        this.RECS_OVERFLOW = 0;
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            if (this.raf.length() < 64L) {
                return;
            }
            long l = this.raf.getFilePointer();
            this.raf.seek(0L);
            this.VERSION = (byte)this.readFromByte(1);
            this.PAGESIZE = (int)this.readFromByte(6);
            this.RECS_NORMAL = (int)this.readFromByte(6);
            this.RECS_OVERFLOW = (int)this.readFromByte(6);
            this.raf.seek(l);
        }
    }

    private long readFromByte(int intLength) throws IOException {
        byte[] b = new byte[intLength];
        this.raf.readFully(b);
        char[] ch = new char[intLength];
        int i = 0;
        while (i < intLength) {
            ch[i] = (char)b[i];
            ++i;
        }
        String s = new String(ch).trim();
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public void write() throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            long l = this.raf.getFilePointer();
            this.raf.seek(0L);
            this.writeToByte(this.VERSION, 1);
            this.writeToByte(this.PAGESIZE, 6);
            this.writeToByte(this.RECS_NORMAL, 6);
            this.writeToByte(this.RECS_OVERFLOW, 6);
            this.writeToByte(0, 6);
            this.raf.seek(l);
        }
    }

    private void writeToByte(int intValue, int intDigits) throws IOException {
        String s = HelperFormat.rset(intValue, intDigits, ' ');
        char[] ch = new char[s.length()];
        s.getChars(0, ch.length, ch, 0);
        byte[] b = new byte[ch.length];
        int i = 0;
        while (i < b.length) {
            b[i] = (byte)ch[i];
            ++i;
        }
        this.raf.write(b);
    }
}

