/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.template;

import de.zwanzigeins.codecs.TextCodec;
import de.zwanzigeins.sort.Comparator;
import de.zwanzigeins.sort.ComparatorString;
import de.zwanzigeins.sort.HelperSort;
import de.zwanzigeins.template.TestClass;
import de.zwanzigeins.util.ByteString;
import de.zwanzigeins.util.HelperDT;
import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.HelperFormat;
import de.zwanzigeins.util.HelperIO;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class TemplateParser {
    private Hashtable hshVars = new Hashtable();
    private String strVariableError = null;
    private TextCodec tcString = null;
    private boolean blnTextCodecEnabled = true;
    private boolean blnDebug = true;
    private ByteString bytstrCurrLoopContent = null;
    private String strCurrLoopVar = null;
    private Object objCurrLoopObject = null;
    private int intIfStack = 0;
    private boolean[] blnIfTrue = null;

    public void clearVar(String strName) {
        this.hshVars.remove(strName.toLowerCase());
    }

    public void clearVars() {
        this.hshVars.clear();
    }

    public void debug(boolean blnDebug) {
        this.blnDebug = blnDebug;
    }

    public String dumpVarsAsString(String strDelimiter_1, String strDelimiter_2) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Enumeration e = this.hshVars.keys();
        while (e.hasMoreElements()) {
            String strKey = (String)e.nextElement();
            Object objVal = this.hshVars.get(strKey);
            try {
                baos.write(strKey.getBytes());
                baos.write(strDelimiter_1.getBytes());
                this.object2string(objVal, 0, 0, baos);
                baos.write(strDelimiter_2.getBytes());
            }
            catch (IOException iOException) {}
        }
        return new String(baos.toByteArray());
    }

    /*
     * Unable to fully structure code
     */
    private boolean evaluateIf(String strExpr) {
        strVar = "";
        strOpr = "";
        strCmp = "";
        i = 0;
        while (i < strExpr.length()) {
            ch = strExpr.charAt(i);
            if (i <= 0) ** GOTO lbl-1000
            switch (ch) {
                case '!': 
                case '<': 
                case '=': 
                case '>': {
                    strOpr = String.valueOf(strOpr) + ch;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (strOpr.length() == 0) {
                        strVar = String.valueOf(strVar) + ch;
                        break;
                    }
                    strCmp = String.valueOf(strCmp) + ch;
                }
            }
            ++i;
        }
        blnNegation = false;
        if (strVar.startsWith("!")) {
            blnNegation = true;
            strVar = strVar.substring(1);
        }
        objVal = this.getVariable(strVar);
        if (this.strVariableError != null) {
            return false;
        }
        if (objVal instanceof Boolean && strOpr.length() == 0) {
            strOpr = "==";
            strCmp = "true";
        }
        if (strCmp.length() > 1 && strCmp.startsWith("\"") && strCmp.endsWith("\"")) {
            strCmp = strCmp.substring(1);
            strCmp = strCmp.substring(0, strCmp.length() - 1);
        }
        intOpr = -1;
        if (strOpr.equals("==")) {
            intOpr = 0;
        }
        if (strOpr.equals(">")) {
            intOpr = 1;
        }
        if (strOpr.equals("<")) {
            intOpr = 2;
        }
        if (strOpr.equals("!=") || strOpr.equals("<>")) {
            intOpr = 3;
        }
        if (strOpr.equals("<=") || strOpr.equals("=<")) {
            intOpr = 4;
        }
        if (strOpr.equals(">=") || strOpr.equals("=>")) {
            intOpr = 5;
        }
        if (intOpr == -1) {
            throw new RuntimeException("Unknown expression " + strExpr);
        }
        blnResult = false;
        if (objVal instanceof Double) {
            dbl1 = (Double)objVal;
            dbl2 = new Double(strCmp);
            switch (intOpr) {
                case 0: {
                    blnResult = dbl1 == dbl2;
                    break;
                }
                case 1: {
                    blnResult = dbl1 > dbl2;
                    break;
                }
                case 2: {
                    blnResult = dbl1 < dbl2;
                    break;
                }
                case 3: {
                    blnResult = dbl1 != dbl2;
                    break;
                }
                case 4: {
                    blnResult = dbl1 >= dbl2;
                    break;
                }
                case 5: {
                    v0 = blnResult = dbl1 <= dbl2;
                }
            }
            return (blnResult ^ blnNegation) != false;
        }
        if (objVal instanceof Float) {
            flt1 = ((Float)objVal).floatValue();
            flt2 = new Float(strCmp).floatValue();
            switch (intOpr) {
                case 0: {
                    blnResult = flt1 == flt2;
                    break;
                }
                case 1: {
                    blnResult = flt1 > flt2;
                    break;
                }
                case 2: {
                    blnResult = flt1 < flt2;
                    break;
                }
                case 3: {
                    blnResult = flt1 != flt2;
                    break;
                }
                case 4: {
                    blnResult = flt1 >= flt2;
                    break;
                }
                case 5: {
                    v1 = blnResult = flt1 <= flt2;
                }
            }
            return (blnResult ^ blnNegation) != false;
        }
        if (objVal instanceof Integer) {
            int1 = (Integer)objVal;
            int2 = new Integer(strCmp);
            switch (intOpr) {
                case 0: {
                    blnResult = int1 == int2;
                    break;
                }
                case 1: {
                    blnResult = int1 > int2;
                    break;
                }
                case 2: {
                    blnResult = int1 < int2;
                    break;
                }
                case 3: {
                    blnResult = int1 != int2;
                    break;
                }
                case 4: {
                    blnResult = int1 >= int2;
                    break;
                }
                case 5: {
                    v2 = blnResult = int1 <= int2;
                }
            }
            return (blnResult ^ blnNegation) != false;
        }
        if (objVal instanceof Long) {
            lng1 = (Long)objVal;
            lng2 = new Long(strCmp);
            switch (intOpr) {
                case 0: {
                    blnResult = lng1 == lng2;
                    break;
                }
                case 1: {
                    blnResult = lng1 > lng2;
                    break;
                }
                case 2: {
                    blnResult = lng1 < lng2;
                    break;
                }
                case 3: {
                    blnResult = lng1 != lng2;
                    break;
                }
                case 4: {
                    blnResult = lng1 >= lng2;
                    break;
                }
                case 5: {
                    v3 = blnResult = lng1 <= lng2;
                }
            }
            return (blnResult ^ blnNegation) != false;
        }
        if (objVal instanceof Boolean) {
            bln1 = (Boolean)objVal;
            bln2 = new Boolean(strCmp);
            switch (intOpr) {
                case 0: {
                    blnResult = bln1 == bln2;
                    break;
                }
                case 3: {
                    v4 = blnResult = bln1 != bln2;
                }
            }
            return (blnResult ^ blnNegation) != false;
        }
        if (objVal instanceof String) {
            ii = ((String)objVal).compareTo(strCmp);
            switch (intOpr) {
                case 0: {
                    blnResult = ii == 0;
                    break;
                }
                case 1: {
                    blnResult = ii > 0;
                    break;
                }
                case 2: {
                    blnResult = ii < 0;
                    break;
                }
                case 3: {
                    blnResult = ii != 0;
                    break;
                }
                case 4: {
                    blnResult = ii >= 0;
                    break;
                }
                case 5: {
                    v5 = blnResult = ii <= 0;
                }
            }
            return (blnResult ^ blnNegation) != false;
        }
        throw new RuntimeException("Unknown datatype for variable " + strVar);
    }

    private boolean evaluateToken(String string, OutputStream out) throws IOException {
        String strTokenCmp = string.toLowerCase();
        if (this.strCurrLoopVar == null) {
            if (strTokenCmp.startsWith("if ")) {
                ++this.intIfStack;
                if (this.blnIfTrue[this.intIfStack - 1]) {
                    this.blnIfTrue[this.intIfStack] = this.evaluateIf(HelperExtract.getRight(string, " ").trim());
                    if (this.strVariableError != null) {
                        out.write(this.strVariableError.getBytes());
                        this.strVariableError = null;
                    }
                } else {
                    this.blnIfTrue[this.intIfStack] = false;
                }
                return true;
            }
            if (strTokenCmp.startsWith("else")) {
                if (this.intIfStack == 0 || this.blnIfTrue[this.intIfStack - 1]) {
                    this.blnIfTrue[this.intIfStack] = !this.blnIfTrue[this.intIfStack];
                }
                return true;
            }
            if (strTokenCmp.startsWith("endif")) {
                --this.intIfStack;
                return true;
            }
            if (!this.blnIfTrue[this.intIfStack]) {
                return true;
            }
        }
        if (strTokenCmp.startsWith("loop ")) {
            this.strCurrLoopVar = HelperExtract.getRight(string, " ").trim();
            return true;
        }
        if (strTokenCmp.equals("endloop")) {
            this.loop(this.strCurrLoopVar, this.bytstrCurrLoopContent.toByteArray(), out);
            this.strCurrLoopVar = null;
            return true;
        }
        if (this.strCurrLoopVar != null) {
            return false;
        }
        String strNewToken = string;
        int intVks = 0;
        int intNks = 2;
        StringTokenizer strt = new StringTokenizer(string, ",");
        if (strt.hasMoreTokens()) {
            strNewToken = strt.nextToken();
        }
        if (strt.hasMoreTokens()) {
            intNks = Integer.parseInt(strt.nextToken());
            if (strt.hasMoreTokens()) {
                intVks = intNks;
                intNks = Integer.parseInt(strt.nextToken());
            }
        }
        String strToken = strNewToken;
        Object objOutput = this.getVariable(strToken);
        if (this.strVariableError != null) {
            out.write(this.strVariableError.getBytes());
        } else {
            this.object2string(objOutput, intVks, intNks, out);
        }
        return false;
    }

    private Object getVariable(String string) {
        this.strVariableError = null;
        String strOutput = string;
        Object objOutput = this.objCurrLoopObject;
        int pp = string.indexOf(".");
        if (pp == -1) {
            if (objOutput == null) {
                objOutput = this.hshVars.get(string.toLowerCase());
            }
            if (objOutput == null) {
                return this.getVariable_debug(" [* Variable \"" + string + "\" not set*]");
            }
            return objOutput;
        }
        if (objOutput == null && (objOutput = this.hshVars.get(string.substring(0, pp).toLowerCase())) == null) {
            return this.getVariable_debug(" [*Variable \"" + string.substring(0, pp) + "\" for \"" + strOutput + "\" not set*] ");
        }
        String strToken = string.substring(pp + 1);
        if (strToken.endsWith("()")) {
            strToken = strToken.substring(0, strToken.length() - 2);
            try {
                Method meth = objOutput.getClass().getMethod(strToken, new Class[0]);
                objOutput = meth.invoke(objOutput, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return this.getVariable_debug(" [*Method \"" + strToken + "()\" not found for \"" + strOutput + "\"*] ");
            }
            catch (IllegalAccessException illegalAccessException) {
                return this.getVariable_debug(" [*Method \"" + strToken + "()\" cannot be accessed for \"" + strOutput + "\"*] ");
            }
            catch (InvocationTargetException invocationTargetException) {
                return this.getVariable_debug(" [*Method \"" + strToken + "()\" cannot be invoked for \"" + strOutput + "\"*] ");
            }
            catch (Throwable e) {
                return this.getVariable_debug(" [*Method \"" + strToken + "()\" for \"" + strOutput + "\" caused " + e.toString() + "*] ");
            }
            return objOutput;
        }
        if (strToken.equals("length") && objOutput.getClass().isArray()) {
            return new Integer(((Object[])objOutput).length);
        }
        try {
            Field field = objOutput.getClass().getField(strToken);
            objOutput = field.get(objOutput);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return this.getVariable_debug(" [*Variable \"" + strOutput + "\" not found*] ");
        }
        catch (IllegalAccessException illegalAccessException) {
            return this.getVariable_debug(" [*Variable \"" + strOutput + "\" cannot be accessed*] ");
        }
        catch (Throwable e) {
            return this.getVariable_debug(" [*Variable \"" + strOutput + "\" caused " + e.toString() + "*] ");
        }
        return objOutput;
    }

    private Object getVariable_debug(String strErrorMsg) {
        if (this.blnDebug) {
            this.strVariableError = strErrorMsg;
            return null;
        }
        this.strVariableError = null;
        return "";
    }

    private void init_process() {
        this.intIfStack = 0;
        this.blnIfTrue = new boolean[10];
        this.blnIfTrue[this.intIfStack] = true;
        this.objCurrLoopObject = null;
    }

    private void loop(String strLoopName, byte[] bytLoopBuffer, OutputStream out) throws IOException {
        Object o = this.getVariable(strLoopName);
        if (o instanceof Vector) {
            Vector v = (Vector)o;
            int i = 0;
            while (i < v.size()) {
                this.objCurrLoopObject = v.elementAt(i);
                this.process0(new ByteArrayInputStream(bytLoopBuffer), out);
                ++i;
            }
        } else {
            Object[] obj = (Object[])this.hshVars.get(strLoopName);
            if (obj == null) {
                throw new IllegalArgumentException("Template demands loop variable '" + strLoopName + "' but is not found in the variable stack");
            }
            int i = 0;
            while (i < obj.length) {
                this.objCurrLoopObject = obj[i];
                this.process0(new ByteArrayInputStream(bytLoopBuffer), out);
                ++i;
            }
        }
        this.objCurrLoopObject = null;
        this.strCurrLoopVar = null;
    }

    public static void main(String[] args) throws Throwable {
        TemplateParser tpl = new TemplateParser();
        String strQuery = "";
        strQuery = String.valueOf(strQuery) + "[%if flag1%][%loop new%][%new.strVAL%][%endloop%][%endif%]\r\n";
        strQuery = String.valueOf(strQuery) + "[%if flag2%][%loop old%][%old.strVAL%][%endloop%][%endif%]\r\n";
        Vector<TestClass> vecLoop1 = new Vector<TestClass>();
        TestClass cl = new TestClass();
        cl.strVAL = "1";
        vecLoop1.addElement(cl);
        tpl.setVar("flag1", true);
        tpl.setVar("new", vecLoop1);
        tpl.setVar("flag2", true);
        Vector<TestClass> vecLoop2 = new Vector<TestClass>();
        cl = new TestClass();
        cl.strVAL = "a";
        vecLoop2.addElement(cl);
        tpl.setVar("old", vecLoop2);
        System.out.println(tpl.process(strQuery));
    }

    private void object2string(Object object, int intVks, int intNks, OutputStream out) throws IOException {
        String o;
        if (object == null) {
            o = "<null>";
        }
        String s = null;
        if (o instanceof Boolean) {
            s = ((Boolean)((Object)o)).toString();
        } else if (o instanceof Double) {
            s = HelperFormat.number_rset((Double)((Object)o), intVks, intNks);
        } else if (o instanceof Float) {
            s = HelperFormat.number_rset(((Float)((Object)o)).floatValue(), intVks, intNks);
        } else if (o instanceof Timestamp) {
            java.util.Date d = (java.util.Date)((Object)o);
            s = d.getTime() != 0L ? String.valueOf(HelperDT.getDDMMYYYY(d)) + " " + HelperDT.getHHMMSS(d) : "";
        } else if (o instanceof Time) {
            java.util.Date d = (java.util.Date)((Object)o);
            s = d.getTime() != 0L ? HelperDT.getHHMMSS(d) : "";
        } else if (o instanceof Date) {
            java.util.Date d = (java.util.Date)((Object)o);
            s = d.getTime() != 0L ? HelperDT.getDDMMYYYY(d) : "";
        } else if (o instanceof java.util.Date) {
            java.util.Date d = (java.util.Date)((Object)o);
            s = d.getTime() != 0L ? String.valueOf(HelperDT.getDDMMYYYY(d)) + " " + HelperDT.getHHMMSS(d) : "";
        } else if (s == null) {
            s = o.toString();
            if (intVks != 0) {
                if (intNks == 0) {
                    s = HelperFormat.lset(s, intVks, ' ');
                }
                if (intNks == 1) {
                    s = HelperFormat.rset(s, intVks, ' ');
                }
            }
        }
        out.write(s.getBytes());
    }

    public synchronized String process(InputStream inputStream) {
        BufferedInputStream in;
        if (!(inputStream instanceof BufferedInputStream)) {
            in = new BufferedInputStream(inputStream);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.init_process();
            this.process0(in, baos);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
        return baos.toString();
    }

    public synchronized void process(InputStream inputStream, OutputStream out) throws IOException {
        BufferedInputStream in;
        if (!(inputStream instanceof BufferedInputStream)) {
            in = new BufferedInputStream(inputStream);
        }
        try {
            try {
                this.init_process();
                this.process0(in, out);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t.toString());
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            HelperIO.close(in);
            throw throwable;
        }
        Object var3_7 = null;
        HelperIO.close(in);
    }

    public synchronized String process(String str) {
        ByteArrayInputStream bais = new ByteArrayInputStream(str.getBytes());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.init_process();
            this.process0(bais, baos);
        }
        catch (IOException iOException) {}
        return baos.toString();
    }

    public synchronized void process(String str, OutputStream out) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(str.getBytes());
        this.init_process();
        this.process0(bais, out);
    }

    private void process0(InputStream in, OutputStream out) throws IOException {
        this.bytstrCurrLoopContent = new ByteString();
        this.strCurrLoopVar = null;
        boolean blnControlTokenOnly = false;
        StringBuffer strbToken = new StringBuffer();
        boolean blnInToken = false;
        byte bytThis = 0;
        byte bytNext = (byte)in.read();
        while ((bytThis = bytNext) != -1) {
            bytNext = (byte)in.read();
            if (bytNext == -1) {
                if (blnControlTokenOnly) break;
                out.write(bytThis);
                break;
            }
            if (bytThis == 91 && bytNext == 37 && !blnInToken) {
                blnInToken = true;
                strbToken.setLength(0);
                continue;
            }
            if (bytThis == 37 && bytNext == 93 && blnInToken) {
                blnInToken = false;
                String strToken = strbToken.toString();
                if (strToken.length() == 0) continue;
                strToken = strToken.substring(1);
                strToken = strToken.trim();
                blnControlTokenOnly |= this.evaluateToken(strToken, out);
                if (this.strCurrLoopVar != null && !strToken.toLowerCase().startsWith("loop ")) {
                    this.bytstrCurrLoopContent.append("[%" + strToken + "%]");
                }
                bytNext = (byte)in.read();
                continue;
            }
            if (blnInToken) {
                strbToken.append((char)bytThis);
                continue;
            }
            if (!this.blnIfTrue[this.intIfStack]) continue;
            switch (bytThis) {
                case 10: 
                case 13: {
                    break;
                }
                default: {
                    blnControlTokenOnly = false;
                }
            }
            if (blnControlTokenOnly) continue;
            if (this.strCurrLoopVar != null) {
                this.bytstrCurrLoopContent.append((char)bytThis);
                continue;
            }
            out.write(bytThis);
        }
    }

    public void setTextCodec(TextCodec tc) {
        this.tcString = tc;
    }

    public void setTextCodecEnabled(boolean b) {
        this.blnTextCodecEnabled = b;
    }

    public void setVar(String strName, double var) {
        this.hshVars.put(strName.toLowerCase(), new Double(var));
    }

    public void setVar(String strName, float var) {
        this.hshVars.put(strName.toLowerCase(), new Float(var));
    }

    public void setVar(String strName, int var) {
        this.hshVars.put(strName.toLowerCase(), new Integer(var));
    }

    public void setVar(String strName, long var) {
        this.hshVars.put(strName.toLowerCase(), new Long(var));
    }

    public void setVar(String strName, Object objVar) {
        if (objVar == null) {
            this.hshVars.remove(strName);
            return;
        }
        this.hshVars.put(strName.toLowerCase(), objVar);
    }

    public void setVar(String strName, String string) {
        String var;
        if (this.tcString != null && this.blnTextCodecEnabled && string != null) {
            var = this.tcString.encode(string);
        }
        if (var == null) {
            this.hshVars.remove(strName.toLowerCase());
        } else {
            this.hshVars.put(strName.toLowerCase(), var);
        }
    }

    public void setVar(String strName, boolean var) {
        this.hshVars.put(strName.toLowerCase(), new Boolean(var));
    }

    public String toString() {
        Vector<String> v = new Vector<String>();
        Enumeration e = this.hshVars.keys();
        while (e.hasMoreElements()) {
            String strKey = (String)e.nextElement();
            Object objData = this.hshVars.get(strKey);
            if (objData.getClass().isArray()) {
                Object[] objTmp = (Object[])objData;
                StringBuffer strb = new StringBuffer();
                int i = 0;
                while (i < objTmp.length) {
                    strb.append(objTmp[i].toString());
                    strb.append(", ");
                    ++i;
                }
                if (strb.length() > 2) {
                    strb.setLength(strb.length() - 2);
                }
                v.addElement(String.valueOf(strKey) + "=" + strb.toString());
                continue;
            }
            v.addElement(String.valueOf(strKey) + "=" + objData.toString());
        }
        HelperSort.quick(v, (Comparator)new ComparatorString());
        StringBuffer strb = new StringBuffer();
        int i = 0;
        while (i < v.size()) {
            strb.append((String)v.elementAt(i));
            strb.append("\r\n");
            ++i;
        }
        return strb.toString();
    }
}

