/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

import de.zwanzigeins.util.KeyData;
import java.util.Vector;

public class VectorExt
implements Cloneable {
    protected Vector vec = null;

    public VectorExt() {
        this.vec = new Vector();
    }

    public VectorExt(int initialCapacity) {
        this.vec = new Vector(initialCapacity);
    }

    public VectorExt(int initialCapacity, int capacityIncrement) {
        this.vec = new Vector(initialCapacity, capacityIncrement);
    }

    public void addElement(Object key, Object data) {
        this.vec.addElement(new KeyData(key, data));
    }

    public final int capacity() {
        return this.vec.capacity();
    }

    public synchronized Object clone() {
        try {
            VectorExt v = (VectorExt)super.clone();
            v.vec = (Vector)this.vec.clone();
            int i = this.vec.size();
            while (i-- > 0) {
                Object o = this.vec.elementAt(i);
                if (o == null) continue;
                v.vec.setElementAt(((KeyData)o).clone(), i);
            }
            return v;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("clone failed on net.conacom.awt.ConacomComponent VectorExt");
        }
    }

    public final synchronized boolean containsData(Object objData) {
        return this.indexOfData(objData) >= 0;
    }

    public final synchronized boolean containsKey(Object objKey) {
        return this.indexOfKey(objKey) >= 0;
    }

    public void copyFrom(Object[] o) {
        this.vec.removeAllElements();
        int len = o.length;
        int i = 0;
        while (i < len) {
            Object kd = o[i];
            if (!(kd instanceof KeyData)) {
                throw new IllegalArgumentException("VectorExt.copyFrom() only accepts KeyData objects");
            }
            this.vec.addElement(kd);
            ++i;
        }
    }

    public Object[] copyInto(Object[] objectArray) {
        Object[] o;
        if (objectArray == null) {
            o = new Object[this.vec.size()];
        }
        this.vec.copyInto(o);
        return o;
    }

    public synchronized Object dataAt(int intIdx) {
        KeyData kd = this.keyDataAt(intIdx);
        if (kd != null) {
            return kd.objData;
        }
        return null;
    }

    public final synchronized void ensureCapacity(int minCapacity) {
        this.vec.ensureCapacity(minCapacity);
    }

    public Object getDataForKey(Object key) {
        int index = this.indexOfKey(key);
        return index > -1 ? this.dataAt(index) : null;
    }

    public int indexOfData(Object objData) {
        int i = 0;
        while (i < this.vec.size()) {
            KeyData kd = (KeyData)this.vec.elementAt(i);
            if (kd != null && (kd.objData != null ? kd.objData.equals(objData) : objData == null)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOfKey(Object objKey) {
        int i = 0;
        while (i < this.vec.size()) {
            KeyData kd = (KeyData)this.vec.elementAt(i);
            if (kd != null && (kd.objKey != null ? kd.objKey.equals(objKey) : objKey == null)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void insertElementAt(KeyData kd, int i) {
        this.vec.insertElementAt(kd, i);
    }

    public synchronized Object keyAt(int intIdx) {
        KeyData kd = this.keyDataAt(intIdx);
        if (kd != null) {
            return kd.objKey;
        }
        return null;
    }

    public synchronized KeyData keyDataAt(int intIdx) {
        return (KeyData)this.vec.elementAt(intIdx);
    }

    public void removeAllElements() {
        this.vec.removeAllElements();
    }

    public void removeElementAt(int i) {
        this.vec.removeElementAt(i);
    }

    public void setElementAt(KeyData kd, int intIndex) {
        this.vec.setElementAt(kd, intIndex);
    }

    public void setSize(int s) {
        this.vec.setSize(s);
    }

    public int size() {
        return this.vec.size();
    }

    public final synchronized void trimToSize() {
        this.vec.trimToSize();
    }
}

