/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.mods;

import de.zwanzigeins.util.HelperPath;
import de.zwanzigeins.util.LogContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.mods.IntermediateModuleData;
import net.zerotoaster.httpd.mods.Mod_Base;
import net.zerotoaster.httpd.mods.Mod_Content_Selection;
import net.zerotoaster.httpd.request.Http_Request;
import net.zerotoaster.httpd.response.Http_Response;
import net.zerotoaster.httpd.util.Helper;

public class Mod_Error_Response
extends Mod_Base {
    private Http_Request httpREQ = null;
    private static Object objTrackFileLock = new Object();

    public Mod_Error_Response(Configuration cnfConfig, LogContext logContext) {
        super(cnfConfig, logContext);
    }

    private String getDefaultMessage(int intCode) {
        switch (intCode) {
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Moved Temporarily";
            }
            case 303: {
                return "See Other";
            }
            case 304: {
                return "Not Modified";
            }
            case 305: {
                return "Use Proxy";
            }
            case 306: {
                return "(Unused)";
            }
            case 307: {
                return "Temporary Redirect";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 402: {
                return "Payment Required";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Ressource not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 408: {
                return "Request Timeout";
            }
            case 409: {
                return "Conflict";
            }
            case 410: {
                return "Gone";
            }
            case 411: {
                return "Length Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 414: {
                return "Request-URI Too Long";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 416: {
                return "Requested Range Not Satisfiable";
            }
            case 417: {
                return "Expectation Failed";
            }
            case 499: {
                return "The requested URL is a directory, and directory accessing is disabled on this server.";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
            case 506: {
                return "Servlet engine overloaded";
            }
        }
        return "No message text available";
    }

    public boolean processREQ(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        return false;
    }

    public boolean processRES(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        if (httpRES.intStatusCode == 0) {
            return false;
        }
        if (httpRES.strStatusCode == null || httpRES.strStatusCode.length() == 0) {
            httpRES.strStatusCode = this.getDefaultMessage(httpRES.intStatusCode);
        }
        httpRES.strConnection = "close";
        if (httpRES.intStatusCode >= 300 && httpRES.intStatusCode <= 399) {
            httpRES.lngContentLength = -1L;
            httpRES.strContentType = "";
            httpRES.lngLastModified = -1L;
            this.writeResponseHeader(httpREQ, imd, httpRES);
            return true;
        }
        if (httpRES.intStatusCode >= 400 && httpRES.intStatusCode <= 499) {
            return this.processRES_File(httpREQ, imd, httpRES);
        }
        if (httpRES.intStatusCode >= 500 && httpRES.intStatusCode <= 599) {
            return this.processRES_File(httpREQ, imd, httpRES);
        }
        return false;
    }

    private boolean processRES_File(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        this.trackError(httpREQ, imd, httpRES);
        String strPath = null;
        Mod_Content_Selection mcTmp = new Mod_Content_Selection(this.cnfConfig, this.logContext);
        IntermediateModuleData imdTmp = (IntermediateModuleData)imd.clone();
        imdTmp.strFileToServe = "";
        strPath = imd.iniVHOST.getPropertyString(this.MOD_NAME, "error_pages_vhost", "error_pages");
        if (strPath.length() > 0) {
            if (!HelperPath.isAbsolutePath((String)strPath)) {
                strPath = HelperPath.pathFixup((String)(String.valueOf(imd.strHTDOCS) + File.separator + strPath), (String)File.separator);
            }
            strPath = HelperPath.pathFixup((String)(String.valueOf(strPath) + File.separator), (String)File.separator);
            imdTmp.strTriedRessources = new String[]{String.valueOf(strPath) + String.valueOf(httpRES.intStatusCode) + ".html"};
            mcTmp.processREQ(httpREQ, imdTmp, httpRES);
            if (imdTmp.strFileToServe.length() != 0) {
                this.sendFile(httpREQ, imdTmp, httpRES);
                mcTmp.dispose();
                return true;
            }
        }
        if ((strPath = imd.iniVHOST.getPropertyString(this.MOD_NAME, "error_pages_default", "error_pages")).length() > 0) {
            if (!HelperPath.isAbsolutePath((String)strPath)) {
                strPath = HelperPath.pathFixup((String)(String.valueOf(imd.strZT_ROOT) + File.separator + strPath), (String)File.separator);
            }
            strPath = HelperPath.pathFixup((String)(String.valueOf(strPath) + File.separator), (String)File.separator);
            imdTmp.strTriedRessources = new String[]{String.valueOf(strPath) + String.valueOf(httpRES.intStatusCode) + ".html"};
            mcTmp.processREQ(httpREQ, imdTmp, httpRES);
            if (imdTmp.strFileToServe.length() != 0) {
                this.sendFile(httpREQ, imdTmp, httpRES);
                mcTmp.dispose();
                return true;
            }
        }
        mcTmp.dispose();
        this.logContext.write("! Failed to find a error webpage for error " + String.valueOf(httpRES.intStatusCode) + ":" + "\r\n" + httpREQ.toString());
        StringBuffer strb = new StringBuffer();
        String[] strHeader = httpRES.getHeader();
        int i = 0;
        while (i < strHeader.length) {
            strb.append(strHeader[i]);
            ++i;
        }
        int ll = strb.length();
        strb.append("<html><head><title>Error</title></head>\r\n<body>\r\n<h2>");
        strb.append(httpRES.intStatusCode + " " + this.getDefaultMessage(httpRES.intStatusCode));
        strb.append("</h2>\r\n<!-- autogenerated by Mod_Error_Response -->\r\n</body></html>\r\n");
        try {
            httpRES.osResponse.write(strb.toString().getBytes());
            httpRES.osResponse.flush();
            httpRES.lngTransferredBytes = strb.length() - ll;
        }
        catch (IOException iOException) {
        }
        catch (Throwable t) {
            this.logContext.write(t);
        }
        return true;
    }

    private void sendFile(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        String strExt = "default";
        int pp = imd.strFileToServe.lastIndexOf(".");
        if (pp != -1) {
            strExt = imd.strFileToServe.substring(pp + 1).trim().toLowerCase();
        }
        httpRES.strContentType = imd.iniVHOST.getPropertyString("MIME", strExt);
        if (httpRES.strContentType.length() == 0) {
            httpRES.strContentType = imd.iniVHOST.getPropertyString("MIME", "default");
        }
        FileInputStream fis = null;
        try {
            try {
                File fl = new File(imd.strFileToServe);
                httpRES.lngLastModified = -1L;
                httpRES.lngContentLength = fl.length();
                this.writeResponseHeader(httpREQ, imd, httpRES);
                fis = new FileInputStream(imd.strFileToServe);
                byte[] buffer = new byte[this.cnfConfig.intStreamBufferSize];
                int i = 0;
                while ((i = fis.read(buffer)) != -1) {
                    httpRES.osResponse.write(buffer, 0, i);
                    httpRES.lngTransferredBytes += (long)i;
                }
            }
            catch (IOException iOException) {
            }
            catch (Throwable e) {
                this.logContext.write(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            Helper.close(fis);
            throw throwable;
        }
        Object var7_13 = null;
        Helper.close(fis);
    }

    private void trackError(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        int[] intTrackNumbers = imd.iniVHOST.getPropertyIntAsArray(this.MOD_NAME, "track_errors");
        if (intTrackNumbers == null || intTrackNumbers.length == 0) {
            return;
        }
        String strTrackFile = imd.iniVHOST.getPropertyString(this.MOD_NAME, "track_file", "logfiles" + File.separator + "errors.log");
        if (strTrackFile.length() == 0) {
            return;
        }
        boolean blnFound = false;
        int i = 0;
        while (i < intTrackNumbers.length) {
            boolean bl = blnFound = httpRES.intStatusCode == intTrackNumbers[i];
            if (blnFound) break;
            ++i;
        }
        if (!blnFound) {
            return;
        }
        StringBuffer strb = new StringBuffer(180);
        strb.append(httpRES.intStatusCode);
        strb.append(" URL=\"");
        strb.append(httpREQ.strURL);
        strb.append("\" Referer=\"");
        strb.append(httpREQ.strReferer);
        strb.append("\"");
        PrintWriter pw = null;
        try {
            Object object = objTrackFileLock;
            synchronized (object) {
                pw = new PrintWriter(new FileWriter(strTrackFile, true));
                pw.println(strb.toString());
                pw.close();
            }
        }
        catch (IOException iOException) {
            this.logContext.write("? Cannot write trackfile entry in file " + strTrackFile);
            Helper.close(pw);
        }
    }
}

